/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql;

import org.argouml.language.sql.TableDefinition;

public class ColumnDefinition {
    private String datatype;
    private String defaultValue;
    private String name;
    private Boolean nullable;
    private Integer length;
    private Integer nbDecimal;
    private String comment;
    private TableDefinition table;

    public ColumnDefinition() {
    }

    public ColumnDefinition(TableDefinition table, String name) {
        this();
        this.name = name;
        this.table = table;
        table.addColumnDefinition(this);
    }

    public ColumnDefinition(String datatype, String name, Boolean nullable) {
        this();
        this.datatype = datatype;
        this.name = name;
        this.nullable = nullable;
    }

    public static ColumnDefinition findOrCreateColumnDefinition(TableDefinition table, String columnName) {
        ColumnDefinition ret = table.getColumnDefinition(columnName);
        if (ret == null) {
            ret = new ColumnDefinition(table, columnName);
        }
        return ret;
    }

    public String getDatatype() {
        return this.datatype;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setDatatype(String datatype) {
        this.datatype = datatype;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNullable(Boolean nullable) {
        this.nullable = nullable;
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Integer getNbDecimal() {
        return this.nbDecimal;
    }

    public void setNbDecimal(Integer nbDecimal) {
        this.nbDecimal = nbDecimal;
    }

    public TableDefinition getTable() {
        return this.table;
    }

    public void setTable(TableDefinition table) {
        this.table = table;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }
}

