/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.sql.reveng;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.argouml.language.sql.ColumnDefinition;
import org.argouml.language.sql.ForeignKeyDefinition;
import org.argouml.language.sql.TableDefinition;
import org.argouml.language.sql.reveng.Modeller;
import org.argouml.language.sql.reveng.ModellerLevel;
import org.argouml.model.Model;

public class ModellerC
implements ModellerLevel {
    private Modeller modellerSource;

    public ModellerC(Modeller modeller) {
        this.modellerSource = modeller;
    }

    @Override
    public void genereInModele() {
        HashMap<String, Object> classes = new HashMap<String, Object>();
        ArrayList<ForeignKeyDefinition> foreign_keys = new ArrayList<ForeignKeyDefinition>();
        for (TableDefinition table : this.modellerSource.getTablesByName().values()) {
            boolean writeClass = true;
            if (!writeClass) continue;
            Object curClass = this.modellerSource.addClass(table);
            classes.put(table.getName(), curClass);
            for (ColumnDefinition c : table.getColumnDefinitions()) {
                String attributeName = c.getName();
                String typeSpec = this.modellerSource.getMappingDataTypeSQLToUML(c.getDatatype());
                for (ForeignKeyDefinition fk : table.getFkDefinitions()) {
                    if (!fk.hasColumnInTable(attributeName)) continue;
                    attributeName = null;
                    break;
                }
                if (attributeName == null) continue;
                Object packageOfType = this.modellerSource.getModel();
                Object mClassifierType = null;
                if (typeSpec != null) {
                    mClassifierType = this.modellerSource.getOrAddDatatype(packageOfType, typeSpec);
                }
                Object mAttribute = this.modellerSource.buildAttribute(curClass, mClassifierType, attributeName);
                String multiplicity = "1";
                if (c.getNullable() == null || c.getNullable().booleanValue()) {
                    multiplicity = "0..1";
                }
                Model.getCoreHelper().setMultiplicity(mAttribute, multiplicity);
                if (c.getDefaultValue() == null) continue;
                Object newInitialValue = Model.getDataTypesFactory().createExpression("Sql", c.getDefaultValue());
                Model.getCoreHelper().setInitialValue(mAttribute, newInitialValue);
            }
            foreign_keys.addAll(table.getFkDefinitions());
        }
        for (ForeignKeyDefinition fk : foreign_keys) {
            String name = fk.getForeignKeyName();
            int typeAsso = 1;
            String multiplicity = "1";
            if (fk.getReferencesTable() != fk.getTable()) {
                List<String> fkTable = fk.getColumnNames();
                List<String> pkTable = fk.getTable().getPrimaryKeyFields();
                List<String> pkRef = fk.getReferencesTable().getPrimaryKeyFields();
                if (fkTable.size() > 0 && pkTable.size() > 0 && fkTable.containsAll(pkTable) && pkTable.containsAll(fkTable) && pkRef.size() > 0 && fkTable.containsAll(pkTable) && pkTable.containsAll(fkTable)) {
                    typeAsso = 2;
                }
            }
            for (ColumnDefinition columnDefinition : fk.getColumns()) {
                if (columnDefinition.getNullable() != null && !columnDefinition.getNullable().booleanValue()) continue;
                multiplicity = "0..1";
                break;
            }
            Object mClassifier = classes.get(fk.getReferencesTable().getName());
            Object mClassifierEnd = classes.get(fk.getTable().getName());
            String nameAssociationEnd = name;
            if (typeAsso == 2) {
                Object mGeneralization = this.modellerSource.getGeneralization(this.modellerSource.getModel(), mClassifier, mClassifierEnd);
                Model.getCoreHelper().setName(mGeneralization, nameAssociationEnd);
                continue;
            }
            if (typeAsso != 1) continue;
            Object mAssociationEnd = this.modellerSource.getAssociationEnd(name, mClassifier, mClassifierEnd);
            Model.getCoreHelper().setMultiplicity(mAssociationEnd, multiplicity);
            Model.getCoreHelper().setType(mAssociationEnd, mClassifier);
            if (fk.getColumns().size() == 1) {
                nameAssociationEnd = fk.getColumns().get(0).getName();
            }
            Model.getCoreHelper().setName(mAssociationEnd, nameAssociationEnd);
            if (mClassifier.equals(mClassifierEnd)) continue;
            Model.getCoreHelper().setNavigable(mAssociationEnd, true);
        }
    }
}

