/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.argouml.sequence2.diagram.FigHead;
import org.argouml.sequence2.diagram.FigLifeLine;
import org.argouml.sequence2.diagram.FigMessage;
import org.argouml.sequence2.diagram.FigMessageComparator;
import org.argouml.sequence2.diagram.SelectionClassifierRole;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.ui.FigEmptyRect;
import org.argouml.uml.diagram.ui.FigNodeModelElement;
import org.tigris.gef.base.Geometry;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FigClassifierRole
extends FigNodeModelElement {
    private FigEmptyRect emptyFig;
    private FigHead headFig;
    private FigLifeLine lifeLineFig;
    private int offset = 0;
    private int minimumHeight;

    public FigClassifierRole(Object owner, Rectangle bounds, DiagramSettings settings) {
        super(owner, bounds, settings);
        this.initialize();
        if (bounds != null) {
            this.setLocation(bounds.x, bounds.y);
        }
    }

    protected Fig createBigPortFig() {
        return new FigClassifierRolePort();
    }

    private void initialize() {
        this.emptyFig = new FigEmptyRect(this.getX(), this.getY(), this.getWidth(), this.offset);
        this.emptyFig.setLineWidth(0);
        this.headFig = new FigHead(this.getOwner(), this.getSettings(), (Fig)this.getStereotypeFig(), this.getNameFig());
        this.headFig.setBounds(this.getX(), this.getY() + this.offset, this.getWidth(), this.headFig.getHeight());
        this.lifeLineFig = new FigLifeLine(this.getOwner(), new Rectangle(this.headFig.getX(), this.getY() + this.offset + this.headFig.getHeight() - this.getLineWidth(), 0, 0), this.getSettings());
        this.addFig(this.getBigPort());
        this.getBigPort().setVisible(false);
        this.minimumHeight = this.headFig.getMinimumHeight() + 10;
        this.addFig((Fig)this.emptyFig);
        this.addFig((Fig)this.lifeLineFig);
        this.addFig((Fig)this.headFig);
        this.createActivations();
    }

    protected int getNotationProviderType() {
        return 13;
    }

    protected void setBoundsImpl(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        int ww = Math.max(w, this.headFig.getMinimumSize().width);
        this.emptyFig.setBounds(x, y, ww, this.offset);
        this.headFig.setBounds(x, y + this.offset, ww, this.headFig.getMinimumHeight());
        this.lifeLineFig.setBounds(x, y + this.offset + this.headFig.getHeight() - this.lifeLineFig.getLineWidth(), ww, h - this.offset - this.headFig.getHeight());
        this.getBigPort().setBounds(x, y, ww, h);
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this.updateEdges();
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void superTranslate(int dx, int dy) {
        super.superTranslate(dx, 0);
    }

    private void updateHeadOffset() {
        FigMessage createMessage = this.getFirstCreateFigMessage();
        if (createMessage != null) {
            int y = createMessage.getFirstPoint().y;
            if (y > 0) {
                this.offset = y - (this.getY() + this.headFig.getHeight() / 2);
            }
        } else {
            this.offset = 0;
        }
    }

    private FigMessage getFirstCreateFigMessage() {
        List<FigMessage> messages = this.getFigMessages();
        FigMessage createMessage = null;
        for (FigMessage message : messages) {
            if (!message.getDestFigNode().equals((Object)this) || !message.isCreateMessage()) continue;
            createMessage = message;
            break;
        }
        return createMessage;
    }

    public Dimension getMinimumSize() {
        this.updateMinimumHeight();
        return new Dimension(this.headFig.getMinimumWidth(), this.minimumHeight);
    }

    private void updateMinimumHeight() {
        int yMax = this.getY();
        List figsEdges = this.getFigEdges();
        FigMessage createMessage = this.getFirstCreateFigMessage();
        if (figsEdges.size() == 1 && createMessage != null) {
            this.minimumHeight = this.headFig.getMinimumSize().height + this.offset + 10;
        } else {
            for (Fig fig : figsEdges) {
                if (!(fig instanceof FigMessage) || ((FigMessage)fig).getDestFigNode() == null || ((FigMessage)fig).getSourceFigNode() == null || ((FigMessage)fig).getY() <= yMax) continue;
                yMax = ((FigMessage)fig).getY();
            }
            this.minimumHeight = yMax - this.getY() + 10;
        }
    }

    protected void updateBounds() {
        if (!this.isCheckSize()) {
            return;
        }
        Rectangle bbox = this.getBounds();
        Dimension minSize = this.getMinimumSize();
        bbox.width = Math.max(bbox.width, minSize.width);
        bbox.height = Math.max(bbox.height, minSize.height);
        this.setBounds(bbox.x, bbox.y, bbox.width, bbox.height);
    }

    public void removeFigEdge(FigEdge edge) {
        super.removeFigEdge(edge);
        if (edge instanceof FigMessage) {
            FigMessage figMessage = (FigMessage)edge;
            this.positionHead(figMessage);
            this.createActivations();
        }
    }

    public void addFigEdge(FigEdge edge) {
        super.addFigEdge(edge);
        if (edge instanceof FigMessage) {
            FigMessage mess = (FigMessage)edge;
            if (mess.isSelfMessage()) {
                mess.convertToArc();
            }
            this.positionHead(mess);
        }
    }

    void positionHead(FigMessage message) {
        if (message.isCreateMessage() && ((Object)((Object)this)).equals(message.getDestFigNode()) && !((Object)((Object)this)).equals(message.getSourceFigNode())) {
            this.updateHeadOffset();
            this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
    }

    public List<FigMessage> getFigMessages() {
        ArrayList<FigMessage> completeMessages = new ArrayList<FigMessage>(10);
        for (Object o : this.getFigEdges()) {
            FigMessage fm;
            if (!(o instanceof FigMessage) || (fm = (FigMessage)((Object)o)).getPoints().length <= 1 || fm.getDestFigNode() == null || fm.getSourceFigNode() == null) continue;
            completeMessages.add(fm);
        }
        Collections.sort(completeMessages, new FigMessageComparator());
        return completeMessages;
    }

    void createActivations() {
        this.lifeLineFig.createActivations(this.getFigMessages());
        this.forceRepaintShadow();
    }

    public void setFillColor(Color color) {
        this.headFig.setFillColor(color);
        this.lifeLineFig.setFillColor(color);
    }

    public Color getFillColor() {
        return this.headFig.getFillColor();
    }

    public void setFilled(boolean filled) {
        this.headFig.setFilled(filled);
    }

    public void setLineWidth(int w) {
        this.headFig.setLineWidth(w);
        this.getBigPort().setLineWidth(0);
    }

    public Selection makeSelection() {
        return new SelectionClassifierRole((Fig)this);
    }

    class FigClassifierRolePort
    extends FigRect {
        FigClassifierRolePort() {
            super(0, 0, 0, 0, null, null);
            this.setLineWidth(0);
        }

        public Point getClosestPoint(Point anotherPt) {
            int width = 20;
            int y = anotherPt.y;
            int x = this.getX() + this.getWidth() / 2 - width / 2;
            if (anotherPt.x > x + width) {
                x += width;
            }
            if (y < this.getY()) {
                y = this.getY();
                x = Geometry.ptClosestTo((Rectangle)((FigClassifierRole)FigClassifierRole.this).headFig.getBounds(), (Point)anotherPt).x;
            } else if (y < FigClassifierRole.this.lifeLineFig.getY()) {
                x = Geometry.ptClosestTo((Rectangle)((FigClassifierRole)FigClassifierRole.this).headFig.getBounds(), (Point)anotherPt).x;
            } else if (y > this.getY() + this.getHeight()) {
                y = FigClassifierRole.this.headFig.getY() + FigClassifierRole.this.getHeight();
            }
            return new Point(x, y);
        }
    }
}

