/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.sequence2.diagram;

import java.awt.Rectangle;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.argouml.sequence2.diagram.FigActivation;
import org.argouml.sequence2.diagram.FigClassifierRole;
import org.argouml.sequence2.diagram.FigMessage;
import org.argouml.sequence2.diagram.FigMessageComparator;
import org.argouml.uml.diagram.DiagramSettings;
import org.argouml.uml.diagram.ui.ArgoFigGroup;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigRect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class FigLifeLine
extends ArgoFigGroup {
    private static final long serialVersionUID = 466925040550356L;
    private FigLine lineFig;
    private FigRect rectFig;
    private List<FigActivation> activations;
    private List<FigActivation> stackedActivations;
    static final int WIDTH = 150;
    static final int HEIGHT = 500;

    FigLifeLine(Object owner, Rectangle bounds, DiagramSettings settings) {
        super(owner, settings);
        this.initialize(bounds.x, bounds.y);
    }

    private void initialize(int x, int y) {
        this.activations = new LinkedList<FigActivation>();
        this.stackedActivations = new LinkedList<FigActivation>();
        this.rectFig = new FigRect(x, y, 150, 500);
        this.rectFig.setFilled(false);
        this.rectFig.setLineWidth(0);
        this.lineFig = new FigLine(x + 75, y, x + 75, y + 500, LINE_COLOR);
        this.lineFig.setDashed(true);
        this.lineFig.setLineWidth(1);
        this.addFig((Fig)this.rectFig);
        this.addFig((Fig)this.lineFig);
    }

    synchronized void createActivations(List<FigMessage> messages) {
        this.clearActivations();
        Collections.sort(messages, new FigMessageComparator());
        this.activations = this.createStandardActivations(messages);
        this.stackedActivations = this.createStackedActivations(messages);
        this.addActivations(this.activations);
        this.addActivations(this.stackedActivations);
        this.calcBounds();
    }

    private void addActivations(List<FigActivation> activationFigs) {
        for (FigActivation figAct : activationFigs) {
            figAct.setFillColor(this.getFillColor());
            this.addFig((Fig)figAct);
        }
    }

    private List<FigActivation> createStandardActivations(List<FigMessage> figMessages) {
        LinkedList<FigActivation> newActivations = new LinkedList<FigActivation>();
        FigActivation currentActivation = null;
        if (!this.hasIncomingCallActionFirst(figMessages)) {
            currentActivation = this.createActivationFig(this.getOwner(), this.lineFig.getX(), this.lineFig.getY(), this.lineFig.getWidth(), this.lineFig.getHeight(), this.getSettings(), null);
        }
        int activationsCount = 0;
        for (FigMessage figMessage : figMessages) {
            int ySender = 0;
            if (figMessage.isSelfMessage()) continue;
            if (this.isIncoming(figMessage)) {
                if (currentActivation == null) {
                    if (figMessage.isSynchCallMessage()) {
                        ySender = figMessage.getFinalY();
                        currentActivation = this.createActivationFig(this.getOwner(), this.lineFig.getX(), ySender, 0, 0, this.getSettings(), figMessage);
                        ++activationsCount;
                    } else if (figMessage.isCreateMessage()) {
                        currentActivation = this.createActivationFig(this.getOwner(), this.lineFig.getX(), this.lineFig.getY(), 0, 0, this.getSettings(), figMessage);
                        ++activationsCount;
                    }
                } else if (figMessage.isSynchCallMessage() && this.isSameClassifierRoles(currentActivation.getActivatingMessage(), figMessage)) {
                    ++activationsCount;
                } else if (figMessage.isDeleteMessage()) {
                    ySender = figMessage.getFinalY();
                    currentActivation.setHeight(ySender - currentActivation.getY());
                    currentActivation.setDestroy(true);
                    this.lineFig.setHeight(ySender - this.getY());
                    newActivations.add(currentActivation);
                    currentActivation = null;
                }
            }
            if (!this.isOutgoing(figMessage) || currentActivation == null || !currentActivation.isActivatorEnd(figMessage) || --activationsCount != 0) continue;
            ySender = figMessage.getStartY();
            currentActivation.setHeight(ySender - currentActivation.getY());
            newActivations.add(currentActivation);
            currentActivation = null;
        }
        if (currentActivation != null) {
            currentActivation.setHeight(this.getHeight() - (currentActivation.getY() - this.getY()));
            newActivations.add(currentActivation);
        }
        return newActivations;
    }

    private boolean isSameClassifierRoles(FigMessage mess1, FigMessage mess2) {
        return mess1 != null && mess1.getDestFigNode() == mess2.getDestFigNode() && mess1.getSourceFigNode() == mess2.getSourceFigNode();
    }

    private boolean isIncoming(FigMessage messageFig) {
        return messageFig.getDestFigNode().getOwner() == this.getOwner();
    }

    private boolean isOutgoing(FigMessage messageFig) {
        return messageFig.getSourceFigNode().getOwner() == this.getOwner();
    }

    private FigActivation createActivationFig(Object owner, int x, int y, int w, int h, DiagramSettings settings, FigMessage messageFig) {
        return new FigActivation(owner, new Rectangle(x, y, w, h), settings, messageFig);
    }

    private List<FigActivation> createStackedActivations(List<FigMessage> figMessages) {
        LinkedList<FigActivation> newActivations = new LinkedList<FigActivation>();
        FigActivation currentAct = null;
        for (FigMessage figMessage : figMessages) {
            int ySender = 0;
            if (!figMessage.isSelfMessage()) continue;
            if (figMessage.isSynchCallMessage()) {
                ySender = figMessage.getFinalY();
                currentAct = new FigActivation(figMessage.getOwner(), new Rectangle(this.lineFig.getX() + 10, ySender, 0, 0), this.getSettings(), figMessage, false);
                continue;
            }
            if (currentAct == null || !figMessage.isReplyMessage()) continue;
            ySender = figMessage.getStartY();
            currentAct.setHeight(ySender - currentAct.getY());
            newActivations.add(currentAct);
            currentAct = null;
        }
        return newActivations;
    }

    private boolean hasIncomingCallActionFirst(List<FigMessage> figMessages) {
        FigClassifierRole cr = (FigClassifierRole)this.getGroup();
        if (figMessages.isEmpty()) {
            return false;
        }
        FigMessage figMessage = figMessages.get(0);
        return ((Object)((Object)cr)).equals(figMessage.getDestFigNode()) && !((Object)((Object)cr)).equals(figMessage.getSourceFigNode()) && figMessage.isSynchCallMessage();
    }

    private void clearActivations() {
        for (FigActivation oldActivation : this.activations) {
            this.removeFig((Fig)oldActivation);
        }
        for (FigActivation oldActivation : this.stackedActivations) {
            this.removeFig((Fig)oldActivation);
        }
        this.activations.clear();
        this.stackedActivations.clear();
    }

    public void setFilled(boolean filled) {
    }

    protected synchronized void setBoundsImpl(int x, int y, int w, int h) {
        Rectangle oldBounds = this.getBounds();
        this.rectFig.setBounds(x, y, w, h);
        this.lineFig.setBounds(x + w / 2, y, w, h);
        int yDiff = oldBounds.y - y;
        for (FigActivation act : this.activations) {
            this.removeFig((Fig)act);
            act.setLocation(this.lineFig.getX() - 10, act.getY() - yDiff);
            if (this.activations.size() == 1 && act.getHeight() == oldBounds.height) {
                act.setHeight(this.getHeight());
            }
            this.addFig((Fig)act);
        }
        this.damage();
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        this.firePropChange("bounds", oldBounds, this.getBounds());
    }

    public void setLineWidth(int w) {
        this.lineFig.setLineWidth(w);
    }
}

