/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.argouml.core.propertypanels.model.CheckBoxData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ControlData {
    private String controlType;
    private String propertyName;
    private String label;
    private List<Class<?>> types = new ArrayList();
    private List<CheckBoxData> checkboxes = new ArrayList<CheckBoxData>();

    public ControlData(String controlType, String propertyName, String label) {
        this.controlType = controlType;
        this.propertyName = propertyName;
        this.label = label != null && label.length() > 0 ? label : "label." + propertyName.toLowerCase();
    }

    public String getControlType() {
        return this.controlType;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getLabel() {
        return this.label;
    }

    public List<CheckBoxData> getCheckboxes() {
        return Collections.unmodifiableList(this.checkboxes);
    }

    public List<Class<?>> getTypes() {
        return Collections.unmodifiableList(this.types);
    }

    public Class<?> getType() {
        return this.types.get(0);
    }

    public void addType(Class<?> type) {
        this.types.add(type);
    }

    public void addCheckbox(CheckBoxData child) {
        this.checkboxes.add(child);
    }
}

