/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultListModel;
import javax.swing.SwingUtilities;
import org.argouml.core.propertypanels.model.GetterSetterManager;
import org.argouml.kernel.Command;
import org.argouml.model.AddAssociationEvent;
import org.argouml.model.AttributeChangeEvent;
import org.argouml.model.InvalidElementException;
import org.argouml.model.Model;
import org.argouml.model.RemoveAssociationEvent;
import org.argouml.util.CollectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SimpleListModel
extends DefaultListModel
implements PropertyChangeListener {
    private static final long serialVersionUID = -8491023641828449064L;
    private static final Logger LOG = Logger.getLogger(SimpleListModel.class.getName());
    private final List<Class<?>> metaTypes;
    private final Object umlElement;
    private final String propertyName;
    private final GetterSetterManager getterSetterManager;

    SimpleListModel(String propertyName, List<Class<?>> types, Object umlElement, GetterSetterManager getterSetterManager) {
        this.getterSetterManager = getterSetterManager;
        this.metaTypes = types;
        this.propertyName = propertyName;
        this.umlElement = umlElement;
        this.build();
        Model.getPump().addModelEventListener((PropertyChangeListener)this, umlElement, propertyName);
    }

    public void removeModelEventListener() {
        Model.getPump().removeModelEventListener((PropertyChangeListener)this, this.umlElement, this.propertyName);
    }

    public Object getMetaType() {
        if (this.metaTypes.size() > 0) {
            return this.metaTypes.get(0);
        }
        return this.getterSetterManager.getMetaType(this.propertyName);
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public List getMetaTypes() {
        return this.metaTypes;
    }

    public Command getRemoveCommand(Object objectToRemove) {
        return this.getterSetterManager.getRemoveCommand(this.propertyName, this.umlElement, objectToRemove);
    }

    public Command getAddCommand() {
        return this.getterSetterManager.getAddCommand(this.propertyName, this.umlElement);
    }

    public List<Command> getAdditionalCommands() {
        return this.getterSetterManager.getAdditionalCommands(this.propertyName, this.umlElement);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent e) {
        if (e instanceof RemoveAssociationEvent || e instanceof AddAssociationEvent) {
            Runnable doWorkRunnable = new Runnable(){

                public void run() {
                    try {
                        if (SimpleListModel.this.getterSetterManager.isFullBuildOnly(SimpleListModel.this.propertyName)) {
                            SimpleListModel.this.removeAllElements();
                            SimpleListModel.this.build();
                        } else if (e instanceof RemoveAssociationEvent) {
                            Object objectToRemove = ((RemoveAssociationEvent)e).getChangedValue();
                            SimpleListModel.this.removeElement(objectToRemove);
                        } else if (e instanceof AddAssociationEvent) {
                            Object newElement = ((AddAssociationEvent)e).getChangedValue();
                            boolean typeValid = false;
                            for (Class cls : SimpleListModel.this.metaTypes) {
                                if (!cls.isInstance(newElement)) continue;
                                typeValid = true;
                            }
                            if (typeValid && !SimpleListModel.this.contains(newElement)) {
                                if (Model.getUmlHelper().isMovable(SimpleListModel.this.getMetaType())) {
                                    Collection c = SimpleListModel.this.getterSetterManager.getOptions(SimpleListModel.this.umlElement, SimpleListModel.this.propertyName, SimpleListModel.this.metaTypes);
                                    int index = CollectionUtil.indexOf((Collection)c, (Object)newElement);
                                    if (index < 0 || index > SimpleListModel.this.getSize() - 1) {
                                        LOG.log(Level.WARNING, "Unable to add element at correct position " + index + " added to end instead");
                                        SimpleListModel.this.addElement(newElement);
                                    } else {
                                        SimpleListModel.this.add(index, newElement);
                                    }
                                } else {
                                    SimpleListModel.this.addElement(newElement);
                                }
                            }
                        }
                    }
                    catch (InvalidElementException e2) {
                        LOG.log(Level.FINE, "propertyChange accessed a deleted element ", e2);
                    }
                }
            };
            SwingUtilities.invokeLater(doWorkRunnable);
        } else if (e.getPropertyName().equals("baseClass") && e.getPropertyName().equals(this.propertyName) && e instanceof AttributeChangeEvent) {
            this.removeAllElements();
            this.build();
        } else {
            LOG.log(Level.FINE, "We are listening for too much here. An event we don't need {0}", e);
        }
    }

    private void build() {
        try {
            LOG.log(Level.FINE, "Getting options for {0} {1} {2}", new Object[]{this.umlElement, this.propertyName, this.metaTypes});
            Collection c = this.getterSetterManager.getOptions(this.umlElement, this.propertyName, this.metaTypes);
            for (Object o : c) {
                this.addElement(o);
            }
        }
        catch (InvalidElementException exception) {
            LOG.log(Level.FINE, "buildModelList threw exception for target " + this.umlElement + ": " + (Object)((Object)exception));
        }
    }

    public Object getUmlElement() {
        return this.umlElement;
    }
}

