/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Action;
import javax.swing.Icon;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.core.propertypanels.ui.UMLComboBox;
import org.argouml.core.propertypanels.ui.UMLComboBoxModel;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.kernel.ProjectManager;
import org.argouml.model.Model;
import org.argouml.ui.UndoableAction;

class UMLCollaborationRepresentedOperationComboBoxModel
extends UMLComboBoxModel {
    private static final long serialVersionUID = -501052343770609804L;

    public UMLCollaborationRepresentedOperationComboBoxModel(String propertyName, Object target) {
        super(target, propertyName, true);
    }

    protected void buildModelList() {
        ArrayList operations = new ArrayList();
        Project p = ProjectManager.getManager().getCurrentProject();
        for (Object model : p.getUserDefinedModelList()) {
            Collection c = Model.getModelManagementHelper().getAllModelElementsOfKind(model, Model.getMetaTypes().getOperation());
            for (Object oper : c) {
                Object ns = Model.getFacade().getOwner(oper);
                Collection s = Model.getModelManagementHelper().getAllSurroundingNamespaces(ns);
                if (s.contains(this.getTarget())) continue;
                operations.add(oper);
            }
        }
        this.setElements(operations);
    }

    protected boolean isValidElement(Object element) {
        return Model.getFacade().isAOperation(element) && Model.getFacade().getRepresentedOperation(this.getTarget()) == element;
    }

    protected Object getSelectedModelElement() {
        return Model.getFacade().getRepresentedOperation(this.getTarget());
    }

    public Action getAction() {
        return new ActionSetRepresentedOperationCollaboration();
    }

    private class ActionSetRepresentedOperationCollaboration
    extends UndoableAction {
        private static final long serialVersionUID = 3408819535102974375L;

        ActionSetRepresentedOperationCollaboration() {
            super(Translator.localize((String)"action.set"), (Icon)ResourceLoaderWrapper.lookupIcon((String)"action.set"));
        }

        public void actionPerformed(ActionEvent e) {
            super.actionPerformed(e);
            UMLComboBox source = (UMLComboBox)e.getSource();
            Object target = source.getTarget();
            Object newValue = source.getSelectedItem();
            if (!Model.getFacade().isAOperation(newValue)) {
                newValue = null;
            }
            if (Model.getFacade().getRepresentedOperation(target) != newValue) {
                Model.getCollaborationsHelper().setRepresentedOperation(target, newValue);
            }
        }
    }
}

