/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.util.logging.Logger;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.argouml.core.propertypanels.ui.UMLExpressionModel;
import org.argouml.i18n.Translator;
import org.argouml.ui.LookAndFeelMgr;

class UMLExpressionBodyField
extends JTextArea
implements DocumentListener {
    private static final Logger LOG = Logger.getLogger(UMLExpressionBodyField.class.getName());
    private UMLExpressionModel model;
    private boolean notifyModel;

    public UMLExpressionBodyField(UMLExpressionModel expressionModel, boolean notify) {
        this.model = expressionModel;
        this.notifyModel = notify;
        this.getDocument().addDocumentListener(this);
        this.setToolTipText(Translator.localize((String)"label.body.tooltip"));
        this.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        this.setRows(2);
        this.update();
    }

    void update() {
        String oldText = this.getText();
        String newText = this.model.getBody();
        if (!(oldText != null && newText != null && oldText.equals(newText) || oldText == newText)) {
            this.setText(newText);
        }
    }

    public void changedUpdate(DocumentEvent p1) {
        this.model.setBody(this.getText());
    }

    public void removeUpdate(DocumentEvent p1) {
        this.model.setBody(this.getText());
    }

    public void insertUpdate(DocumentEvent p1) {
        this.model.setBody(this.getText());
    }
}

