/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.core.propertypanels.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationModel;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationValueField;
import org.argouml.core.propertypanels.ui.UMLValueSpecificationValueFieldOpaqueExpressionDialog;
import org.argouml.i18n.Translator;
import org.argouml.ui.LookAndFeelMgr;

class UMLValueSpecificationValueFieldOpaqueExpression
extends UMLValueSpecificationValueField
implements DocumentListener {
    private JTextArea curBody;
    private JTextField curLanguage;
    private int currentText;
    private boolean activeUpdateModele = true;

    public UMLValueSpecificationValueFieldOpaqueExpression(UMLValueSpecificationModel model, boolean notify) {
        super(model, notify);
    }

    public void buildPanel() {
        this.currentText = 0;
        this.curBody = new JTextArea();
        this.curBody.setToolTipText(Translator.localize((String)"label.body.tooltip"));
        this.curBody.setRows(2);
        this.curBody.getDocument().addDocumentListener(this);
        this.curLanguage = new JTextField();
        this.curLanguage.setToolTipText(Translator.localize((String)"label.language.tooltip"));
        this.curLanguage.getDocument().addDocumentListener(this);
        JButton button = new JButton("...");
        button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UMLValueSpecificationValueFieldOpaqueExpressionDialog dialog = new UMLValueSpecificationValueFieldOpaqueExpressionDialog(UMLValueSpecificationValueFieldOpaqueExpression.this.getModel(), UMLValueSpecificationValueFieldOpaqueExpression.this.currentText);
                dialog.setVisible(true);
                UMLValueSpecificationValueFieldOpaqueExpression.this.updateFields();
            }
        });
        JPanel panel = new JPanel();
        panel.setFont(LookAndFeelMgr.getInstance().getStandardFont());
        GridBagLayout layout = new GridBagLayout();
        panel.setLayout(layout);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        panel.add((Component)this.curLanguage, c);
        c = new GridBagConstraints();
        c.fill = 0;
        c.insets = new Insets(0, 0, 0, 0);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        panel.add((Component)button, c);
        c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = -1;
        c.gridheight = -1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        panel.add((Component)this.curBody, c);
        this.allField = panel;
    }

    public void updateFields() {
        this.activeUpdateModele = false;
        String oldText = this.curBody.getText();
        String[] newTabText = (String[])this.getModel().getValue();
        String newText = "";
        if (newTabText != null) {
            newText = newTabText[2 * this.currentText];
        }
        if (!(oldText != null && newText != null && oldText.equals(newText) || oldText == newText)) {
            this.curBody.setText(newText);
        }
        oldText = this.curLanguage.getText();
        newText = "";
        if (newTabText != null) {
            newText = newTabText[2 * this.currentText + 1];
        }
        if (!(oldText != null && newText != null && oldText.equals(newText) || oldText == newText)) {
            this.curLanguage.setText(newText);
        }
        this.activeUpdateModele = true;
    }

    public void changedUpdate(DocumentEvent arg0) {
        this.updateModel();
    }

    public void insertUpdate(DocumentEvent arg0) {
        this.updateModel();
    }

    public void removeUpdate(DocumentEvent arg0) {
        this.updateModel();
    }

    protected void updateModel() {
        if (this.activeUpdateModele) {
            Object[] tabValues = (String[])this.getModel().getValue();
            tabValues[2 * this.currentText] = this.curBody.getText();
            tabValues[2 * this.currentText + 1] = this.curLanguage.getText();
            this.getModel().setValue(tabValues);
        }
    }
}

