/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.cpp.generator;

import org.argouml.uml.generator.AbstractSection;

public class Section
extends AbstractSection {
    public static final int SECT_NONE = 0;
    public static final int SECT_NORMAL = 1;
    public static final int SECT_BRIEF = 2;
    private static int useSections = 1;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    static void setUseSect(int use) {
        useSections = use;
    }

    static int getUseSect() {
        return useSections;
    }

    public static String generate(String id, String indent) {
        return Section.generateTop(id, indent) + Section.generateBottom(id, indent);
    }

    public static String generateTop(String id, String indent) {
        if (useSections == 0) {
            return "";
        }
        String s = indent;
        if (useSections != 2) {
            s = s + "// don't delete the following line as ";
            s = s + "it's needed to preserve source code of this ";
            s = s + "autogenerated element" + LINE_SEPARATOR + indent;
        }
        s = s + "// section " + id + " begin" + LINE_SEPARATOR;
        return s;
    }

    public static String generateBottom(String id, String indent) {
        if (useSections == 0) {
            return "";
        }
        String s = indent + "// section " + id + " end" + LINE_SEPARATOR;
        if (useSections != 2) {
            s = s + indent + "// don't delete the previous line as ";
            s = s + "it's needed to preserve source code of this ";
            s = s + "autogenerated element" + LINE_SEPARATOR;
        }
        return s;
    }
}

