/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.cpp.profile;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import org.argouml.model.Model;
import org.argouml.profile.ProfileException;
import org.argouml.profile.ProfileReference;
import org.argouml.profile.ResourceModelLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseProfile {
    private static final Logger LOG = Logger.getLogger(BaseProfile.class.getName());
    public static final String TV_NAME_DOCUMENTATION = "documentation";
    static final String PROFILE_FILE_NAME = "/org/argouml/language/cpp/profile/CppUmlProfile.xmi";
    static final ProfileReference PROFILE_REFERENCE;
    private Collection<Object> models;
    private Object profile;
    private Set builtInTypes;

    private void initBuiltInTypes() {
        this.builtInTypes = new HashSet();
        Collection allDataTypes = Model.getCoreHelper().getAllDataTypes(this.profile);
        for (Object dt : allDataTypes) {
            this.builtInTypes.add(Model.getFacade().getName(dt));
        }
    }

    public boolean isBuiltIn(String typeName) {
        if (this.builtInTypes == null) {
            this.initBuiltInTypes();
        }
        typeName = BaseProfile.trimAndEnsureOneSpaceOnlyBetweenTokens(typeName);
        return this.builtInTypes.contains(typeName);
    }

    static String trimAndEnsureOneSpaceOnlyBetweenTokens(String typeName) {
        return typeName.trim().replaceAll("\\s+", " ");
    }

    public Object getBuiltIn(String typeName) {
        assert (this.isBuiltIn(typeName)) : "Must be a C++ built in!";
        Object builtinType = BaseProfile.findDataType(typeName, this.profile);
        if (builtinType == null) {
            builtinType = Model.getCoreFactory().buildDataType(typeName, this.models.iterator().next());
        }
        Object profileDT = BaseProfile.findDataType(typeName, this.profile);
        Object dtDocuTV = Model.getFacade().getTaggedValue(profileDT, TV_NAME_DOCUMENTATION);
        if (dtDocuTV != null) {
            Object tdDocumentation = BaseProfile.getTagDefinition(TV_NAME_DOCUMENTATION);
            Object modelDTDocuTV = Model.getExtensionMechanismsFactory().buildTaggedValue(tdDocumentation, new String[]{Model.getFacade().getValueOfTag(dtDocuTV)});
            Model.getExtensionMechanismsHelper().addTaggedValue(builtinType, modelDTDocuTV);
        }
        return builtinType;
    }

    public static Collection getModels() {
        ArrayList models = new ArrayList();
        for (Object rootModelElement : Model.getFacade().getRootElements()) {
            if (!Model.getFacade().isAModel(rootModelElement)) continue;
            models.add(rootModelElement);
        }
        return models;
    }

    public static Collection getEditableModels() {
        ArrayList editableModels = new ArrayList();
        for (Object rootModelElement : Model.getFacade().getRootElements()) {
            if (!Model.getFacade().isAModel(rootModelElement) || Model.getModelManagementHelper().isReadOnly(rootModelElement)) continue;
            editableModels.add(rootModelElement);
        }
        return editableModels;
    }

    public static Object getTagDefinition(String tdName) {
        Collection models = BaseProfile.getModels();
        for (Object model : models) {
            Collection tagDefinitions = Model.getModelManagementHelper().getAllModelElementsOfKindWithModel(model, Model.getMetaTypes().getTagDefinition());
            for (Object td : tagDefinitions) {
                if (!tdName.equals(Model.getFacade().getName(td))) continue;
                return td;
            }
        }
        Collection editableModels = BaseProfile.getEditableModels();
        Iterator it = editableModels.iterator();
        if (it.hasNext()) {
            return Model.getExtensionMechanismsFactory().buildTagDefinition(tdName, null, it.next());
        }
        throw new IllegalStateException("Unable to find an editable model.");
    }

    static Object findDataType(String typeName, Object model2) {
        Collection dataTypes = Model.getCoreHelper().getAllDataTypes(model2);
        for (Object dt : dataTypes) {
            if (!Model.getFacade().getName(dt).equals(typeName)) continue;
            return dt;
        }
        return null;
    }

    Object getProfile() {
        return this.profile;
    }

    protected BaseProfile(Collection<Object> theModels) {
        this(theModels, BaseProfile.loadProfileModels().iterator().next());
    }

    protected BaseProfile(Collection<Object> theModels, Object profileModel) {
        this.models = theModels;
        assert (this.models.size() > 0) : "There must be at least one user model.";
        assert (profileModel != null) : "The profileModel must be non-null.";
        this.profile = profileModel;
    }

    static Collection loadProfileModels() {
        Collection elements;
        ResourceModelLoader profileModelLoader = new ResourceModelLoader(BaseProfile.class);
        try {
            elements = profileModelLoader.loadModel(PROFILE_REFERENCE);
        }
        catch (ProfileException e) {
            throw new RuntimeException(e);
        }
        return elements;
    }

    protected Object getCppStereotypeInModel(String stereotypeName) {
        Object model;
        Object cppStereotype = null;
        Iterator<Object> i$ = this.models.iterator();
        while (i$.hasNext() && (cppStereotype = this.getStereotype(model = i$.next(), stereotypeName)) == null) {
        }
        if (cppStereotype == null) {
            cppStereotype = this.getStereotype(this.profile, stereotypeName);
        }
        return cppStereotype;
    }

    private Object getStereotype(Object aModel, String stereotypeName) {
        Collection stereotypes = Model.getExtensionMechanismsHelper().getStereotypes(aModel);
        for (Object stereotype : stereotypes) {
            if (!stereotypeName.equals(Model.getFacade().getName(stereotype))) continue;
            return stereotype;
        }
        return null;
    }

    protected Object getTagDefinition(String stereoName, String tdName) {
        Object stereo = this.getCppStereotypeInModel(stereoName);
        this.assertModelElementContainedInModels(stereo);
        Collection tagDefinitions = Model.getFacade().getTagDefinitions(stereo);
        for (Object tagDefinition : tagDefinitions) {
            if (!tdName.equals(Model.getFacade().getName(tagDefinition))) continue;
            return tagDefinition;
        }
        return null;
    }

    public void applyStereotype(String stereoName, Object modelElement) {
        this.assertModelElementContainedInModels(modelElement);
        Object stereo = this.getCppStereotypeInModel(stereoName);
        Model.getCoreHelper().addStereotype(modelElement, stereo);
    }

    private void assertModelElementContainedInModels(Object modelElement) {
        Object model;
        boolean contained = false;
        ArrayList<Object> modelsAndProfile = new ArrayList<Object>(this.models){
            {
                this.add(BaseProfile.this.profile);
            }
        };
        Iterator i$ = modelsAndProfile.iterator();
        while (i$.hasNext() && !(contained = (model = i$.next()).equals(Model.getFacade().getRoot(modelElement)))) {
        }
        assert (contained) : "model element (" + modelElement + ") not contained " + "in models.";
    }

    public void applyTaggedValue(String stereoName, String tdName, Object me, String tvv) {
        this.assertModelElementContainedInModels(me);
        assert (Model.getFacade().getStereotypes(me).contains(this.getCppStereotypeInModel(stereoName)));
        Object td = this.getTagDefinition(stereoName, tdName);
        Object tv = Model.getExtensionMechanismsFactory().createTaggedValue();
        Model.getExtensionMechanismsHelper().setType(tv, td);
        Model.getExtensionMechanismsHelper().setDataValues(tv, new String[]{tvv});
        Model.getExtensionMechanismsHelper().addTaggedValue(me, tv);
    }

    public void applyTaggedValue(String tdName, Object me, String tvv) {
        this.assertModelElementContainedInModels(me);
        Object td = BaseProfile.getTagDefinition(tdName);
        Object tv = Model.getExtensionMechanismsFactory().createTaggedValue();
        Model.getExtensionMechanismsHelper().setType(tv, td);
        Model.getExtensionMechanismsHelper().setDataValues(tv, new String[]{tvv});
        Model.getExtensionMechanismsHelper().addTaggedValue(me, tv);
    }

    static {
        URL profileURL = null;
        try {
            profileURL = new URL("http://argouml-cpp.tigris.org/profile/CppUmlProfile.xmi");
        }
        catch (MalformedURLException e) {
            LOG.severe("Exception " + e);
        }
        PROFILE_REFERENCE = new ProfileReference(PROFILE_FILE_NAME, profileURL);
    }
}

