/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.cpp.reveng;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.anarres.cpp.CppReader;
import org.anarres.cpp.Preprocessor;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.kernel.Project;
import org.argouml.language.cpp.reveng.CPPLexer;
import org.argouml.language.cpp.reveng.CPPParser;
import org.argouml.language.cpp.reveng.Modeler;
import org.argouml.language.cpp.reveng.ModelerImpl;
import org.argouml.profile.ProfileException;
import org.argouml.taskmgmt.ProgressMonitor;
import org.argouml.uml.reveng.FileImportUtils;
import org.argouml.uml.reveng.ImportInterface;
import org.argouml.uml.reveng.ImportSettings;
import org.argouml.uml.reveng.ImporterManager;
import org.argouml.util.SuffixFilter;

public class CppImport
implements ImportInterface {
    private static final Logger LOG = Logger.getLogger(CppImport.class.getName());
    private boolean userWarning = Configuration.getBoolean((ConfigurationKey)KEY_USER_WARNING, (boolean)true);
    private static final ConfigurationKey KEY_USER_WARNING = Configuration.makeKey((String)"cpp", (String)"reveng", (String)"user", (String)"warning");
    private Collection newElements;
    private static final SuffixFilter[] CPP_SUFFIX_FILTERS = new SuffixFilter[]{new SuffixFilter("cxx", "C++ source files"), new SuffixFilter("c++", "C++ source files"), new SuffixFilter("C++", "C++ source files"), new SuffixFilter("CPP", "C++ source files"), new SuffixFilter("cpp", "C++ source files")};

    public Collection parseFiles(Project p, Collection files, ImportSettings settings, ProgressMonitor monitor) throws ImportInterface.ImportException {
        LOG.warning("Not fully implemented yet!");
        this.warnUser(monitor);
        this.newElements = new HashSet();
        monitor.setMaximumProgress(files.size());
        int count = 1;
        for (Object file : files) {
            if (!(file instanceof File)) {
                throw new ImportInterface.ImportException("Invalid argument - not a file: " + file);
            }
            this.parseFile(p, (File)file, settings);
            monitor.updateProgress(count++);
        }
        return this.newElements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseFile(Project p, File f, ImportSettings settings) throws ImportInterface.ImportException {
        CppReader fileReader;
        try {
            Preprocessor preprocessor = new Preprocessor(f);
            fileReader = new CppReader(preprocessor);
        }
        catch (IOException e) {
            throw new ImportInterface.ImportException("Error opening file " + f, (Throwable)e);
        }
        try {
            Modeler modeler = this.createModeler(p);
            CPPLexer lexer = new CPPLexer((Reader)fileReader);
            CPPParser parser = new CPPParser(lexer);
            try {
                parser.translation_unit(modeler);
            }
            catch (Exception e) {
                throw new ImportInterface.ImportException("Error parsing " + f, (Throwable)e);
            }
            this.newElements.addAll(modeler.getNewElements());
        }
        finally {
            try {
                fileReader.close();
            }
            catch (IOException e) {
                LOG.severe("Error on closing file " + f + " " + e);
            }
        }
    }

    private Modeler createModeler(Project p) throws ImportInterface.ImportException {
        try {
            Modeler modeler = new ModelerImpl(p);
            if (LOG.isLoggable(Level.FINE)) {
                ModelerInvocationHandler handler = new ModelerInvocationHandler(modeler);
                modeler = (Modeler)Proxy.newProxyInstance(Modeler.class.getClassLoader(), new Class[]{Modeler.class}, (InvocationHandler)handler);
            }
            return modeler;
        }
        catch (ProfileException e) {
            throw new ImportInterface.ImportException("Exception thrown while creating the C++ modeler.", (Throwable)e);
        }
    }

    private void warnUser(ProgressMonitor monitor) {
        String lineSepAndListIndent = System.getProperty("line.separator") + "    * ";
        String warnMsg = "Its known limits are: " + lineSepAndListIndent + "very few C++ constructs are supported, e.g., enums, unions, " + "templates, etc, aren't;" + lineSepAndListIndent + "no support for non-member variables and functions;" + lineSepAndListIndent + "no integration with the C++ generator => RTE won't work!;" + lineSepAndListIndent + "no operator overload support;" + lineSepAndListIndent + "very immature, certainly this list needs to grow!";
        Configuration.setBoolean((ConfigurationKey)KEY_USER_WARNING, (boolean)this.userWarning);
        LOG.fine("userWarning = " + this.userWarning);
        this.userWarning = false;
        monitor.notifyMessage("C++ Import Limitations", "The C++ reverse engineering module is pre-alpha stage.", warnMsg);
    }

    public SuffixFilter[] getSuffixFilters() {
        return CPP_SUFFIX_FILTERS;
    }

    public boolean isParseable(File file) {
        return FileImportUtils.matchesSuffix((Object)file, (SuffixFilter[])this.getSuffixFilters());
    }

    public boolean enable() {
        ImporterManager.getInstance().addImporter((ImportInterface)this);
        return true;
    }

    public boolean disable() {
        return ImporterManager.getInstance().removeImporter((ImportInterface)this);
    }

    public String getName() {
        return "C++";
    }

    public String getInfo(int type) {
        switch (type) {
            case 1: {
                return "Luis Sergio Oliveira (euluis)";
            }
            case 0: {
                return "C++ reverse engineering support";
            }
            case 2: {
                return "0.01";
            }
        }
        return null;
    }

    public List getImportSettings() {
        return null;
    }

    private static class ModelerInvocationHandler
    implements InvocationHandler {
        static final Logger LOG = Logger.getLogger(Modeler.class.getName());
        private Modeler modeler;

        ModelerInvocationHandler(Modeler theModeler) {
            this.modeler = theModeler;
        }

        public Object invoke(Object proxy, Method method, Object[] args) {
            StringBuilder debugInfo = new StringBuilder();
            debugInfo.append("Entered ");
            debugInfo.append(method.getName());
            if (args != null && args.length > 0) {
                debugInfo.append(", with args: ");
                for (int i = 0; i < args.length; ++i) {
                    Object arg = args[i];
                    debugInfo.append(arg);
                    if (i >= args.length - 1) continue;
                    debugInfo.append("; ");
                }
            }
            debugInfo.append(".");
            LOG.fine(debugInfo.toString());
            try {
                return method.invoke((Object)this.modeler, args);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

