/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.euml;

import org.argouml.model.euml.EUMLModelImplementation;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.StrictCompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CopyToClipboardCommand;
import org.eclipse.emf.edit.command.PasteFromClipboardCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.AssociationClass;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UMLUtil
extends org.eclipse.uml2.uml.util.UMLUtil {
    public static final URI DEFAULT_URI = URI.createURI((String)"http://argouml.tigris.org/euml/resource/default_uri.xmi");

    public static EList<Property> getOwnedAttributes(Type type) {
        if (type instanceof AssociationClass) {
            return ((AssociationClass)type).getOwnedAttributes();
        }
        if (type instanceof Association) {
            return ((Association)type).getOwnedEnds();
        }
        return org.eclipse.uml2.uml.util.UMLUtil.getOwnedAttributes((Type)type);
    }

    public static EList<Operation> getOwnedOperations(Type type) {
        return org.eclipse.uml2.uml.util.UMLUtil.getOwnedOperations((Type)type);
    }

    public static Element copy(EUMLModelImplementation modelImplementation, Element source, Element destination) {
        Command copyToClipboard = CopyToClipboardCommand.create((EditingDomain)modelImplementation.getEditingDomain(), (Object)source);
        Command pasteFromClipboard = PasteFromClipboardCommand.create((EditingDomain)modelImplementation.getEditingDomain(), (Object)destination, null);
        StrictCompoundCommand copyCommand = new StrictCompoundCommand(){
            {
                this.isPessimistic = true;
            }
        };
        copyCommand.append(copyToClipboard);
        copyCommand.append(pasteFromClipboard);
        copyCommand.setLabel("Copy a tree of UML elements to a destination");
        if (copyCommand.canExecute()) {
            modelImplementation.getModelEventPump().getRootContainer().setHoldEvents(true);
            modelImplementation.getEditingDomain().getCommandStack().execute((Command)copyCommand);
            if (modelImplementation.getEditingDomain().getCommandStack().getMostRecentCommand().getAffectedObjects().size() == 1) {
                modelImplementation.getModelEventPump().getRootContainer().setHoldEvents(false);
                return (Element)modelImplementation.getEditingDomain().getCommandStack().getMostRecentCommand().getAffectedObjects().iterator().next();
            }
            modelImplementation.getEditingDomain().getCommandStack().undo();
            modelImplementation.getModelEventPump().getRootContainer().clearHeldEvents();
            modelImplementation.getModelEventPump().getRootContainer().setHoldEvents(false);
        }
        return null;
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        if (!(o instanceof Element)) {
            return o.toString();
        }
        StringBuilder sb = new StringBuilder("'");
        boolean named = false;
        if (o instanceof NamedElement && ((NamedElement)o).getName() != null && !((NamedElement)o).getName().equals("")) {
            named = true;
            sb.append(((NamedElement)o).getName() + " [");
        }
        sb.append(((Element)o).eClass().getName());
        if (named) {
            sb.append("]");
        }
        sb.append("'");
        return sb.toString();
    }

    static Resource getResource(EUMLModelImplementation modelImplementation, URI uri, boolean readOnly) {
        Resource r;
        if (!"xmi".equals(uri.fileExtension()) && !"uml".equals(uri.fileExtension())) {
            uri = uri.appendFileExtension("xmi");
        }
        if ((r = modelImplementation.getEditingDomain().getResourceSet().getResource(uri, false)) == null) {
            r = modelImplementation.getEditingDomain().getResourceSet().createResource(uri);
        }
        if (r == null) {
            throw new NullPointerException("Failed to create resource for URI " + uri);
        }
        modelImplementation.getReadOnlyMap().put(r, readOnly);
        return r;
    }

    static void checkArgs(Object[] args, Class[] types) {
        if (args.length != types.length) {
            throw new IllegalArgumentException("Mismatched array lengths for args and types");
        }
        for (int i = 0; i < args.length; ++i) {
            if (types[i].isAssignableFrom(args[i].getClass())) continue;
            throw new IllegalArgumentException("Parameter " + i + " must be of type " + types[i]);
        }
    }
}

