/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ptree;

import com.saxonica.ptree.TextMangler;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.sort.IntToIntHashMap;
import net.sf.saxon.expr.sort.IntToIntMap;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyDocumentImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.Untyped;

public class PTreeReader {
    private Configuration config;
    private IntToIntMap names = new IntToIntHashMap(500);
    private int version = 0;
    private TextMangler mangler;

    public void setTextMangler(TextMangler mangler) {
        this.mangler = mangler;
    }

    public DocumentInfo readTree(DataInputStream in, String systemId, Configuration config) throws IOException, XPathException {
        this.config = config;
        TinyBuilder builder = new TinyBuilder(config.makePipelineConfiguration());
        this.readTree(in, systemId, config, (Receiver)builder);
        TinyDocumentImpl doc = (TinyDocumentImpl)builder.getCurrentRoot();
        doc.setSystemId(systemId);
        return doc;
    }

    public void readTree(DataInputStream in, String systemId, Configuration config, Receiver out) throws IOException, XPathException {
        int i;
        NamePool pool = config.getNamePool();
        int signature = in.readInt();
        if (signature != -1091982307) {
            throw new PTreeException("Input file is not a Saxon PTree");
        }
        int version = in.readInt();
        if (version != 0) {
            throw new PTreeException("Input PTree is an unsupported version (" + version + ")");
        }
        int options = in.readInt();
        int numberOfNodes = in.readInt();
        int numberOfAttributes = in.readInt();
        int numberOfNamespaces = in.readInt();
        int textLength = in.readInt();
        if (out instanceof TinyBuilder) {
            int[] sizeParams = new int[]{numberOfNodes + 1, numberOfAttributes + 1, numberOfNamespaces + 1, textLength + 1};
            ((TinyBuilder)out).setSizeParameters(sizeParams);
        }
        out.open();
        this.handleNames(in, pool);
        int currentDepth = 0;
        boolean previousElement = false;
        block9: for (i = 0; i < numberOfNodes; ++i) {
            int b = in.readUnsignedByte();
            int depthCode = b >> 6 & 3;
            int depth = 0;
            if (depthCode == 0) {
                depth = currentDepth;
            } else if (depthCode == 1) {
                depth = currentDepth + 1;
            } else if (depthCode == 2) {
                depth = in.readUnsignedByte();
            } else if (depthCode == 3) {
                depth = in.readInt();
            }
            int nodeKind = b & 0xF;
            if (depth < currentDepth + 1) {
                if (previousElement) {
                    out.endElement();
                }
                for (int d = 0; d < currentDepth - depth; ++d) {
                    out.endElement();
                }
            }
            currentDepth = depth;
            previousElement = false;
            switch (nodeKind) {
                case 9: {
                    out.startDocument(0);
                    continue block9;
                }
                case 1: {
                    int opt = in.readUnsignedByte();
                    int nameCodeSize = (opt >> 6 & 3) + 1;
                    boolean hasAttributes = (opt >> 5 & 1) != 0;
                    boolean hasNamespaces = (opt >> 4 & 1) != 0;
                    int typeCodeSize = opt >> 2 & 3;
                    int nc = this.readVariableInt(in, nameCodeSize);
                    int tc = -1;
                    if (typeCodeSize > 0) {
                        tc = this.readVariableInt(in, typeCodeSize);
                    }
                    Object newType = null;
                    int newtc = this.allocate(tc);
                    newType = newtc == -1 ? Untyped.getInstance() : config.getSchemaType(newtc &= 0xFFFFF);
                    if (newType == null) {
                        newType = AnyType.getInstance();
                    }
                    out.startElement((NodeName)new CodedName(this.allocate(nc), config.getNamePool()), (SchemaType)newType, 0, 0);
                    if (hasNamespaces) {
                        int nrOfNamespaces = in.readUnsignedShort();
                        for (int n = 0; n < nrOfNamespaces; ++n) {
                            String prefix = in.readUTF();
                            String uri = in.readUTF();
                            out.namespace(new NamespaceBinding(prefix, uri), 0);
                        }
                    }
                    if (hasAttributes) {
                        int nrOfAttributes = in.readUnsignedShort();
                        for (int a = 0; a < nrOfAttributes; ++a) {
                            this.readAttribute(in, out, config);
                        }
                    }
                    previousElement = true;
                    continue block9;
                }
                case 3: {
                    String value = in.readUTF();
                    if (value.length() == 0) {
                        value = this.readText(in);
                    }
                    if (this.mangler != null) {
                        value = ((Object)this.mangler.unmangle(value)).toString();
                    }
                    out.characters((CharSequence)value, 0, 1024);
                    continue block9;
                }
                case 4: {
                    int count = in.readByte();
                    long lval = 0L;
                    for (int wb = 0; wb < count; ++wb) {
                        byte bval = in.readByte();
                        lval = lval << 8 | (long)bval & 0xFFL;
                    }
                    CompressedWhitespace cws = new CompressedWhitespace(lval <<= 8 * (8 - count));
                    out.characters((CharSequence)cws, 0, 1024);
                    continue block9;
                }
                case 8: {
                    FastStringBuffer comment = this.readText(in);
                    out.comment((CharSequence)comment, 0, 0);
                    continue block9;
                }
                case 7: {
                    String piname = in.readUTF();
                    FastStringBuffer pidata = this.readText(in);
                    out.processingInstruction(piname, (CharSequence)pidata, 0, 0);
                    continue block9;
                }
                case 11: 
                case 12: {
                    continue block9;
                }
                default: {
                    throw new PTreeException("Unknown node kind " + nodeKind + " in PTree");
                }
            }
        }
        for (i = 0; i < currentDepth; ++i) {
            out.endElement();
        }
        out.endDocument();
        out.close();
    }

    private void readAttribute(DataInputStream in, Receiver builder, Configuration config) throws IOException, XPathException {
        SimpleType newType;
        int newtc;
        int opt = in.readUnsignedByte();
        boolean isId = (opt & 1) != 0;
        boolean isIdref = (opt & 2) != 0;
        int nameCodeSize = (opt >> 6 & 3) + 1;
        int typeCodeSize = opt >> 4 & 3;
        int nameCode = this.readVariableInt(in, nameCodeSize);
        int typeCode = -1;
        if (typeCodeSize > 0) {
            typeCode = this.readVariableInt(in, typeCodeSize) & 0xFFFFF;
        }
        boolean valueExists = (opt >> 3 & 1) != 0;
        String value = "";
        if (valueExists) {
            value = in.readUTF();
            if (value.length() == 0) {
                value = this.readText(in);
            }
            if (this.mangler != null) {
                value = ((Object)this.mangler.unmangle(value)).toString();
            }
        }
        if ((newtc = this.allocate(typeCode)) == -1) {
            newtc = 631;
        }
        if ((newType = (SimpleType)config.getSchemaType(newtc)) == null) {
            newType = BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        int builderOptions = 0;
        if (isId) {
            builderOptions |= 0x800;
        }
        if (isIdref) {
            builderOptions |= 0x1000;
        }
        builder.attribute((NodeName)new CodedName(this.allocate(nameCode), config.getNamePool()), newType, (CharSequence)value, 0, builderOptions);
    }

    private void handleNames(DataInputStream in, NamePool pool) throws IOException {
        int numberOfNames = in.readInt();
        ArrayList<Object[]> tempMap = new ArrayList<Object[]>(numberOfNames);
        for (int i = 0; i < numberOfNames; ++i) {
            int prefixCode = in.readUnsignedShort();
            int uriCode = in.readUnsignedShort();
            String localName = in.readUTF();
            Object[] triple = new Object[]{prefixCode, uriCode, localName};
            tempMap.add(triple);
        }
        int numberOfPrefixes = in.readInt();
        ArrayList<String> prefixes = new ArrayList<String>(numberOfPrefixes);
        for (int p = 0; p < numberOfPrefixes; ++p) {
            prefixes.add(in.readUTF());
        }
        prefixes.add("");
        int numberOfURIs = in.readInt();
        ArrayList<String> uris = new ArrayList<String>(numberOfURIs);
        for (int u = 0; u < numberOfURIs; ++u) {
            uris.add(in.readUTF());
        }
        uris.add("");
        for (int i = 0; i < numberOfNames; ++i) {
            Object[] triple = (Object[])tempMap.get(i);
            String prefix = (String)prefixes.get((Integer)triple[0]);
            String uri = (String)uris.get((Integer)triple[1]);
            String local = (String)triple[2];
            int nameCode = pool.allocate(prefix, uri, local);
            this.names.put(i, nameCode);
        }
    }

    private int allocate(int oldName) {
        if (oldName == -1) {
            return -1;
        }
        return this.names.get(oldName);
    }

    private int readVariableInt(DataInputStream in, int bytes) throws IOException {
        if (bytes == 4) {
            return in.readInt();
        }
        if (bytes == 3) {
            return in.readUnsignedByte() << 16 | in.readUnsignedShort();
        }
        if (bytes == 2) {
            return in.readUnsignedShort();
        }
        if (bytes == 1) {
            return in.readUnsignedByte();
        }
        return -1;
    }

    private FastStringBuffer readText(DataInputStream in) throws IOException {
        int globs = in.readInt();
        FastStringBuffer sb = new FastStringBuffer(globs * 10000);
        for (int i = 0; i < globs; ++i) {
            sb.append(in.readUTF());
        }
        return sb;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("Format: java com.saxonica.ptree.PTreeReader [-t] source.ptree out.xml");
            System.exit(2);
        }
        boolean timing = false;
        DocumentInfo doc = null;
        int a = 0;
        if (args[a].equals("-t")) {
            ++a;
            timing = true;
        }
        int times = 1;
        if (args[a].equals("-3")) {
            times = 3;
        }
        Configuration config = new Configuration();
        int n = ++a;
        ++a;
        File infile = new File(args[n]);
        long startTime = 0L;
        for (int tt = 0; tt < times; ++tt) {
            startTime = System.currentTimeMillis();
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(infile)));
            doc = new PTreeReader().readTree(in, infile.toURI().toString(), config);
            if (!timing) continue;
            long endTime = System.currentTimeMillis();
            System.err.println("Tree loaded in " + (endTime - startTime) + "ms");
            startTime = endTime;
        }
        File outfile = new File(args[a]);
        SerializerFactory sf = config.getSerializerFactory();
        Receiver out = sf.getReceiver((Result)new StreamResult(outfile), config.makePipelineConfiguration(), new Properties());
        doc.copy(out, 6, 0);
        out.close();
        if (timing) {
            long endTime = System.currentTimeMillis();
            System.err.println("Tree serialized in " + (endTime - startTime) + "ms");
            startTime = endTime;
        }
    }

    public static class PTreeException
    extends XPathException {
        public PTreeException(String s) {
            super(s);
        }
    }
}

