/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.generator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.argouml.application.api.Argo;
import org.argouml.application.helpers.ResourceLoaderWrapper;
import org.argouml.configuration.Configuration;
import org.argouml.configuration.ConfigurationKey;
import org.argouml.model.Model;
import org.argouml.moduleloader.ModuleInterface;
import org.argouml.ocl.ArgoFacade;
import org.argouml.uml.DocumentationManager;
import org.argouml.uml.generator.CodeGenerator;
import org.argouml.uml.generator.GeneratorHelper;
import org.argouml.uml.generator.GeneratorManager;
import org.argouml.uml.generator.Language;
import org.argouml.uml.generator.TempFileUtils;
import tudresden.ocl.OclTree;
import tudresden.ocl.check.types.ModelFacade;
import tudresden.ocl.parser.analysis.DepthFirstAdapter;
import tudresden.ocl.parser.node.AConstraintBody;
import tudresden.ocl.parser.node.Switch;

public class GeneratorJava
implements CodeGenerator,
ModuleInterface {
    private static final Logger LOG = Logger.getLogger(GeneratorJava.class.getName());
    private boolean verboseDocs;
    private boolean lfBeforeCurly;
    private static final boolean VERBOSE_DOCS = false;
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final String LANG_PACKAGE = "java.lang";
    private static final Set<String> JAVA_TYPES;
    private static boolean isFileGeneration;
    private static boolean isInUpdateMode;
    private static final String INDENT = "  ";
    private static Language java;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateFile(Object modelElement, String path) {
        String name = Model.getFacade().getName(modelElement);
        if (name == null || name.length() == 0) {
            return null;
        }
        Object classifier = modelElement;
        String filename = name + ".java";
        StringBuilder sbPath = new StringBuilder(path);
        if (!path.endsWith(FILE_SEPARATOR)) {
            sbPath.append(FILE_SEPARATOR);
        }
        String packagePath = this.getPackageName(Model.getFacade().getNamespace(classifier));
        int lastIndex = -1;
        while (true) {
            File f;
            if (!(f = new File(sbPath.toString())).isDirectory() && !f.mkdir()) {
                LOG.severe(" could not make directory " + path);
                return null;
            }
            if (lastIndex == packagePath.length()) break;
            int index = packagePath.indexOf(".", lastIndex + 1);
            if (index == -1) {
                index = packagePath.length();
            }
            sbPath.append(packagePath.substring(lastIndex + 1, index) + FILE_SEPARATOR);
            lastIndex = index;
        }
        String pathname = sbPath.toString() + filename;
        File f = new File(pathname);
        isFileGeneration = true;
        LOG.info("Generating " + f.getPath());
        isFileGeneration = true;
        String header = this.generateHeader(classifier, pathname, packagePath);
        String src = this.generateClassifier(classifier);
        BufferedWriter fos = null;
        try {
            fos = Configuration.getString((ConfigurationKey)Argo.KEY_INPUT_SOURCE_ENCODING) == null || Configuration.getString((ConfigurationKey)Argo.KEY_INPUT_SOURCE_ENCODING).trim().equals("") ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), System.getProperty("file.encoding"))) : new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), Configuration.getString((ConfigurationKey)Argo.KEY_INPUT_SOURCE_ENCODING)));
            fos.write(header);
            fos.write(src);
        }
        catch (IOException exp) {
            LOG.severe("IO Exception: " + exp + ", for file: " + f.getPath());
        }
        finally {
            isFileGeneration = false;
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException exp) {
                LOG.severe("FAILED: " + f.getPath());
            }
        }
        return pathname;
    }

    private String generateHeader(Object cls, String pathname, String packagePath) {
        StringBuffer sb = new StringBuffer(80);
        if (packagePath.length() > 0) {
            sb.append("package ").append(packagePath).append(";");
            sb.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        }
        sb.append(this.generateImports(cls, packagePath));
        return sb.toString();
    }

    private String generate(Object o) {
        if (o == null) {
            return "";
        }
        if (Model.getFacade().isAActionState(o)) {
            return this.generateActionState(o);
        }
        if (Model.getFacade().isAExtensionPoint(o)) {
            return this.generateExtensionPoint(o);
        }
        if (Model.getFacade().isAOperation(o)) {
            return this.generateOperation(o, false);
        }
        if (Model.getFacade().isAAttribute(o)) {
            return this.generateAttribute(o, false);
        }
        if (Model.getFacade().isAParameter(o)) {
            return this.generateParameter(o);
        }
        if (Model.getFacade().isAPackage(o)) {
            return this.generatePackage(o);
        }
        if (Model.getFacade().isAClassifier(o)) {
            return this.generateClassifier(o);
        }
        if (Model.getFacade().isAExpression(o)) {
            return this.generateExpression(o);
        }
        if (o instanceof String) {
            return this.generateName((String)o);
        }
        if (o instanceof String) {
            return this.generateUninterpreted((String)o);
        }
        if (Model.getFacade().isAStereotype(o)) {
            return this.generateStereotype(o);
        }
        if (Model.getFacade().isATaggedValue(o)) {
            return this.generateTaggedValue(o);
        }
        if (Model.getFacade().isAAssociationEnd(o)) {
            return this.generateAssociationEnd(o);
        }
        if (Model.getFacade().isAMultiplicity(o)) {
            return this.generateMultiplicity(o);
        }
        if (Model.getFacade().isAState(o)) {
            return this.generateState(o);
        }
        if (Model.getFacade().isATransition(o)) {
            return this.generateTransition(o);
        }
        if (Model.getFacade().isAAction(o)) {
            return this.generateAction(o);
        }
        if (Model.getFacade().isACallAction(o)) {
            return this.generateAction(o);
        }
        if (Model.getFacade().isAGuard(o)) {
            return this.generateGuard(o);
        }
        if (Model.getFacade().isAMessage(o)) {
            return this.generateMessage(o);
        }
        if (Model.getFacade().isAEvent(o)) {
            return this.generateEvent(o);
        }
        if (Model.getFacade().isAVisibilityKind(o)) {
            return this.generateVisibility(o);
        }
        if (Model.getFacade().isAModelElement(o)) {
            return this.generateName(Model.getFacade().getName(o));
        }
        return o.toString();
    }

    private String generateImports(Object cls, String packagePath) {
        String ftype;
        Object ns = Model.getFacade().getNamespace(cls);
        if (ns != null) {
            for (Object oe : Model.getFacade().getOwnedElements(ns)) {
                if (Model.getFacade().getUmlVersion().charAt(0) == '1' && Model.getFacade().isAComponent(oe)) {
                    for (Object re : Model.getFacade().getResidentElements(oe)) {
                        Object r = Model.getFacade().getResident(re);
                        if (!r.equals(cls)) continue;
                        return this.generateArtifactImports(oe);
                    }
                    continue;
                }
                if (!Model.getFacade().isAArtifact(oe) || !Model.getCoreHelper().getUtilizedElements(oe).contains(cls)) continue;
                return this.generateArtifactImports(oe);
            }
        }
        StringBuffer sb = new StringBuffer(80);
        HashSet<String> importSet = new HashSet<String>();
        for (Object mFeature : Model.getFacade().getFeatures(cls)) {
            String ftype2;
            if (Model.getFacade().isAAttribute(mFeature)) {
                ftype = this.generateImportType(Model.getFacade().getType(mFeature), packagePath);
                if (ftype == null) continue;
                importSet.add(ftype);
                continue;
            }
            if (!Model.getFacade().isAOperation(mFeature)) continue;
            for (Object parameter : Model.getFacade().getParameters(mFeature)) {
                ftype2 = this.generateImportType(Model.getFacade().getType(parameter), packagePath);
                if (ftype2 == null) continue;
                importSet.add(ftype2);
            }
            for (Object parameter : Model.getCoreHelper().getReturnParameters(mFeature)) {
                ftype2 = this.generateImportType(Model.getFacade().getType(parameter), packagePath);
                if (ftype2 == null) continue;
                importSet.add(ftype2);
            }
            for (Object signal : Model.getFacade().getRaisedSignals(mFeature)) {
                if (!Model.getFacade().isAException(signal) || (ftype2 = this.generateImportType(Model.getFacade().getType(signal), packagePath)) == null) continue;
                importSet.add(ftype2);
            }
        }
        for (Object gen : Model.getFacade().getGeneralizations(cls)) {
            String ftype3;
            Object parent = Model.getFacade().getGeneral(gen);
            if (parent == cls || (ftype3 = this.generateImportType(parent, packagePath)) == null) continue;
            importSet.add(ftype3);
        }
        for (Object iface : Model.getFacade().getSpecifications(cls)) {
            ftype = this.generateImportType(iface, packagePath);
            if (ftype == null) continue;
            importSet.add(ftype);
        }
        for (Object associationEnd : Model.getFacade().getAssociationEnds(cls)) {
            Object association = Model.getFacade().getAssociation(associationEnd);
            for (Object associationEnd2 : Model.getFacade().getConnections(association)) {
                if (associationEnd2 == associationEnd || !Model.getFacade().isNavigable(associationEnd2) || Model.getFacade().isAbstract(Model.getFacade().getAssociation(associationEnd2))) continue;
                if (Model.getFacade().getUpper(associationEnd2) != 1) {
                    importSet.add("java.util.List");
                    continue;
                }
                String ftype4 = this.generateImportType(Model.getFacade().getType(associationEnd2), packagePath);
                if (ftype4 == null) continue;
                importSet.add(ftype4);
            }
        }
        for (String importType : importSet) {
            sb.append("import ").append(importType).append(";");
            sb.append(LINE_SEPARATOR);
        }
        if (!importSet.isEmpty()) {
            sb.append(LINE_SEPARATOR);
        }
        return sb.toString();
    }

    private String generateArtifactImports(Object artifact) {
        StringBuffer ret = new StringBuffer();
        Object compNamespace = Model.getFacade().getNamespace(artifact);
        boolean found = false;
        for (Object o : Model.getFacade().getClientDependencies(artifact)) {
            boolean isJavaImport = false;
            for (Object stereotype : Model.getFacade().getStereotypes(o)) {
                if (!"javaImport".equals(Model.getFacade().getName(stereotype))) continue;
                isJavaImport = true;
                break;
            }
            if (!isJavaImport) continue;
            for (Object elem : Model.getFacade().getSuppliers(o)) {
                Object ns = Model.getFacade().getNamespace(elem);
                if (ns == null || ns.equals(compNamespace)) continue;
                String packageName = this.getPackageName(ns);
                ret.append("import ");
                if (packageName != null && packageName.length() > 0) {
                    ret.append(this.getPackageName(ns));
                    ret.append('.');
                }
                ret.append(Model.getFacade().getName(elem));
                if (Model.getFacade().isAPackage(elem)) {
                    ret.append(".*");
                }
                ret.append(";");
                ret.append(LINE_SEPARATOR);
                found = true;
            }
        }
        if (found) {
            ret.append(LINE_SEPARATOR);
        }
        return ret.toString();
    }

    private String generateImportType(Object type, String exclude) {
        String p;
        String ret = null;
        if (Model.getFacade().isADataType(type) && JAVA_TYPES.contains(Model.getFacade().getName(type))) {
            return null;
        }
        if (type != null && Model.getFacade().getNamespace(type) != null && !(p = this.getPackageName(Model.getFacade().getNamespace(type))).equals(exclude) && !p.equals(LANG_PACKAGE)) {
            ret = p.length() > 0 ? p + '.' + Model.getFacade().getName(type) : Model.getFacade().getName(type);
        }
        return ret;
    }

    private String generateExtensionPoint(Object ep) {
        return null;
    }

    String generateOperation(Object op, boolean documented) {
        String s;
        if (isFileGeneration) {
            documented = true;
        }
        StringBuffer sb = new StringBuffer(80);
        String nameStr = null;
        boolean constructor = false;
        if (Model.getExtensionMechanismsHelper().hasStereotype(op, "create")) {
            nameStr = this.generateName(Model.getFacade().getName(Model.getFacade().getOwner(op)));
            constructor = true;
        } else {
            nameStr = this.generateName(Model.getFacade().getName(op));
        }
        if (documented && (s = GeneratorJava.generateConstraintEnrichedDocComment(op, documented, INDENT)) != null && s.trim().length() > 0) {
            sb.append(s).append(INDENT);
        }
        sb.append(this.generateVisibility(op));
        sb.append(this.generateAbstractness(op));
        sb.append(this.generateScope(op));
        sb.append(this.generateChangeability(op));
        sb.append(this.generateConcurrency(op));
        List returnParams = Model.getCoreHelper().getReturnParameters(op);
        Object rp = returnParams.size() == 0 ? null : returnParams.iterator().next();
        if (returnParams.size() > 1) {
            LOG.warning("Java generator only handles one return parameter - Found " + returnParams.size() + " for " + Model.getFacade().getName(op));
        }
        if (rp != null && !constructor) {
            Object returnType = Model.getFacade().getType(rp);
            if (returnType == null) {
                sb.append("void ");
            } else {
                sb.append(this.generateClassifierRef(returnType)).append(' ');
            }
        }
        ArrayList params = new ArrayList(Model.getFacade().getParameters(op));
        params.remove(rp);
        sb.append(nameStr).append('(');
        if (params != null) {
            for (int i = 0; i < params.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(this.generateParameter(params.get(i)));
            }
        }
        sb.append(')');
        Collection c = Model.getFacade().getRaisedSignals(op);
        if (!c.isEmpty()) {
            Iterator it = c.iterator();
            boolean first = true;
            while (it.hasNext()) {
                Object signal = it.next();
                if (!Model.getFacade().isAException(signal)) continue;
                if (first) {
                    sb.append(" throws ");
                } else {
                    sb.append(", ");
                }
                sb.append(Model.getFacade().getName(it.next()));
                first = false;
            }
        }
        return sb.toString();
    }

    private String generateAttribute(Object attr, boolean documented) {
        String s;
        if (isFileGeneration) {
            documented = true;
        }
        StringBuffer sb = new StringBuffer(80);
        if (documented && (s = GeneratorJava.generateConstraintEnrichedDocComment(attr, documented, INDENT)) != null && s.trim().length() > 0) {
            sb.append(s).append(INDENT);
        }
        sb.append(this.generateCoreAttribute(attr));
        sb.append(";").append(LINE_SEPARATOR);
        return sb.toString();
    }

    String generateCoreAttribute(Object attr) {
        String initStr;
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.generateVisibility(attr));
        sb.append(this.generateScope(attr));
        sb.append(this.generateChangability(attr));
        Object type = Model.getFacade().getType(attr);
        Object multi = Model.getFacade().getMultiplicity(attr);
        if (type != null && multi != null) {
            if (Model.getFacade().getUpper(multi) == 1) {
                sb.append(this.generateClassifierRef(type)).append(' ');
            } else if (Model.getFacade().isADataType(type)) {
                sb.append(this.generateClassifierRef(type)).append("[] ");
            } else {
                sb.append("java.util.List ");
            }
        }
        sb.append(this.generateName(Model.getFacade().getName(attr)));
        Object init = Model.getFacade().getInitialValue(attr);
        if (init != null && (initStr = this.generateExpression(init).trim()).length() > 0) {
            sb.append(" = ").append(initStr);
        }
        return sb.toString();
    }

    private String generateEnumerationLiteral(Object literal, boolean documented, char sep) {
        String s;
        if (isFileGeneration) {
            documented = true;
        }
        StringBuffer sb = new StringBuffer(80);
        if (documented && (s = GeneratorJava.generateConstraintEnrichedDocComment(literal, documented, INDENT)) != null && s.trim().length() > 0) {
            sb.append(s).append(INDENT);
        }
        sb.append(this.generateName(Model.getFacade().getName(literal)));
        sb.append(sep).append(LINE_SEPARATOR);
        return sb.toString();
    }

    private String generateParameter(Object parameter) {
        StringBuffer sb = new StringBuffer(20);
        sb.append(this.generateClassifierRef(Model.getFacade().getType(parameter)));
        sb.append(' ');
        sb.append(this.generateName(Model.getFacade().getName(parameter)));
        return sb.toString();
    }

    private String generatePackage(Object p) {
        StringBuffer sb = new StringBuffer(80);
        String packName = this.generateName(Model.getFacade().getName(p));
        sb.append("package ").append(packName).append(" {");
        sb.append(LINE_SEPARATOR);
        Collection ownedElements = Model.getFacade().getOwnedElements(p);
        for (Object modelElement : ownedElements) {
            sb.append(this.generate(modelElement));
            sb.append(LINE_SEPARATOR).append(LINE_SEPARATOR);
        }
        sb.append(LINE_SEPARATOR).append("})").append(LINE_SEPARATOR);
        return sb.toString();
    }

    StringBuffer generateClassifierStart(Object cls) {
        Object smod;
        String sClassifierKeyword;
        if (Model.getFacade().isAClass(cls)) {
            sClassifierKeyword = "class";
        } else if (Model.getFacade().isAInterface(cls)) {
            sClassifierKeyword = "interface";
        } else if (Model.getFacade().isAEnumeration(cls)) {
            sClassifierKeyword = "enum";
        } else {
            return null;
        }
        StringBuffer sb = new StringBuffer(80);
        sb.append(DocumentationManager.getComments((Object)cls));
        sb.append(GeneratorJava.generateConstraintEnrichedDocComment(cls, true, ""));
        if (Model.getFacade().isPublic(cls) || Model.getFacade().isAClassifier(Model.getFacade().getNamespace(cls))) {
            sb.append(this.generateVisibility(Model.getFacade().getVisibility(cls)));
        }
        if (Model.getFacade().isAbstract(cls) && !Model.getFacade().isAInterface(cls)) {
            sb.append("abstract ");
        }
        if (Model.getFacade().isLeaf(cls)) {
            sb.append("final ");
        }
        if ((smod = Model.getFacade().getTaggedValue(cls, "src_modifiers")) != null && Model.getFacade().getValue(smod) != null) {
            sb.append(" ");
            sb.append(Model.getFacade().getValue(smod));
            sb.append(" ");
        }
        sb.append(sClassifierKeyword).append(" ");
        sb.append(this.generateName(Model.getFacade().getName(cls)));
        List templateParameters = Model.getFacade().getTemplateParameters(cls);
        for (int i = 0; i < templateParameters.size(); ++i) {
            if (i == 0) {
                sb.append("<");
            }
            Object param = Model.getFacade().getParameter(templateParameters.get(i));
            sb.append(Model.getFacade().getName(param));
            for (String bound : new String[]{"extends", "super"}) {
                String s = Model.getFacade().getTaggedValueValue(param, bound);
                if (s == null || s.toString().trim().length() <= 0) continue;
                sb.append(" " + bound + " " + s);
            }
            if (i == templateParameters.size() - 1) {
                sb.append(">");
                continue;
            }
            sb.append(", ");
        }
        String baseClass = this.generateGeneralization(Model.getFacade().getGeneralizations(cls));
        if (!baseClass.equals("")) {
            sb.append(" ").append("extends ").append(baseClass);
        }
        if (Model.getFacade().isAClass(cls)) {
            String interfaces = this.generateSpecification(cls);
            LOG.fine("Specification: " + interfaces);
            if (!interfaces.equals("")) {
                sb.append(" ").append("implements ").append(interfaces);
            }
        }
        sb.append(this.lfBeforeCurly ? LINE_SEPARATOR + "{" : " {");
        String tv = this.generateTaggedValues(cls);
        if (tv != null && tv.length() > 0) {
            sb.append(LINE_SEPARATOR).append(INDENT).append(tv);
        }
        return sb;
    }

    private StringBuffer generateClassifierEnd(Object cls) {
        StringBuffer sb = new StringBuffer();
        if (Model.getFacade().isAClass(cls) || Model.getFacade().isAInterface(cls) || Model.getFacade().isAEnumeration(cls)) {
            if (this.verboseDocs) {
                String classifierkeyword = null;
                classifierkeyword = Model.getFacade().isAClass(cls) ? "class" : "interface";
                sb.append(LINE_SEPARATOR);
                sb.append("//end of ").append(classifierkeyword);
                sb.append(" ").append(Model.getFacade().getName(cls));
                sb.append(LINE_SEPARATOR);
            }
            sb.append(LINE_SEPARATOR);
            sb.append("}");
        }
        return sb;
    }

    StringBuffer appendClassifierEnd(StringBuffer sbPrefix, Object cls) {
        sbPrefix.append(this.generateClassifierEnd(cls));
        return sbPrefix;
    }

    private String generateClassifier(Object cls) {
        StringBuffer returnValue = new StringBuffer();
        StringBuffer start = this.generateClassifierStart(cls);
        if (start != null && start.length() > 0) {
            StringBuffer body = this.generateClassifierBody(cls);
            StringBuffer end = this.generateClassifierEnd(cls);
            returnValue.append(start.toString());
            if (body != null && body.length() > 0) {
                returnValue.append(LINE_SEPARATOR);
                returnValue.append(body);
                if (this.lfBeforeCurly) {
                    returnValue.append(LINE_SEPARATOR);
                }
            }
            returnValue.append(end != null ? end.toString() : "");
        }
        return returnValue.toString();
    }

    private StringBuffer generateClassifierBody(Object cls) {
        StringBuffer sb = new StringBuffer();
        if (Model.getFacade().isAClass(cls) || Model.getFacade().isAInterface(cls) || Model.getFacade().isAEnumeration(cls)) {
            Collection ends;
            String tv = null;
            List sFeatures = Model.getFacade().getStructuralFeatures(cls);
            if (!sFeatures.isEmpty()) {
                sb.append(LINE_SEPARATOR);
                if (this.verboseDocs && Model.getFacade().isAClass(cls)) {
                    sb.append(INDENT).append("// Attributes");
                    sb.append(LINE_SEPARATOR);
                }
                boolean first = true;
                for (Object structuralFeature : sFeatures) {
                    if (!first) {
                        sb.append(LINE_SEPARATOR);
                    }
                    sb.append(INDENT);
                    sb.append(this.generateAttribute(structuralFeature, false));
                    tv = this.generateTaggedValues(structuralFeature);
                    if (tv != null && tv.length() > 0) {
                        sb.append(INDENT).append(tv);
                    }
                    first = false;
                }
            }
            if (Model.getFacade().isAEnumeration(cls)) {
                this.addLiterals(cls, sb);
            }
            if (!(ends = Model.getFacade().getAssociationEnds(cls)).isEmpty()) {
                this.addAttributesImplementingAssociations(cls, sb, ends);
            }
            Collection elements = Model.getFacade().getOwnedElements(cls);
            for (Object element : elements) {
                if (!Model.getFacade().isAClass(element) && !Model.getFacade().isAInterface(element)) continue;
                sb.append(this.generateClassifier(element));
            }
            List bFeatures = Model.getFacade().getOperations(cls);
            if (!bFeatures.isEmpty()) {
                this.addOperations(cls, sb, bFeatures);
            }
        }
        return sb;
    }

    private void addOperations(Object cls, StringBuffer sb, Collection bFeatures) {
        sb.append(LINE_SEPARATOR);
        if (this.verboseDocs) {
            sb.append(INDENT).append("// Operations");
            sb.append(LINE_SEPARATOR);
        }
        boolean first = true;
        for (Object behavioralFeature : bFeatures) {
            if (!first) {
                sb.append(LINE_SEPARATOR);
            }
            sb.append(INDENT);
            sb.append(this.generateOperation(behavioralFeature, false));
            String tv = this.generateTaggedValues(behavioralFeature);
            if (Model.getFacade().isAClass(cls) && Model.getFacade().isAOperation(behavioralFeature) && !Model.getFacade().isAbstract(behavioralFeature)) {
                if (this.lfBeforeCurly) {
                    sb.append(LINE_SEPARATOR).append(INDENT);
                } else {
                    sb.append(' ');
                }
                sb.append('{');
                if (tv.length() > 0) {
                    sb.append(LINE_SEPARATOR).append(INDENT).append(tv);
                }
                sb.append(LINE_SEPARATOR);
                sb.append(this.generateMethodBody(behavioralFeature));
                sb.append(INDENT);
                sb.append("}").append(LINE_SEPARATOR);
            } else {
                sb.append(";").append(LINE_SEPARATOR);
                if (tv.length() > 0) {
                    sb.append(INDENT).append(tv).append(LINE_SEPARATOR);
                }
            }
            first = false;
        }
    }

    private void addAttributesImplementingAssociations(Object cls, StringBuffer sb, Collection ends) {
        sb.append(LINE_SEPARATOR);
        if (this.verboseDocs && Model.getFacade().isAClass(cls)) {
            sb.append(INDENT).append("// Associations");
            sb.append(LINE_SEPARATOR);
        }
        for (Object associationEnd : ends) {
            Object association = Model.getFacade().getAssociation(associationEnd);
            sb.append(this.generateAssociationFrom(association, associationEnd));
            String tv = this.generateTaggedValues(association);
            if (tv == null || tv.length() <= 0) continue;
            sb.append(INDENT).append(tv);
        }
    }

    private void addLiterals(Object cls, StringBuffer sb) {
        List literals = Model.getFacade().getEnumerationLiterals(cls);
        if (!literals.isEmpty()) {
            sb.append(LINE_SEPARATOR);
            if (this.verboseDocs) {
                sb.append(INDENT).append("// Literals");
                sb.append(LINE_SEPARATOR);
            }
            boolean first = true;
            int size = literals.size();
            int cnt = 0;
            for (Object literal : literals) {
                ++cnt;
                if (!first) {
                    sb.append(LINE_SEPARATOR);
                }
                sb.append(INDENT);
                char sep = cnt != size ? (char)',' : ';';
                sb.append(this.generateEnumerationLiteral(literal, false, sep));
                String tv = this.generateTaggedValues(literal);
                if (tv != null && tv.length() > 0) {
                    sb.append(INDENT).append(tv);
                }
                first = false;
            }
        }
    }

    private String generateMethodBody(Object op) {
        if (op != null) {
            for (Object m : Model.getFacade().getMethods(op)) {
                if (m == null) continue;
                if (Model.getFacade().getBody(m) != null) {
                    String body = (String)Model.getFacade().getBody(Model.getFacade().getBody(m));
                    StringTokenizer tokenizer = new StringTokenizer(body, "\r\n");
                    StringBuffer bsb = new StringBuffer();
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        if (token.length() <= 0) continue;
                        bsb.append(token);
                        bsb.append(LINE_SEPARATOR);
                    }
                    if (bsb.length() <= 0) {
                        bsb.append(LINE_SEPARATOR);
                    }
                    return bsb.toString();
                }
                return "";
            }
            List returnParams = Model.getCoreHelper().getReturnParameters(op);
            Object rp = returnParams.size() == 0 ? null : returnParams.iterator().next();
            if (returnParams.size() > 1) {
                LOG.warning("Java generator only handles one return parameter - Found " + returnParams.size() + " for " + Model.getFacade().getName(op));
            }
            if (rp != null) {
                Object returnType = Model.getFacade().getType(rp);
                return this.generateDefaultReturnStatement(returnType);
            }
        }
        return this.generateDefaultReturnStatement(null);
    }

    private String generateDefaultReturnStatement(Object cls) {
        if (cls == null) {
            return "";
        }
        String clsName = Model.getFacade().getName(cls);
        if (clsName.equals("void")) {
            return "";
        }
        if (clsName.equals("char")) {
            return "  return 'x';" + LINE_SEPARATOR;
        }
        if (clsName.equals("int")) {
            return "  return 0;" + LINE_SEPARATOR;
        }
        if (clsName.equals("boolean")) {
            return "  return false;" + LINE_SEPARATOR;
        }
        if (clsName.equals("byte")) {
            return "  return 0;" + LINE_SEPARATOR;
        }
        if (clsName.equals("long")) {
            return "  return 0;" + LINE_SEPARATOR;
        }
        if (clsName.equals("float")) {
            return "  return 0.0;" + LINE_SEPARATOR;
        }
        if (clsName.equals("double")) {
            return "  return 0.0;" + LINE_SEPARATOR;
        }
        return "  return null;" + LINE_SEPARATOR;
    }

    private String generateTaggedValues(Object e) {
        if (isInUpdateMode) {
            return "";
        }
        Iterator iter = Model.getFacade().getTaggedValues(e);
        if (iter == null) {
            return "";
        }
        boolean first = true;
        StringBuffer buf = new StringBuffer();
        String s = null;
        while (iter.hasNext()) {
            s = this.generateTaggedValue(iter.next());
            if (s == null || s.length() <= 0) continue;
            if (first) {
                buf.append("/* {");
                first = false;
            } else {
                buf.append(", ");
            }
            buf.append(s);
        }
        if (!first) {
            buf.append("}*/").append(LINE_SEPARATOR);
        }
        return buf.toString();
    }

    private String generateTaggedValue(Object tv) {
        if (tv == null) {
            return "";
        }
        String s = this.generateUninterpreted(Model.getFacade().getValueOfTag(tv));
        if (s == null || s.length() == 0 || s.equals("/** */")) {
            return "";
        }
        String t = Model.getFacade().getTagOfTag(tv);
        if ("documentation".equals(t)) {
            return "";
        }
        return this.generateName(t) + "=" + s;
    }

    private String generateConstraintEnrichedDocComment(Object me, Object ae) {
        String s = GeneratorJava.generateConstraintEnrichedDocComment(me, true, INDENT);
        if (this.isCollection(ae)) {
            StringBuffer sDocComment = new StringBuffer(80);
            if (s != null && !"".equals(s)) {
                sDocComment.append(s.substring(0, s.indexOf("*/") + 1));
            } else {
                sDocComment.append(INDENT).append("/**").append(LINE_SEPARATOR);
                sDocComment.append(INDENT).append("  * ").append(LINE_SEPARATOR);
                sDocComment.append(INDENT).append("  *");
            }
            sDocComment.append(LINE_SEPARATOR).append(INDENT).append(" */");
            sDocComment.append(LINE_SEPARATOR);
            return sDocComment.toString();
        }
        return s != null ? s : "";
    }

    private boolean isCollection(Object element) {
        int upper;
        Object multiplicity = Model.getFacade().getMultiplicity(element);
        return multiplicity != null && ((upper = Model.getFacade().getUpper(multiplicity)) > 1 || upper == -1);
    }

    public static String generateConstraintEnrichedDocComment(Object me, boolean documented, String indent) {
        if (isFileGeneration) {
            documented = true;
        }
        String s = DocumentationManager.hasDocs((Object)me) ? DocumentationManager.getDocs((Object)me, (String)indent) : null;
        StringBuffer sDocComment = new StringBuffer(80);
        if (s != null && s.trim().length() > 0) {
            sDocComment.append(s).append(LINE_SEPARATOR);
        }
        LOG.fine("documented=" + documented);
        if (!documented) {
            return sDocComment.toString();
        }
        Collection cConstraints = Model.getFacade().getConstraints(me);
        if (cConstraints.size() == 0) {
            return sDocComment.toString();
        }
        if (s != null) {
            s = sDocComment.toString();
            sDocComment = new StringBuffer(s.substring(0, s.indexOf("*/") + 1));
        } else {
            sDocComment.append(INDENT).append("/**").append(LINE_SEPARATOR);
            sDocComment.append(INDENT).append(" * ").append(LINE_SEPARATOR);
            sDocComment.append(INDENT).append(" *");
        }
        ArgoFacade mf = new ArgoFacade(me);
        for (Object constraint : cConstraints) {
            try {
                String body = (String)Model.getFacade().getBody(Model.getFacade().getBody(constraint));
                OclTree otParsed = OclTree.createTree((String)body, (ModelFacade)mf);
                class TagExtractor
                extends DepthFirstAdapter {
                    private LinkedList<String> llsTags = new LinkedList();
                    private String constraintName;
                    private int constraintID;

                    public TagExtractor(String sConstraintName) {
                        this.constraintName = sConstraintName;
                    }

                    public Iterator getTags() {
                        return this.llsTags.iterator();
                    }

                    public void caseAConstraintBody(AConstraintBody node) {
                        String sTag;
                        String sName;
                        String sKind = node.getStereotype() != null ? node.getStereotype().toString() : null;
                        String sExpression = node.getExpression() != null ? node.getExpression().toString() : null;
                        String string = sName = node.getName() != null ? node.getName().getText() : this.constraintName + "_" + this.constraintID++;
                        if (sKind == null || sExpression == null) {
                            return;
                        }
                        if (sKind.equals("inv ")) {
                            sTag = "@invariant ";
                        } else if (sKind.equals("post ")) {
                            sTag = "@postcondition ";
                        } else if (sKind.equals("pre ")) {
                            sTag = "@precondition ";
                        } else {
                            return;
                        }
                        sTag = sTag + sName + ": " + sExpression;
                        this.llsTags.addLast(sTag);
                    }
                }
                TagExtractor te = new TagExtractor(Model.getFacade().getName(constraint));
                otParsed.apply((Switch)te);
                Iterator j = te.getTags();
                while (j.hasNext()) {
                    sDocComment.append(' ').append(j.next());
                    sDocComment.append(LINE_SEPARATOR);
                    sDocComment.append(INDENT).append(" *");
                }
            }
            catch (IOException ioe) {
                LOG.log(Level.SEVERE, "Nothing to be done, should not happen", ioe);
            }
        }
        sDocComment.append("/").append(LINE_SEPARATOR);
        return sDocComment.toString();
    }

    private String generateAssociationFrom(Object a, Object associationEnd) {
        StringBuffer sb = new StringBuffer(80);
        Collection connections = Model.getFacade().getConnections(a);
        for (Object associationEnd2 : connections) {
            if (associationEnd2 == associationEnd) continue;
            sb.append(INDENT);
            sb.append(this.generateConstraintEnrichedDocComment(a, associationEnd2));
            sb.append(this.generateAssociationEnd(associationEnd2));
        }
        return sb.toString();
    }

    private String generateAssociationEnd(Object ae) {
        if (!Model.getFacade().isNavigable(ae)) {
            return "";
        }
        if (Model.getFacade().isAbstract(Model.getFacade().getAssociation(ae))) {
            return "";
        }
        StringBuffer sb = new StringBuffer(80);
        sb.append(INDENT).append(this.generateCoreAssociationEnd(ae));
        return sb.append(";").append(LINE_SEPARATOR).toString();
    }

    String generateCoreAssociationEnd(Object ae) {
        StringBuffer sb = new StringBuffer(80);
        sb.append(this.generateVisibility(Model.getFacade().getVisibility(ae)));
        if (Model.getFacade().isStatic(ae)) {
            sb.append("static ");
        }
        if (Model.getFacade().isFrozen(ae)) {
            sb.append("final ");
        }
        if (Model.getFacade().getUpper(ae) == 1) {
            sb.append(this.generateClassifierRef(Model.getFacade().getType(ae)));
        } else {
            sb.append("List");
            Object type = Model.getFacade().getType(ae);
            sb.append(String.format("<%s>", Model.getFacade().getName(type)));
        }
        sb.append(' ').append(this.generateAscEndName(ae));
        return sb.toString();
    }

    private String generateGeneralization(Collection generalizations) {
        if (generalizations == null) {
            return "";
        }
        ArrayList<Object> classes = new ArrayList<Object>();
        for (Object generalization : generalizations) {
            Object generalizableElement = Model.getFacade().getGeneral(generalization);
            if (generalizableElement == null) continue;
            classes.add(generalizableElement);
        }
        return this.generateClassList(classes);
    }

    private String generateSpecification(Object cls) {
        Collection realizations = Model.getFacade().getSpecifications(cls);
        if (realizations == null) {
            return "";
        }
        LOG.fine("realizations: " + realizations.size());
        StringBuffer sb = new StringBuffer(80);
        Iterator clsEnum = realizations.iterator();
        while (clsEnum.hasNext()) {
            Object inter = clsEnum.next();
            sb.append(this.generateClassifierRef(inter));
            if (!clsEnum.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String generateClassList(Collection classifiers) {
        if (classifiers == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(80);
        Iterator clsEnum = classifiers.iterator();
        while (clsEnum.hasNext()) {
            sb.append(this.generateClassifierRef(clsEnum.next()));
            if (!clsEnum.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    private String generateVisibility(Object o) {
        String tagged;
        Object tv;
        if (Model.getFacade().isAFeature(o) && (tv = Model.getFacade().getTaggedValue(o, "src_visibility")) != null && (tagged = (String)Model.getFacade().getValue(tv)) != null) {
            if (tagged.trim().equals("") || tagged.trim().toLowerCase().equals("package") || tagged.trim().toLowerCase().equals("default")) {
                return "";
            }
            return tagged + " ";
        }
        if (Model.getFacade().isAModelElement(o)) {
            if (Model.getFacade().isPublic(o)) {
                return "public ";
            }
            if (Model.getFacade().isPrivate(o)) {
                return "private ";
            }
            if (Model.getFacade().isProtected(o)) {
                return "protected ";
            }
            if (Model.getFacade().isPackage(o)) {
                return "";
            }
        }
        if (Model.getFacade().isAVisibilityKind(o)) {
            if (Model.getVisibilityKind().getPublic().equals(o)) {
                return "public ";
            }
            if (Model.getVisibilityKind().getPrivate().equals(o)) {
                return "private ";
            }
            if (Model.getVisibilityKind().getProtected().equals(o)) {
                return "protected ";
            }
            if (Model.getVisibilityKind().getPackage().equals(o)) {
                return "";
            }
        }
        return "";
    }

    private String generateScope(Object f) {
        if (Model.getFacade().isStatic(f)) {
            return "static ";
        }
        return "";
    }

    private String generateAbstractness(Object op) {
        if (Model.getFacade().isAbstract(op)) {
            return "abstract ";
        }
        return "";
    }

    private String generateChangeability(Object op) {
        if (Model.getFacade().isLeaf(op)) {
            return "final ";
        }
        return "";
    }

    private String generateChangability(Object sf) {
        if (Model.getFacade().isReadOnly(sf)) {
            return "final ";
        }
        return "";
    }

    private String generateConcurrency(Object op) {
        if (Model.getFacade().getConcurrency(op) != null && Model.getConcurrencyKind().getGuarded().equals(Model.getFacade().getConcurrency(op))) {
            return "synchronized ";
        }
        return "";
    }

    private String generateMultiplicity(Object m) {
        if (m == null || "1".equals(Model.getFacade().toString(m))) {
            return "";
        }
        return Model.getFacade().toString(m);
    }

    private String generateState(Object m) {
        return Model.getFacade().getName(m);
    }

    private String generateTransition(Object m) {
        StringBuffer sb = new StringBuffer(this.generateName(Model.getFacade().getName(m)));
        String t = this.generateEvent(Model.getFacade().getTrigger(m));
        String g = this.generateGuard(Model.getFacade().getGuard(m));
        String e = this.generateAction(Model.getFacade().getEffect(m));
        if (sb.length() > 0) {
            sb.append(": ");
        }
        sb.append(t);
        if (g.length() > 0) {
            sb.append(" [").append(g).append(']');
        }
        if (e.length() > 0) {
            sb.append(" / ").append(e);
        }
        return sb.toString();
    }

    private String generateAction(Object m) {
        Object script;
        if (m != null && (script = Model.getFacade().getScript(m)) != null && Model.getFacade().getBody(script) != null) {
            return Model.getFacade().getBody(script).toString();
        }
        return "";
    }

    private String generateGuard(Object m) {
        if (m != null && Model.getFacade().getExpression(m) != null) {
            return this.generateExpression(Model.getFacade().getExpression(m));
        }
        return "";
    }

    private String generateMessage(Object m) {
        if (m == null) {
            return "";
        }
        return this.generateName(Model.getFacade().getName(m)) + "::" + this.generateAction(Model.getFacade().getAction(m));
    }

    private String generateEvent(Object m) {
        if (Model.getFacade().isAChangeEvent(m)) {
            return "when(" + this.generateExpression(Model.getFacade().getExpression(m)) + ")";
        }
        if (Model.getFacade().isATimeEvent(m)) {
            return "after(" + this.generateExpression(Model.getFacade().getExpression(m)) + ")";
        }
        if (Model.getFacade().isASignalEvent(m)) {
            return this.generateName(Model.getFacade().getName(m));
        }
        if (Model.getFacade().isACallEvent(m)) {
            return this.generateName(Model.getFacade().getName(m));
        }
        return "";
    }

    String generateAscEndName(Object ae) {
        String n = Model.getFacade().getName(ae);
        Object asc = Model.getFacade().getAssociation(ae);
        String ascName = Model.getFacade().getName(asc);
        n = n != null && n.length() > 0 ? this.generateName(n) : (ascName != null && ascName.length() > 0 ? this.generateName(ascName) : this.generateClassifierRef(Model.getFacade().getType(ae)));
        n = String.valueOf(n.charAt(0)).toLowerCase() + n.substring(1);
        return n;
    }

    public String getPackageName(Object namespace) {
        if (namespace == null || !Model.getFacade().isANamespace(namespace) || Model.getFacade().getNamespace(namespace) == null) {
            return "";
        }
        String packagePath = Model.getFacade().getName(namespace);
        if (packagePath == null) {
            return "";
        }
        while ((namespace = Model.getFacade().getNamespace(namespace)) != null) {
            if (Model.getFacade().getNamespace(namespace) == null) continue;
            packagePath = Model.getFacade().getName(namespace) + '.' + packagePath;
        }
        return packagePath;
    }

    public String getName() {
        return "GeneratorJava";
    }

    public String getInfo(int type) {
        switch (type) {
            case 0: {
                return "Java notation and code generator";
            }
            case 1: {
                return "The ArgoUML project team";
            }
            case 2: {
                return "0.33.8";
            }
            case 3: {
                return "http://argouml-java.tigris.org/";
            }
        }
        return null;
    }

    public boolean enable() {
        GeneratorManager.getInstance().addGenerator(java, (CodeGenerator)this);
        return true;
    }

    public boolean disable() {
        GeneratorManager.getInstance().removeGenerator(java);
        return true;
    }

    public boolean isLfBeforeCurly() {
        return this.lfBeforeCurly;
    }

    public boolean isVerboseDocs() {
        return this.verboseDocs;
    }

    public void setLfBeforeCurly(boolean beforeCurl) {
        this.lfBeforeCurly = beforeCurl;
    }

    public void setVerboseDocs(boolean verbose) {
        this.verboseDocs = verbose;
    }

    private String generateActionState(Object actionState) {
        Object expression;
        String ret = "";
        Object action = Model.getFacade().getEntry(actionState);
        if (action != null && (expression = Model.getFacade().getScript(action)) != null) {
            ret = this.generateExpression(expression);
        }
        return ret;
    }

    private String generateExpression(Object expr) {
        if (Model.getFacade().isAExpression(expr)) {
            return this.generateUninterpreted((String)Model.getFacade().getBody(expr));
        }
        if (Model.getFacade().isAConstraint(expr)) {
            return this.generateExpression(Model.getFacade().getBody(expr));
        }
        return "";
    }

    private String generateName(String n) {
        return n;
    }

    private String generateUninterpreted(String un) {
        if (un == null) {
            return "";
        }
        return un;
    }

    private String generateClassifierRef(Object cls) {
        if (cls == null) {
            return "";
        }
        return Model.getFacade().getName(cls);
    }

    private String generateStereotype(Object st) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection generate(Collection elements, boolean deps) {
        LOG.fine("generate() called");
        File tmpdir = null;
        try {
            tmpdir = TempFileUtils.createTempDir();
            if (tmpdir != null) {
                this.generateFiles(elements, tmpdir.getPath(), deps);
                Collection collection = TempFileUtils.readAllFiles((File)tmpdir);
                return collection;
            }
            List list = Collections.EMPTY_LIST;
            return list;
        }
        finally {
            if (tmpdir != null) {
                TempFileUtils.deleteDir((File)tmpdir);
            }
            LOG.fine("generate() terminated");
        }
    }

    public Collection generateFiles(Collection elements, String path, boolean deps) {
        LOG.fine("generateFiles() called");
        for (Object element : elements) {
            this.generateFile(element, path);
        }
        return TempFileUtils.readFileNames((File)new File(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection generateFileList(Collection elements, boolean deps) {
        LOG.fine("generateFileList() called");
        File tmpdir = null;
        try {
            tmpdir = TempFileUtils.createTempDir();
            for (Object element : elements) {
                this.generateFile(element, tmpdir.getName());
            }
            Collection collection = TempFileUtils.readFileNames((File)tmpdir);
            return collection;
        }
        finally {
            if (tmpdir != null) {
                TempFileUtils.deleteDir((File)tmpdir);
            }
        }
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("void");
        types.add("boolean");
        types.add("byte");
        types.add("char");
        types.add("int");
        types.add("short");
        types.add("long");
        types.add("float");
        types.add("double");
        JAVA_TYPES = Collections.unmodifiableSet(types);
        java = GeneratorHelper.makeLanguage((String)"Java", (String)"Java", (Icon)ResourceLoaderWrapper.lookupIconResource((String)"JavaNotation"));
    }
}

