/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.java.reveng;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.antlr.runtime.ANTLRReaderStream;
import org.antlr.runtime.CommonTokenStream;
import org.argouml.i18n.Translator;
import org.argouml.kernel.Project;
import org.argouml.language.java.reveng.JavaImportSettings;
import org.argouml.language.java.reveng.JavaLexer;
import org.argouml.language.java.reveng.JavaParser;
import org.argouml.language.java.reveng.Modeller;
import org.argouml.profile.Profile;
import org.argouml.taskmgmt.ProgressMonitor;
import org.argouml.uml.reveng.FileImportUtils;
import org.argouml.uml.reveng.ImportClassLoader;
import org.argouml.uml.reveng.ImportInterface;
import org.argouml.uml.reveng.ImportSettings;
import org.argouml.uml.reveng.ImporterManager;
import org.argouml.uml.reveng.SettingsTypes;
import org.argouml.util.SuffixFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImport
implements ImportInterface {
    private static final Logger LOG = Logger.getLogger(JavaImport.class.getName());
    private Profile javaProfile = null;
    private Collection<Object> newElements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection parseFiles(Project p, Collection<File> files, ImportSettings settings, ProgressMonitor monitor) throws ImportInterface.ImportException {
        JavaImportSettings.getInstance().saveSettings();
        this.updateImportClassloader();
        this.newElements = new HashSet<Object>();
        monitor.updateMainTask(Translator.localize((String)"dialog.import.pass1"));
        this.javaProfile = this.getJavaProfile(p);
        if (settings.getImportLevel() == 1 || settings.getImportLevel() == 2) {
            monitor.setMaximumProgress(files.size() * 2);
            this.doImportPass(p, files, settings, monitor, 0, 0);
            if (!monitor.isCanceled()) {
                monitor.updateMainTask(Translator.localize((String)"dialog.import.pass2"));
                this.doImportPass(p, files, settings, monitor, files.size(), 1);
            }
        } else {
            monitor.setMaximumProgress(files.size() * 2);
            this.doImportPass(p, files, settings, monitor, 0, 0);
        }
        return this.newElements;
    }

    private void doImportPass(Project p, Collection<File> files, ImportSettings settings, ProgressMonitor monitor, int startCount, int pass) {
        int count = startCount;
        for (File file : files) {
            if (monitor.isCanceled()) {
                monitor.updateSubTask(Translator.localize((String)"dialog.import.cancelled"));
                return;
            }
            try {
                this.parseFile(p, file, settings, pass);
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                monitor.notifyMessage(Translator.localize((String)"dialog.title.import-problems"), Translator.localize((String)"label.import-problems"), sw.toString());
                if (monitor.isCanceled()) break;
            }
            monitor.updateProgress(count++);
            monitor.updateSubTask(Translator.localize((String)"dialog.import.parsingAction", (Object[])new Object[]{file.getAbsolutePath()}));
        }
    }

    private void parseFile(Project p, File f, ImportSettings settings, int pass) throws ImportInterface.ImportException {
        try {
            InputStreamReader isr;
            String encoding = settings.getInputSourceEncoding();
            FileInputStream in = new FileInputStream(f);
            try {
                isr = new InputStreamReader((InputStream)in, encoding);
            }
            catch (UnsupportedEncodingException e) {
                isr = new InputStreamReader(in);
            }
            JavaLexer lexer = new JavaLexer(new ANTLRReaderStream(isr));
            JavaParser parser = new JavaParser(new CommonTokenStream(lexer));
            int parserMode = 3;
            if (pass == 0) {
                parserMode = 1;
            } else if (pass == 1) {
                parserMode = 2;
            }
            parser.setParserMode(parserMode);
            Modeller modeller = new Modeller(p.getUserDefinedModelList().get(0), this.javaProfile, JavaImportSettings.getInstance().isAttributeSelected(), JavaImportSettings.getInstance().isDatatypeSelected(), f.getName());
            LOG.info("Parsing " + f.getAbsolutePath());
            int level = 0;
            int importlevel = settings.getImportLevel();
            if (importlevel == 1) {
                level = 1;
            } else if (importlevel == 2) {
                level = pass == 0 ? 0 : 2;
            }
            modeller.setAttribute("level", level);
            try {
                parser.compilationUnit(modeller, lexer);
            }
            catch (Exception e) {
                String errorString = this.buildErrorString(f);
                LOG.log(Level.SEVERE, e.getClass().getName() + errorString, e);
                throw new ImportInterface.ImportException(errorString, (Throwable)e);
            }
            finally {
                this.newElements.addAll(modeller.getNewElements());
                in.close();
            }
        }
        catch (IOException e) {
            throw new ImportInterface.ImportException(this.buildErrorString(f), (Throwable)e);
        }
    }

    private String buildErrorString(File f) {
        String path = "";
        try {
            path = f.getCanonicalPath();
        }
        catch (IOException e) {
            LOG.log(Level.FINEST, "Cannot get the Canonical Path, using name without path", e);
        }
        return "Exception in file: " + path + " " + f.getName();
    }

    public SuffixFilter[] getSuffixFilters() {
        SuffixFilter[] result = new SuffixFilter[]{new SuffixFilter("java", Translator.localize((String)"java.filefilter.java"))};
        return result;
    }

    public boolean isParseable(File file) {
        return FileImportUtils.matchesSuffix((Object)file, (SuffixFilter[])this.getSuffixFilters());
    }

    public String getName() {
        return "Java";
    }

    public String getInfo(int type) {
        switch (type) {
            case 0: {
                return "Java import from Java files.";
            }
            case 1: {
                return "The ArgoUML project team";
            }
            case 2: {
                return "0.33.8";
            }
            case 3: {
                return "http://argouml-java.tigris.org/";
            }
        }
        return null;
    }

    public boolean disable() {
        return false;
    }

    public boolean enable() {
        ImporterManager.getInstance().addImporter((ImportInterface)this);
        return true;
    }

    public List<SettingsTypes.Setting> getImportSettings() {
        return JavaImportSettings.getInstance().getImportSettings();
    }

    private void updateImportClassloader() {
        List<String> pathList = JavaImportSettings.getInstance().getPathList();
        URL[] urls = new URL[pathList.size()];
        int i = 0;
        for (String path : pathList) {
            try {
                urls[i++] = new File(path).toURI().toURL();
            }
            catch (MalformedURLException e) {
                LOG.severe("Bad path in classpath " + path);
            }
        }
        try {
            ImportClassLoader.getInstance((URL[])urls);
            ImportClassLoader.getInstance().saveUserPath();
        }
        catch (MalformedURLException e) {
            LOG.log(Level.FINEST, "Bad path in classpaths", e);
        }
    }

    private Profile getJavaProfile(Project p) {
        for (Profile profile : p.getProfileConfiguration().getProfiles()) {
            if (!"Java".equals(profile.getDisplayName())) continue;
            return profile;
        }
        return null;
    }
}

