/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.language.csharp.importer.csparser.types;

import java.util.ArrayList;
import java.util.List;
import org.argouml.language.csharp.importer.csparser.collections.NodeCollection;
import org.argouml.language.csharp.importer.csparser.members.InterfaceEventNode;
import org.argouml.language.csharp.importer.csparser.members.InterfaceIndexerNode;
import org.argouml.language.csharp.importer.csparser.members.InterfaceMethodNode;
import org.argouml.language.csharp.importer.csparser.members.InterfacePropertyNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.BaseNode;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.IdentifierExpression;
import org.argouml.language.csharp.importer.csparser.nodes.expressions.TypeNode;

public class InterfaceNode
extends BaseNode {
    public long Modifiers;
    public IdentifierExpression Name;
    public List<TypeNode> BaseClasses = new ArrayList<TypeNode>();
    public NodeCollection<InterfaceMethodNode> Methods = new NodeCollection();
    public NodeCollection<InterfacePropertyNode> Properties = new NodeCollection();
    public NodeCollection<InterfaceIndexerNode> Indexers = new NodeCollection();
    public NodeCollection<InterfaceEventNode> Events = new NodeCollection();

    public void ToSource(StringBuilder sb) {
        if (this.attributes != null) {
            this.attributes.ToSource(sb);
            this.NewLine(sb);
        }
        this.TraceModifiers(this.Modifiers, sb);
        sb.append("interface ");
        this.Name.ToSource(sb);
        sb.append(" ");
        if (this.BaseClasses != null && this.BaseClasses.size() > 1) {
            sb.append(": ");
            String comma = "";
            for (TypeNode bcls : this.BaseClasses) {
                sb.append(comma);
                comma = ", ";
                bcls.ToSource(sb);
            }
        }
        this.NewLine(sb);
        sb.append("{");
        ++indent;
        this.NewLine(sb);
        if (this.Properties != null) {
            this.Properties.ToSource(sb);
        }
        if (this.Methods != null) {
            this.Methods.ToSource(sb);
        }
        if (this.Indexers != null) {
            this.Indexers.ToSource(sb);
        }
        if (this.Events != null) {
            this.Events.ToSource(sb);
        }
        --indent;
        this.NewLine(sb);
        sb.append("}");
        this.NewLine(sb);
    }
}

