/*
 * Decompiled with CFR 0.152.
 */
package org.argouml.model.mdr;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;
import javax.jmi.model.MofClass;
import javax.jmi.reflect.InvalidObjectException;
import org.argouml.model.ExtensionMechanismsHelper;
import org.argouml.model.InvalidElementException;
import org.argouml.model.NotImplementedException;
import org.argouml.model.mdr.FacadeMDRImpl;
import org.argouml.model.mdr.MDRModelImplementation;
import org.omg.uml.foundation.core.ModelElement;
import org.omg.uml.foundation.core.Namespace;
import org.omg.uml.foundation.core.Stereotype;
import org.omg.uml.foundation.core.TagDefinition;
import org.omg.uml.foundation.core.TaggedValue;
import org.omg.uml.modelmanagement.Model;
import org.omg.uml.modelmanagement.UmlPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExtensionMechanismsHelperMDRImpl
implements ExtensionMechanismsHelper {
    private static final Logger LOG = Logger.getLogger(ExtensionMechanismsHelperMDRImpl.class.getName());
    private MDRModelImplementation modelImpl;
    private static Map<String, String> packageMap = new HashMap<String, String>(16);

    ExtensionMechanismsHelperMDRImpl(MDRModelImplementation implementation) {
        this.modelImpl = implementation;
        packageMap.put("core", "Core");
        packageMap.put("datatypes", "Data_Types");
        packageMap.put("commonbehavior", "Common_Behavior");
        packageMap.put("usecases", "Use_Cases");
        packageMap.put("statemachines", "State_Machines");
        packageMap.put("collaborations", "Collaborations");
        packageMap.put("activitygraphs", "Activity_Graphs");
        packageMap.put("modelmanagement", "Model_Management");
    }

    @Override
    public Collection<Stereotype> getStereotypes(Object ns) {
        if (!(ns instanceof Namespace)) {
            throw new IllegalArgumentException("A namespace was expected we got " + ns);
        }
        ArrayList<Stereotype> l = new ArrayList<Stereotype>();
        try {
            for (Object o : ((Namespace)ns).getOwnedElement()) {
                if (o instanceof Stereotype) {
                    l.add((Stereotype)o);
                    continue;
                }
                if (!(o instanceof UmlPackage)) continue;
                l.addAll(this.getStereotypes(o));
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return l;
    }

    @Override
    public Object getStereotype(Object ns, Object stereo) {
        if (!(ns instanceof Namespace)) {
            throw new IllegalArgumentException("namespace");
        }
        if (!(stereo instanceof Stereotype)) {
            throw new IllegalArgumentException("stereotype");
        }
        try {
            String name = ((ModelElement)stereo).getName();
            Collection baseClasses = ((Stereotype)stereo).getBaseClass();
            if (name == null || baseClasses.size() != 1) {
                return null;
            }
            String baseClass = (String)baseClasses.iterator().next();
            for (Stereotype o : this.getStereotypes(ns)) {
                if (!name.equals(o.getName()) || !o.getBaseClass().contains(baseClass)) continue;
                return o;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return null;
    }

    public Stereotype getStereotype(Collection models, Object stereo) {
        if (stereo == null) {
            throw new IllegalArgumentException("null argument");
        }
        if (!(stereo instanceof Stereotype)) {
            throw new IllegalArgumentException("stereotype");
        }
        try {
            String name = ((Stereotype)stereo).getName();
            Collection baseClasses = ((Stereotype)stereo).getBaseClass();
            if (name == null || baseClasses.size() != 1) {
                return null;
            }
            String baseClass = (String)baseClasses.iterator().next();
            for (Model model : models) {
                for (Stereotype o : this.getStereotypes(model)) {
                    if (!name.equals(o.getName()) || !o.getBaseClass().contains(baseClass)) continue;
                    return o;
                }
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return null;
    }

    @Override
    @Deprecated
    public String getMetaModelName(Object m) {
        return this.modelImpl.getMetaTypes().getName(m);
    }

    @Override
    public Collection<Stereotype> getAllPossibleStereotypes(Collection models, Object modelElement) {
        if (modelElement == null) {
            return Collections.emptySet();
        }
        ArrayList<Stereotype> ret = new ArrayList<Stereotype>();
        try {
            for (Stereotype stereo : this.getStereotypes(models)) {
                if (!this.isApplicableStereo(modelElement, stereo)) continue;
                ret.add(stereo);
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return ret;
    }

    @Override
    public Collection getCommonTaggedValueTypes() {
        return null;
    }

    private boolean isApplicableStereo(Object element, Stereotype stereo) {
        String metatypeName = this.modelImpl.getMetaTypes().getName(element);
        MofClass metatype = ((FacadeMDRImpl)this.modelImpl.getFacade()).getMofClass(metatypeName);
        Collection<String> allTypes = this.getNames(metatype.allSupertypes());
        allTypes.add(metatypeName);
        for (String base : stereo.getBaseClass()) {
            if (!allTypes.contains(base)) continue;
            return true;
        }
        return false;
    }

    private Collection<String> getNames(Collection<MofClass> elements) {
        HashSet<String> names = new HashSet<String>();
        for (MofClass element : elements) {
            names.add(element.getName());
        }
        return names;
    }

    @Override
    public boolean isValidStereotype(Object theModelElement, Object theStereotype) {
        if (theModelElement == null) {
            return false;
        }
        return this.isApplicableStereo(theModelElement, (Stereotype)theStereotype);
    }

    @Override
    public Collection<Stereotype> getStereotypes(Collection models) {
        ArrayList<Stereotype> ret = new ArrayList<Stereotype>();
        try {
            for (Object model : models) {
                if (!(model instanceof Model)) {
                    throw new IllegalArgumentException("Expected to receive a collection of Models. The collection contained a " + model.getClass().getName());
                }
                ret.addAll(this.getStereotypes(model));
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return ret;
    }

    @Override
    public void addCopyStereotype(Object modelElement, Object stereotype) {
        this.modelImpl.getCoreHelper().addStereotype(modelElement, stereotype);
    }

    @Override
    public boolean isStereotype(Object object, String name, String base) {
        if (!(object instanceof Stereotype)) {
            return false;
        }
        Stereotype st = (Stereotype)object;
        try {
            if (name == null && st.getName() != null) {
                return false;
            }
            if (base == null && !st.getBaseClass().isEmpty()) {
                return false;
            }
            return name.equals(st.getName()) && st.getBaseClass().contains(base);
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
    }

    @Override
    public boolean isStereotypeInh(Object object, String name, String base) {
        if (!(object instanceof Stereotype)) {
            return false;
        }
        try {
            if (this.isStereotype(object, name, base)) {
                return true;
            }
            Iterator it = this.modelImpl.getCoreHelper().getSupertypes(object).iterator();
            while (it.hasNext()) {
                if (!this.isStereotypeInh(it.next(), name, base)) continue;
                return true;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return false;
    }

    @Override
    public void addExtendedElement(Object handle, Object extendedElement) {
        if (handle instanceof Stereotype && extendedElement instanceof ModelElement) {
            ((ModelElement)extendedElement).getStereotype().add((Stereotype)handle);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or extendedElement: " + extendedElement);
    }

    @Override
    public void addBaseClass(Object handle, Object baseClass) {
        if (handle instanceof Stereotype) {
            if (baseClass instanceof String) {
                ((Stereotype)handle).getBaseClass().add((String)baseClass);
                return;
            }
            if (baseClass instanceof ModelElement) {
                ((Stereotype)handle).getBaseClass().add(this.modelImpl.getMetaTypes().getName(baseClass));
                return;
            }
        }
        throw new IllegalArgumentException("handle: " + handle + " or baseClass: " + baseClass);
    }

    @Override
    public void applyProfile(Object handle, Object profile) {
    }

    @Override
    public void removeBaseClass(Object handle, Object baseClass) {
        try {
            if (handle instanceof Stereotype) {
                if (baseClass instanceof String) {
                    ((Stereotype)handle).getBaseClass().remove(baseClass);
                    return;
                }
                if (baseClass instanceof ModelElement) {
                    ((Stereotype)handle).getBaseClass().remove(this.modelImpl.getMetaTypes().getName(baseClass));
                    return;
                }
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        throw new IllegalArgumentException("handle: " + handle + " or baseClass: " + baseClass);
    }

    @Override
    public void setIcon(Object handle, Object icon) {
        if (handle instanceof Stereotype && (icon == null || icon instanceof String)) {
            ((Stereotype)handle).setIcon((String)icon);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or icon: " + icon);
    }

    @Override
    public void setValueOfTag(Object handle, String value) {
        this.setDataValues(handle, new String[]{value});
    }

    @Override
    public void setDataValues(Object handle, String[] values) {
        if (handle instanceof TaggedValue) {
            TaggedValue tv = (TaggedValue)handle;
            Collection dataValues = tv.getDataValue();
            dataValues.clear();
            Collections.addAll(dataValues, values);
        }
    }

    @Override
    public void addTaggedValue(Object handle, Object taggedValue) {
        if (handle instanceof ModelElement && taggedValue instanceof TaggedValue) {
            ((ModelElement)handle).getTaggedValue().add((TaggedValue)taggedValue);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or taggedValue: " + taggedValue);
    }

    @Override
    public void removeTaggedValue(Object handle, Object taggedValue) {
        if (handle instanceof ModelElement && taggedValue instanceof TaggedValue) {
            ((ModelElement)handle).getTaggedValue().remove(taggedValue);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or taggedValue: " + taggedValue);
    }

    @Override
    public void setTaggedValue(Object handle, Collection taggedValues) {
        if (handle instanceof ModelElement) {
            Collection tv = this.modelImpl.getFacade().getTaggedValuesCollection(handle);
            if (!tv.isEmpty()) {
                ArrayList tvs = new ArrayList(tv);
                for (Object value : tvs) {
                    if (taggedValues.contains(value)) continue;
                    tv.remove(value);
                }
            }
            for (Object value : taggedValues) {
                if (tv.contains(value)) continue;
                tv.add(value);
            }
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or taggedValues: " + taggedValues);
    }

    @Override
    public void setTaggedValue(Object handle, Object property, Object value) {
        throw new NotImplementedException();
    }

    @Override
    public void setTagType(Object handle, String tagType) {
        if (handle instanceof TagDefinition) {
            ((TagDefinition)handle).setTagType(tagType);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or tagType: " + tagType);
    }

    @Override
    public void setType(Object handle, Object type) {
        if ((type == null || type instanceof TagDefinition) && handle instanceof TaggedValue) {
            ((TaggedValue)handle).setType((TagDefinition)type);
            return;
        }
        throw new IllegalArgumentException("handle: " + handle + " or type: " + type);
    }

    @Override
    public void unapplyProfile(Object handle, Object profile) {
    }

    @Override
    public boolean hasStereotype(Object handle, String name) {
        if (name == null || !(handle instanceof ModelElement)) {
            throw new IllegalArgumentException();
        }
        try {
            ModelElement element = (ModelElement)handle;
            for (Stereotype stereotype : element.getStereotype()) {
                if (!name.equals(stereotype.getName())) continue;
                return true;
            }
        }
        catch (InvalidObjectException e) {
            throw new InvalidElementException(e);
        }
        return false;
    }

    @Override
    public Object makeProfileApplicable(Object handle) {
        return handle;
    }
}

