/*  Magic Draw UML 7.2 install program for OS/2 and eComStation
 *
 *  It creates a folder on your desktop, containing an icon for
 *  Magic Draw UML 7.2.
 *
 *  jkacer@kiv.zcu.cz
 */

ProgramName = "Magic Draw UML version 7.2"
CommandFile1 = "Run_MagicDrawUML_OS2.CMD"
IconFile = "MagicDrawUML1_OS2.ICO"

/* Loading all RexxUtil functions... */
CALL RxFuncAdd "SysLoadFuncs","RexxUtil","SysLoadFuncs"
CALL SysLoadFuncs

/* Really create? */
CALL SysCls
SAY "This install program creates """ || ProgramName || """ program objects"
SAY "on your desktop.  Do you wish to proceed?  (Y/N)"
PULL Answer .
Answer = SUBSTR(Answer, 1, 1)
IF Answer <> 'Y' THEN
DO
  SAY "Exiting."
  EXIT 1
END

/* Testing that files exist... */
CurrentDirectory = DIRECTORY()

CALL SysFileTree CurrentDirectory || '\' || CommandFile1, FoundFile, 'F'
IF FoundFile.0 = 0 THEN
DO
  SAY "Cannot locate file" CommandFile1 "--> Exiting."
  EXIT 1
END

CALL SysFileTree CurrentDirectory || '\' || IconFile, FoundFile, 'F'
IF FoundFile.0 = 0 THEN
DO
  SAY "Cannot locate file" IconFile "--> Exiting."
  EXIT 1
END

/* Let's create the folder and icon... */
IF SysCreateObject("WPFolder", ProgramName, "<WP_DESKTOP>", "OBJECTID=<MagicDraw_Folder>", "replace") THEN
 SAY 'MagicDraw folder was created on desktop.'
ELSE
 SAY 'Failed to create MagicDraw folder on desktop!'

Settings1 = "PROGTYPE=WINDOWABLEVIO;NOAUTOCLOSE=NO;MINIMIZED=YES;EXENAME="CurrentDirectory"\"CommandFile1";ICONFILE="CurrentDirectory"\"IconFile";STARTUPDIR="CurrentDirectory";OBJECTID=<MagicDraw_Program>"
IF SysCreateObject("WPProgram", "Magic Draw UML 7.2", "<MagicDraw_Folder>", Settings1, "replace") THEN
 SAY 'Program object for Magic Draw UML 7.2 was created.'
else
 SAY 'Failed to create program object for Magic Draw UML 7.2!'

SAY 'Finished, exiting...'
EXIT
