/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.ast.xpath;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sourceforge.pmd.lang.ast.Node;

public class Attribute {
    private static final Object[] EMPTY_OBJ_ARRAY = new Object[0];
    private Node parent;
    private String name;
    private Method method;
    private Object value;
    private String stringValue;

    public Attribute(Node parent, String name, Method m) {
        this.parent = parent;
        this.name = name;
        this.method = m;
    }

    public Attribute(Node parent, String name, String value) {
        this.parent = parent;
        this.name = name;
        this.value = value;
        this.stringValue = value;
    }

    public Object getValue() {
        if (this.value != null) {
            return this.value;
        }
        try {
            return this.method.invoke((Object)this.parent, EMPTY_OBJ_ARRAY);
        }
        catch (IllegalAccessException iae) {
            iae.printStackTrace();
        }
        catch (InvocationTargetException ite) {
            ite.printStackTrace();
        }
        return null;
    }

    public String getStringValue() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        Object v = this.value;
        if (this.value == null) {
            v = this.getValue();
        }
        this.stringValue = v == null ? "" : String.valueOf(v);
        return this.stringValue;
    }

    public String getName() {
        return this.name;
    }

    public Node getParent() {
        return this.parent;
    }

    public String toString() {
        return this.name + ":" + this.getValue() + ":" + this.parent;
    }
}

