/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jasper;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.JspCompiler;
import org.apache.jasper.compiler.JspReader;
import org.apache.jasper.compiler.ServletWriter;
import org.apache.jasper.compiler.SunJavaCompiler;

public class JspEngineContext
implements JspCompilationContext {
    JspReader reader;
    ServletWriter writer;
    ServletContext context;
    URLClassLoader loader;
    String classpath;
    boolean isErrPage;
    String jspFile;
    String outDir;
    String servletClassName;
    String servletPackageName = "org.apache.jsp";
    String servletJavaFileName;
    String contentType;
    Options options;
    HttpServletRequest req;
    HttpServletResponse res;

    public JspEngineContext(URLClassLoader loader, String classpath, ServletContext context, String jspFile, String outDir, boolean isErrPage, Options options, HttpServletRequest req, HttpServletResponse res) {
        this.loader = loader;
        this.classpath = classpath;
        this.context = context;
        this.jspFile = jspFile;
        this.outDir = outDir;
        this.isErrPage = isErrPage;
        this.options = options;
        this.req = req;
        this.res = res;
    }

    public Compiler createCompiler() throws JasperException {
        JavaCompiler javac;
        String compilerPath = this.options.getJspCompilerPath();
        Class jspCompilerPlugin = this.options.getJspCompilerPlugin();
        if (jspCompilerPlugin != null) {
            try {
                javac = (JavaCompiler)jspCompilerPlugin.newInstance();
            }
            catch (Exception ex) {
                Constants.message((String)"jsp.warning.compiler.class.cantcreate", (Object[])new Object[]{jspCompilerPlugin, ex}, (int)Integer.MIN_VALUE);
                javac = new SunJavaCompiler();
            }
        } else {
            javac = new SunJavaCompiler();
        }
        if (compilerPath != null) {
            javac.setCompilerPath(compilerPath);
        }
        JspCompiler jspCompiler = new JspCompiler(this);
        jspCompiler.setJavaCompiler(javac);
        return jspCompiler;
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public String getClassPath() {
        URL[] urls = this.loader.getURLs();
        StringBuffer cpath = new StringBuffer();
        String sep = System.getProperty("path.separator");
        int i = 0;
        while (i < urls.length) {
            if (urls[i].getProtocol().equals("file")) {
                cpath.append(String.valueOf(urls[i].getFile()) + sep);
            }
            ++i;
        }
        return String.valueOf(cpath.toString()) + this.classpath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getJavacOutputDir() {
        return null;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public Options getOptions() {
        return this.options;
    }

    public String getOutputDir() {
        return this.outDir;
    }

    public JspReader getReader() {
        return this.reader;
    }

    public String getRealPath(String path) {
        if (this.context != null) {
            return this.context.getRealPath(path);
        }
        return path;
    }

    public HttpServletRequest getRequest() {
        return this.req;
    }

    public URL getResource(String res) throws MalformedURLException {
        return this.context.getResource(res);
    }

    public InputStream getResourceAsStream(String res) {
        return this.context.getResourceAsStream(res);
    }

    public HttpServletResponse getResponse() {
        return this.res;
    }

    public String getServletClassName() {
        return this.servletClassName;
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getServletJavaFileName() {
        return this.servletJavaFileName;
    }

    public String getServletPackageName() {
        return this.servletPackageName;
    }

    public String[] getTldLocation(String uri) throws JasperException {
        String[] location = this.options.getTldLocationsCache().getLocation(uri);
        return location;
    }

    public ServletWriter getWriter() {
        return this.writer;
    }

    public boolean isErrorPage() {
        return this.isErrPage;
    }

    public boolean keepGenerated() {
        return this.options.getKeepGenerated();
    }

    public String resolveRelativeUri(String uri) {
        if (uri.charAt(0) == '/') {
            return uri;
        }
        String actURI = this.req.getServletPath();
        String baseURI = actURI.substring(0, actURI.lastIndexOf(47));
        return String.valueOf(baseURI) + '/' + uri;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setErrorPage(boolean isErrPage) {
        this.isErrPage = isErrPage;
    }

    public void setReader(JspReader reader) {
        this.reader = reader;
    }

    public void setServletClassName(String servletClassName) {
        this.servletClassName = servletClassName;
    }

    public void setServletJavaFileName(String servletJavaFileName) {
        this.servletJavaFileName = servletJavaFileName;
    }

    public void setServletPackageName(String servletPackageName) {
        this.servletPackageName = servletPackageName;
    }

    public void setWriter(ServletWriter writer) {
        this.writer = writer;
    }
}

