/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.sample.zipextractor;

import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.sample.filechooser.FileChooserBean;
import de.netcomputing.sample.zipextractor.MainGUI;
import java.awt.Component;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Main
extends JPanel {
    JProgressBar progressBar;
    JButton exctractBtn;
    FileChooserBean destDir;
    FileChooserBean srcFile;
    int fullCount = 0;

    public Main() {
        this.initGui();
    }

    public void initGui() {
        new MainGUI().createGui(this);
        this.destDir.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                Main.this.destinationChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                Main.this.destinationChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                Main.this.destinationChanged();
            }
        });
        this.srcFile.addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                Main.this.srcChanged();
            }

            public void removeUpdate(DocumentEvent e) {
                Main.this.srcChanged();
            }

            public void changedUpdate(DocumentEvent e) {
                Main.this.srcChanged();
            }
        });
    }

    void destinationChanged() {
        this.validateState();
    }

    void validateState() {
        File src = new File(this.srcFile.getText());
        File dest = new File(this.destDir.getText());
        this.exctractBtn.setEnabled(src.exists() && !src.isDirectory() && this.destDir.getText().trim().length() > 0 && (!dest.exists() || dest.isDirectory()));
    }

    void srcChanged() {
        File src = new File(this.srcFile.getText());
        this.destDir.setText(src.getParent() + File.separator + src.getName() + ".unpacked");
        this.validateState();
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public static void main(String[] args) {
        JFrame fr = ApplicationHelper.Singleton().createFrameOn(new Main());
        fr.setDefaultCloseOperation(3);
        ((Component)fr).setVisible(true);
    }

    void extractFile(ZipFile zf, File target) throws IOException {
        this.fullCount = 0;
        this.progressBar.setString("counting entries..");
        Enumeration<? extends ZipEntry> en = zf.entries();
        while (en.hasMoreElements()) {
            ++this.fullCount;
            en.nextElement();
            if (this.fullCount % 100 != 0) continue;
            this.progressBar.setString("counting entries.." + this.fullCount);
        }
        this.progressBar.setMaximum(this.fullCount);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.progressBar.setString("unpacking");
        this.fullCount = 0;
        en = zf.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            this.copyInputStream(zf, ze, target);
        }
        this.progressBar.setString("finished");
        this.progressBar.setValue(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void copyInputStream(ZipFile zf, ZipEntry ze, File base) throws IOException {
        this.progressBar.setValue(this.fullCount++);
        String s = ze.getName();
        int i = s.lastIndexOf(47);
        if (i >= 0) {
            s = s.substring(i);
        }
        this.progressBar.setString(s);
        OutputStream out = null;
        try {
            if (!ze.getName().endsWith("/")) {
                String target = base.getAbsolutePath() + File.separator + ze.getName().replace('/', File.separatorChar);
                InputStream in = zf.getInputStream(ze);
                File tr = new File(target).getParentFile();
                boolean res = tr.mkdirs();
                out = new BufferedOutputStream(new FileOutputStream(target), 500000);
                int c = 0;
                boolean count = false;
                while ((c = in.read()) >= 0) {
                    out.write(c);
                }
            }
            Object var14_13 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    public void exctractBtn_actionPerformed(ActionEvent var0) {
        new Thread(){

            public void run() {
                try {
                    try {
                        Main.this.exctractBtn.setEnabled(false);
                        Main.this.destDir.setEnabled(false);
                        Main.this.srcFile.setEnabled(false);
                        File out = new File(Main.this.destDir.getText().trim());
                        out.mkdirs();
                        ZipFile zf = new ZipFile(Main.this.srcFile.getText().trim());
                        if (!out.exists()) {
                            throw new RuntimeException("failed to create directory:" + Main.this.destDir.getText());
                        }
                        Main.this.extractFile(zf, out);
                        zf.close();
                    }
                    catch (Throwable ex) {
                        JOptionPane.showMessageDialog(Main.this, ex.getMessage());
                        ex.printStackTrace();
                        Object var4_5 = null;
                        Main.this.exctractBtn.setEnabled(true);
                        Main.this.destDir.setEnabled(true);
                        Main.this.srcFile.setEnabled(true);
                    }
                    Object var4_4 = null;
                    Main.this.exctractBtn.setEnabled(true);
                    Main.this.destDir.setEnabled(true);
                    Main.this.srcFile.setEnabled(true);
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    Main.this.exctractBtn.setEnabled(true);
                    Main.this.destDir.setEnabled(true);
                    Main.this.srcFile.setEnabled(true);
                    throw throwable;
                }
            }
        }.start();
    }
}

