/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ajp;

import java.io.IOException;
import java.security.MessageDigest;
import org.apache.ajp.Ajp13;
import org.apache.ajp.Ajp13Packet;
import org.apache.ajp.AjpHandler;
import org.apache.tomcat.util.buf.HexUtils;
import org.apache.tomcat.util.http.BaseRequest;

public class NegociationHandler
extends AjpHandler {
    public static final byte JK_AJP13_SHUTDOWN = 7;
    public static final byte JK_AJP14_LOGINIT_CMD = 16;
    public static final byte JK_AJP14_LOGSEED_CMD = 17;
    public static final byte JK_AJP14_LOGCOMP_CMD = 18;
    public static final byte JK_AJP14_LOGOK_CMD = 19;
    public static final byte JK_AJP14_LOGNOK_CMD = 20;
    public static final byte JK_AJP14_CONTEXT_QRY_CMD = 21;
    public static final byte JK_AJP14_CONTEXT_INFO_CMD = 22;
    public static final byte JK_AJP14_CONTEXT_UPDATE_CMD = 23;
    public static final byte JK_AJP14_STATUS_CMD = 24;
    public static final byte JK_AJP14_SHUTDOWN_CMD = 25;
    public static final byte JK_AJP14_SHUTOK_CMD = 26;
    public static final byte JK_AJP14_SHUTNOK_CMD = 27;
    public static final byte JK_AJP14_CONTEXT_STATE_CMD = 28;
    public static final byte JK_AJP14_CONTEXT_STATE_REP_CMD = 29;
    public static final byte JK_AJP14_UNKNOW_PACKET_CMD = 30;
    public static final int AJP14_ENTROPY_SEED_LEN = 32;
    public static final int AJP14_COMPUTED_KEY_LEN = 32;
    public static final int AJP14_CONTEXT_INFO_NEG = Integer.MIN_VALUE;
    public static final int AJP14_CONTEXT_UPDATE_NEG = 0x40000000;
    public static final int AJP14_GZIP_STREAM_NEG = 0x20000000;
    public static final int AJP14_DES56_STREAM_NEG = 0x10000000;
    public static final int AJP14_SSL_VSERVER_NEG = 0x8000000;
    public static final int AJP14_SSL_VCLIENT_NEG = 0x4000000;
    public static final int AJP14_SSL_VCRYPTO_NEG = 0x2000000;
    public static final int AJP14_SSL_VMISC_NEG = 0x1000000;
    public static final int AJP14_PROTO_SUPPORT_AJPXX_NEG = 0xFF0000;
    public static final int AJP14_PROTO_SUPPORT_AJP14_NEG = 65536;
    public static final int AJP14_PROTO_SUPPORT_AJP15_NEG = 131072;
    public static final int AJP14_PROTO_SUPPORT_AJP16_NEG = 262144;
    public static final int AJP14_BAD_KEY_ERR = -1;
    public static final int AJP14_ENGINE_DOWN_ERR = -2;
    public static final int AJP14_RETRY_LATER_ERR = -3;
    public static final int AJP14_SHUT_AUTHOR_FAILED_ERR = -4;
    public static final byte AJP14_CONTEXT_DOWN = 1;
    public static final byte AJP14_CONTEXT_UP = 2;
    public static final byte AJP14_CONTEXT_OK = 3;
    String containerSignature = "Ajp14-based container";
    String seed = "seed";
    String password;
    int webserverNegociation = 0;
    private static int debug = 10;

    public NegociationHandler() {
        this.setSeed("myveryrandomentropy");
        this.setPassword("myverysecretkey");
    }

    private String decodeNegociation(int nego) {
        StringBuffer buf = new StringBuffer(128);
        if ((nego & Integer.MIN_VALUE) != 0) {
            buf.append(" CONTEXT-INFO");
        }
        if ((nego & 0x40000000) != 0) {
            buf.append(" CONTEXT-UPDATE");
        }
        if ((nego & 0x20000000) != 0) {
            buf.append(" GZIP-STREAM");
        }
        if ((nego & 0x10000000) != 0) {
            buf.append(" DES56-STREAM");
        }
        if ((nego & 0x8000000) != 0) {
            buf.append(" SSL-VSERVER");
        }
        if ((nego & 0x4000000) != 0) {
            buf.append(" SSL-VCLIENT");
        }
        if ((nego & 0x2000000) != 0) {
            buf.append(" SSL-VCRYPTO");
        }
        if ((nego & 0x1000000) != 0) {
            buf.append(" SSL-VMISC");
        }
        if ((nego & 0x10000) != 0) {
            buf.append(" AJP14");
        }
        if ((nego & 0x20000) != 0) {
            buf.append(" AJP15");
        }
        if ((nego & 0x40000) != 0) {
            buf.append(" AJP16");
        }
        return buf.toString();
    }

    public final String digest(String[] credentials, String algorithm) {
        try {
            MessageDigest md = (MessageDigest)MessageDigest.getInstance(algorithm).clone();
            int i = 0;
            while (i < credentials.length) {
                if (debug > 0) {
                    this.log("Credentials : " + i + " " + credentials[i]);
                }
                if (credentials[i] != null) {
                    md.update(credentials[i].getBytes());
                }
                ++i;
            }
            byte[] dig = md.digest();
            return HexUtils.convert((byte[])dig);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public String getPassword() {
        return this.password;
    }

    private int getProtocolFlags(int wanted) {
        return (wanted &= 0x8000FFFF) | 0x10000;
    }

    public String getSeed() {
        return this.seed;
    }

    public int handleAjpMessage(int type, Ajp13 ch, Ajp13Packet hBuf, BaseRequest req) throws IOException {
        System.out.println("handleAjpMessage: " + type);
        Ajp13Packet outBuf = ch.outBuf;
        switch (type) {
            case 16: {
                return this.handleLogInit(ch, hBuf, outBuf);
            }
            case 18: {
                return this.handleLogComp(ch, hBuf, outBuf);
            }
            case 7: {
                return -2;
            }
            case 21: {
                return this.handleContextQuery(ch, hBuf, outBuf);
            }
            case 24: {
                return this.handleStatus(hBuf, outBuf);
            }
            case 25: {
                return this.handleShutdown(hBuf, outBuf);
            }
            case 28: {
                return this.handleContextState(hBuf, outBuf);
            }
            case 30: {
                return this.handleUnknowPacket(hBuf, outBuf);
            }
        }
        this.log("unknown command " + type + " received");
        return 200;
    }

    private int handleContextQuery(Ajp13 ch, Ajp13Packet msg, Ajp13Packet outBuf) throws IOException {
        this.log("in handleContextQuery :");
        String virtualHost = msg.getString();
        this.log("in handleContextQuery for virtual" + virtualHost);
        outBuf.reset();
        outBuf.appendByte((byte)22);
        outBuf.appendString(virtualHost);
        this.log("in handleContextQuery for virtual " + virtualHost + "examples URI/MIMES");
        outBuf.appendString("examples");
        outBuf.appendString("servlet/*");
        outBuf.appendString("*.jsp");
        outBuf.appendString("");
        this.log("in handleContextQuery for virtual " + virtualHost + "send admin URI/MIMES");
        outBuf.appendString("admin");
        outBuf.appendString("servlet/*");
        outBuf.appendString("*.jsp");
        outBuf.appendString("");
        outBuf.appendString("");
        outBuf.end();
        ch.send(outBuf);
        return 304;
    }

    private int handleContextState(Ajp13Packet msg, Ajp13Packet outBuf) throws IOException {
        this.log("in handleContextState :");
        return 304;
    }

    private int handleLogComp(Ajp13 ch, Ajp13Packet msg, Ajp13Packet outBuf) throws IOException {
        String received;
        byte[] rdigest = new byte[32];
        if (msg.getXBytes(rdigest, 32) < 0) {
            return 200;
        }
        String[] credentials = new String[]{this.getSeed(), this.getPassword()};
        String computed = this.digest(credentials, "md5");
        if (!computed.equalsIgnoreCase(received = new String(rdigest))) {
            this.log("in handleLogComp : authentification failure received=" + received + " awaited=" + computed);
        }
        this.channel.setLogged(true);
        outBuf.reset();
        outBuf.appendByte((byte)19);
        outBuf.appendLongInt(this.getProtocolFlags(this.webserverNegociation));
        outBuf.appendString(this.containerSignature);
        outBuf.end();
        ch.send(outBuf);
        return 304;
    }

    private int handleLogInit(Ajp13 ch, Ajp13Packet msg, Ajp13Packet outBuf) throws IOException {
        this.webserverNegociation = msg.getLongInt();
        String webserverName = msg.getString();
        this.log("in handleLogInit with nego " + this.decodeNegociation(this.webserverNegociation) + " from webserver " + webserverName);
        outBuf.reset();
        outBuf.appendByte((byte)17);
        String[] credentials = new String[]{this.getSeed()};
        outBuf.appendXBytes(this.getSeed().getBytes(), 0, 32);
        this.log("in handleLogInit: sent entropy " + this.getSeed());
        outBuf.end();
        ch.send(outBuf);
        return 304;
    }

    private int handleShutdown(Ajp13Packet msg, Ajp13Packet outBuf) throws IOException {
        this.log("in handleShutdown :");
        return 304;
    }

    private int handleStatus(Ajp13Packet msg, Ajp13Packet outBuf) throws IOException {
        this.log("in handleStatus :");
        return 304;
    }

    private int handleUnknowPacket(Ajp13Packet msg, Ajp13Packet outBuf) throws IOException {
        this.log("in handleUnknowPacket :");
        return 304;
    }

    public void init(Ajp13 ajp14) {
        super.init(ajp14);
        ajp14.registerMessageType(16, "JK_AJP14_LOGINIT_CMD", this, null);
        ajp14.registerMessageType(18, "JK_AJP14_LOGCOMP_CMD", this, null);
        ajp14.registerMessageType(7, "JK_AJP13_SHUTDOWN", this, null);
        ajp14.registerMessageType(21, "JK_AJP14_CONTEXT_QRY_CMD", this, null);
        ajp14.registerMessageType(24, "JK_AJP14_STATUS_CMD", this, null);
        ajp14.registerMessageType(25, "JK_AJP14_SHUTDOWN_CMD", this, null);
        ajp14.registerMessageType(28, "JK_AJP14_CONTEXT_STATE_CMD", this, null);
        ajp14.registerMessageType(30, "JK_AJP14_UNKNOW_PACKET_CMD", this, null);
        ajp14.registerMessageType(20, "JK_AJP14_LOGNOK_CMD", this, null);
    }

    void log(String s) {
        System.out.println("Ajp14Negotiation: " + s);
    }

    public void setContainerSignature(String s) {
        this.containerSignature = s;
    }

    public void setPassword(String ppwd) {
        this.password = ppwd;
    }

    public void setSeed(String pseed) {
        String[] credentials = new String[]{pseed};
        this.seed = this.digest(credentials, "md5");
    }
}

