/*
 * Decompiled with CFR 0.152.
 */
package JCollections;

import JCollections.JIterationFunc;
import de.netcomputing.util.NCFileUtilities;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashSet;
import java.util.Vector;

public class DirIterator {
    public static Vector DirContent(File dir, String ending) {
        return DirIterator.DirContent(dir, ending, true);
    }

    public static HashSet DirContent(String pathOfDirs, String ending) {
        HashSet result = new HashSet(1000);
        Vector v = NCFileUtilities.GetPathAsVector(pathOfDirs);
        int i = 0;
        while (i < v.size()) {
            result.addAll(DirIterator.DirContent(new File(v.get(i).toString()), ending, true));
            ++i;
        }
        return result;
    }

    public static Vector DirContent(File dir, final String ending, boolean recursive) {
        final Vector result = new Vector(50);
        DirIterator.Iterate(dir, new JIterationFunc(){

            public boolean func(Object o) {
                if ("none".equals(ending)) {
                    if (((File)o).isDirectory()) {
                        result.addElement(o);
                    }
                } else if (((File)o).getAbsolutePath().endsWith(ending)) {
                    result.addElement(o);
                }
                return false;
            }
        }, recursive, new FilenameFilter(){

            public boolean accept(File dir1, String name) {
                return true;
            }
        }, true);
        return result;
    }

    public static boolean Iterate(File f, JIterationFunc jf, boolean recurse, FilenameFilter filter) {
        return DirIterator.Iterate(f, jf, recurse, filter, false);
    }

    public static boolean Iterate(File f, JIterationFunc jf, boolean recurse, FilenameFilter filter, boolean callOnDirs) {
        File[] files;
        boolean result = false;
        if (f == null) {
            return result;
        }
        if (f.isDirectory()) {
            boolean descent = true;
            if (callOnDirs) {
                jf.func(f);
            }
            String[] sfil = f.list(filter);
            files = new File[sfil.length];
            int fn = 0;
            while (fn < sfil.length) {
                files[fn] = new File(f, sfil[fn]);
                ++fn;
            }
        } else {
            files = new File[]{f};
        }
        int fn = 0;
        while (fn < files.length && !result) {
            if (files[fn] != null && files[fn].isDirectory()) {
                if (recurse && !result && DirIterator.Iterate(files[fn], jf, recurse, filter, callOnDirs)) {
                    result = true;
                    break;
                }
            } else {
                if (jf.func(files[fn])) {
                    result = true;
                    break;
                }
                result = false;
            }
            ++fn;
        }
        return result;
    }
}

