/*
 * Decompiled with CFR 0.152.
 */
package Jack;

import Jack.Acceptor;
import Jack.AcceptorNode;
import Jack.JackFactory;
import Jack.RLRule;
import Jack.RuleSet;
import de.netcomputing.util.Tracer;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

class RLGrammar {
    Vector rules = new Vector();
    Hashtable ruleIndex = new Hashtable();
    Vector nodes = new Vector();
    Hashtable nodeIndex = new Hashtable();
    Hashtable ignoredNodes = new Hashtable();
    Hashtable pushbackNodes = new Hashtable();
    char idChar = '\u0001';

    RLGrammar() {
    }

    public void addOredRules(String[] rule) {
        String symbol = rule[0];
        boolean _isTop = true;
        if (symbol.charAt(0) == '%') {
            symbol = symbol.substring(1);
            _isTop = false;
        } else if (symbol.charAt(0) == '#') {
            symbol = symbol.substring(1);
            this.ignoredNodes.put(symbol, Boolean.TRUE);
        }
        int pb = 0;
        while (symbol.charAt(0) == '<') {
            symbol = symbol.substring(1);
            ++pb;
        }
        if (pb > 0) {
            this.setPushback(symbol, pb);
        }
        int n = 1;
        while (n < rule.length) {
            String term = rule[n];
            if (term.length() > 1 && term.substring(0, 2).equals("|.")) {
                term = term.substring(2);
                this.addOrRule(symbol, term, rule[n + 1], _isTop);
            } else {
                this.addRule(symbol, term, rule[n + 1], _isTop);
            }
            n += 2;
        }
    }

    public void addOrRule(String symbol, String terminals, String furtherSymbol, boolean _isTop) {
        int n = 0;
        while (n < terminals.length()) {
            this.addRule(symbol, terminals.charAt(n), furtherSymbol, _isTop);
            ++n;
        }
    }

    public void addRule(String symbol, String terminals, String furtherSymbol, boolean _isTop) {
        if (terminals.length() == 1) {
            this.addRule(new RLRule(symbol, terminals.charAt(0), furtherSymbol, _isTop));
            return;
        }
        this.addRule(new RLRule(symbol, terminals.charAt(0), this.idChar + '\u0001' + 95 + symbol, _isTop));
        this.idChar = (char)(this.idChar + '\u0001');
        int n = 1;
        while (n < terminals.length() - 1) {
            this.addRule(new RLRule(this.idChar + 95 + symbol, terminals.charAt(n), this.idChar + '\u0001' + 95 + symbol, false));
            this.idChar = (char)(this.idChar + '\u0001');
            ++n;
        }
        this.addRule(new RLRule(this.idChar + 95 + symbol, terminals.charAt(n), furtherSymbol, false));
    }

    public void addRule(String symbol, char c, String furtherSymbol, boolean _isTop) {
        this.addRule(new RLRule(symbol, c, furtherSymbol, _isTop));
    }

    public void addRule(String symbol, String terminals) {
        this.addRule(symbol, terminals, null, true);
    }

    void addRule(RLRule r) {
        r.checkInverse();
        this.rules.addElement(r);
    }

    void ignore(String symbol) {
        this.ignoredNodes.put(symbol, new Boolean(true));
    }

    void setPushback(String symbol, int i) {
        this.pushbackNodes.put(symbol, new Integer(i));
    }

    Character[] getAllTerminals() {
        Hashtable<Character, Character> v = new Hashtable<Character, Character>();
        int n = 0;
        while (n < this.rules.size()) {
            RLRule r = (RLRule)this.rules.elementAt(n);
            v.put(r.terminal, r.terminal);
            ++n;
        }
        Character[] result = new Character[v.size()];
        Enumeration en = v.keys();
        int resIdx = 0;
        while (en.hasMoreElements()) {
            result[resIdx++] = (Character)en.nextElement();
        }
        return result;
    }

    RuleSet buildStartSymbols() {
        RuleSet rs = new RuleSet();
        int n = 0;
        while (n < this.rules.size()) {
            if (((RLRule)this.rules.elementAt((int)n)).isTop) {
                rs.addRule((RLRule)this.rules.elementAt(n));
            }
            ++n;
        }
        return rs;
    }

    void buildRuleIndex() {
        int n = 0;
        while (n < this.rules.size()) {
            RLRule rl = (RLRule)this.rules.elementAt(n);
            String sid = rl.name + "+" + rl.terminal;
            if (this.ruleIndex.get(sid) == null) {
                this.ruleIndex.put(sid, new Vector(3));
            }
            ((Vector)this.ruleIndex.get(sid)).addElement(rl);
            ++n;
        }
    }

    public Acceptor buildAcceptor() {
        Hashtable<Point, RuleSet> transitionMatrix = new Hashtable<Point, RuleSet>();
        Character[] terminals = this.getAllTerminals();
        this.addRuleSetIfNotContained(this.buildStartSymbols());
        Point p = new Point(0, 0);
        this.buildRuleIndex();
        int nodeIdx = 0;
        while (nodeIdx < this.nodes.size()) {
            RuleSet currentSet = (RuleSet)this.nodes.elementAt(nodeIdx);
            Enumeration currentRules = currentSet.elements();
            while (currentRules.hasMoreElements()) {
                RLRule currentRule = (RLRule)currentRules.nextElement();
                int n = 0;
                while (n < terminals.length) {
                    Vector matchingRules;
                    p.x = n;
                    p.y = nodeIdx;
                    RuleSet currentMatrixField = (RuleSet)transitionMatrix.get(p);
                    if (currentMatrixField == null) {
                        currentMatrixField = new RuleSet();
                        transitionMatrix.put(new Point(n, nodeIdx), currentMatrixField);
                    }
                    if ((matchingRules = (Vector)this.ruleIndex.get(currentRule.name + "+" + terminals[n])) != null) {
                        int ruleIdx = 0;
                        while (ruleIdx < matchingRules.size()) {
                            RLRule rlrule = (RLRule)matchingRules.elementAt(ruleIdx);
                            if (rlrule.linkSymbol == null) {
                                currentMatrixField.isAccepting(currentRule.derivedFrom);
                                currentMatrixField.isInversing(rlrule.inverse);
                            } else {
                                currentMatrixField.addRule(new RLRule(rlrule.linkSymbol, null, null, false, currentRule.derivedFrom));
                            }
                            ++ruleIdx;
                        }
                    }
                    ++n;
                }
            }
            int cols = 0;
            while (cols < terminals.length) {
                p.x = cols;
                p.y = nodeIdx;
                RuleSet rset = (RuleSet)transitionMatrix.get(p);
                if (rset != null) {
                    this.addRuleSetIfNotContained(rset);
                }
                ++cols;
            }
            ++nodeIdx;
        }
        Hashtable<String, Integer> nodeIds = new Hashtable<String, Integer>(this.nodes.size() * 2);
        Hashtable<Integer, AcceptorNode> acceptorNodes = new Hashtable<Integer, AcceptorNode>(this.nodes.size() * 2);
        int nodeIdx2 = 0;
        while (nodeIdx2 < this.nodes.size()) {
            Integer id = new Integer(nodeIdx2);
            RuleSet rs = (RuleSet)this.nodes.elementAt(nodeIdx2);
            nodeIds.put(rs.stringId(), id);
            acceptorNodes.put(id, JackFactory.CreateAcceptorNode(id, rs.accepts, rs.inverse));
            ++nodeIdx2;
        }
        int numberOfTransitions = 0;
        int nodeIdx3 = 0;
        while (nodeIdx3 < this.nodes.size()) {
            Integer sourceId = new Integer(nodeIdx3);
            int cols = 0;
            while (cols < terminals.length) {
                p.x = cols;
                p.y = nodeIdx3;
                RuleSet rs = (RuleSet)transitionMatrix.get(p);
                if (rs != null && (rs.size() != 0 || rs.accepts != null)) {
                    Integer targetId = (Integer)nodeIds.get(rs.stringId());
                    ((AcceptorNode)acceptorNodes.get(sourceId)).addSymbolicTransition(terminals[cols].charValue(), targetId);
                    ++numberOfTransitions;
                }
                ++cols;
            }
            ++nodeIdx3;
        }
        int nodeIdx4 = 0;
        while (nodeIdx4 < this.nodes.size()) {
            Integer id = new Integer(nodeIdx4);
            AcceptorNode an = (AcceptorNode)acceptorNodes.get(id);
            an.resolveSymbolicTransitionIn(acceptorNodes);
            if (an.symbolName != null && this.ignoredNodes.containsKey(an.symbolName)) {
                an.ignored = true;
            }
            if (an.symbolName != null && this.pushbackNodes.containsKey(an.symbolName)) {
                an.pushback = (Integer)this.pushbackNodes.get(an.symbolName);
            }
            ++nodeIdx4;
        }
        Tracer.This.println("** Acceptor created, " + acceptorNodes.size() + " nodes, " + terminals.length + " terminals and " + numberOfTransitions + " transitions **");
        return new Acceptor(acceptorNodes);
    }

    void addRuleSetIfNotContained(RuleSet rSet) {
        if (this.nodeIndex.get(rSet.stringId()) != null) {
            return;
        }
        this.nodeIndex.put(rSet.stringId(), rSet);
        this.nodes.addElement(rSet);
    }
}

