/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import java.util.Arrays;

public abstract class AbstractDiffer {
    int remSt = 0;
    int addSt = 0;
    int remChanges = 0;
    int addChanges = 0;
    int equals = 0;
    protected int maxDiffDepth = 8;
    protected int continWeight = 1;
    protected int[] addPosMap;

    public int getRemChanges() {
        return this.remChanges;
    }

    public int getEquals() {
        return this.equals;
    }

    public int getAddChanges() {
        return this.addChanges;
    }

    public int[] rangeDiff() {
        this.setAddChange(0, this.getAddLen());
        this.setRemChange(0, this.getRemLen());
        this.addPosMap = new int[this.getAddLen()];
        Arrays.fill(this.addPosMap, -2);
        this.rangeDiff(this.addPosMap, 0, this.getAddLen(), 0, this.getRemLen());
        int i = 0;
        while (i < this.addPosMap.length) {
            if (this.addPosMap[i] < 0) {
                int start = i;
                while (i < this.addPosMap.length && this.addPosMap[i] < 0) {
                    ++i;
                }
                int remStart = start > 0 ? this.addPosMap[start - 1] + 1 : 0;
                int remEnd = i < this.addPosMap.length - 1 ? this.addPosMap[i] : this.getRemLen();
                int ii = start;
                while (ii < i && ii - start + remStart < remEnd) {
                    if (this.isEqual(ii, ii - start + remStart)) {
                        this.setEqualChange(ii, ii - start + remStart);
                    }
                    ++ii;
                }
            }
            ++i;
        }
        return this.addPosMap;
    }

    protected void rangeDiff(int[] addPosMap, int startIdx, int endIdx, int remStart, int remEnd) {
        if (remEnd <= remStart || endIdx <= startIdx) {
            return;
        }
        if (remEnd - remStart == 1 && endIdx - startIdx == 1) {
            if (this.isEqual(startIdx, remStart)) {
                this.setEqualChange(startIdx, remStart);
            }
            return;
        }
        this.computeAddPositionMap(addPosMap, startIdx, endIdx, remStart, remEnd);
        int lastAddStart = startIdx;
        int lastRemStart = remStart;
        boolean foundUnique = false;
        int i = startIdx;
        while (i < endIdx) {
            if (addPosMap[i] >= 0) {
                if (addPosMap[i] > lastRemStart) {
                    this.rangeDiff(addPosMap, lastAddStart, i, lastRemStart, addPosMap[i]);
                }
                lastRemStart = addPosMap[i];
                lastAddStart = i;
                this.setEqualChange(i, addPosMap[i]);
                foundUnique = true;
            }
            ++i;
        }
    }

    protected void computeAddPositionMap(int[] res, int addStart, int addEnd, int remStart, int remEnd) {
        int i = addStart;
        while (i < addEnd) {
            if (this.isAddUnique(i, addStart, addEnd, remStart, remEnd)) {
                int idx = this.findRemIdx(i, remStart, remEnd);
                if (idx >= 0) {
                    res[i] = idx;
                }
            } else {
                res[i] = -1;
            }
            ++i;
        }
    }

    protected abstract boolean isAddUnique(int var1, int var2, int var3, int var4, int var5);

    protected abstract int findRemIdx(int var1, int var2, int var3);

    protected abstract int getAddLen();

    protected abstract int getRemLen();

    protected abstract boolean isWhiteSpaceAdd(int var1);

    protected abstract boolean isWhiteSpaceRem(int var1);

    protected abstract boolean isEqual(int var1, int var2);

    protected abstract void setRemChange(int var1, int var2);

    protected abstract void setAddChange(int var1, int var2);

    protected void setEqualChange(int addLine, int remLine) {
    }

    int diffTop(int addSt, int remSt, int currCount, int depth, int weight) {
        int res1;
        int res0;
        if (this.checkEnd(addSt, remSt)) {
            return 3;
        }
        int res3 = 10000;
        if (this.isEqual(addSt, remSt)) {
            res3 = this.diffRec(addSt + 1, remSt + 1, currCount, depth + 1, res3);
        }
        if ((res0 = this.diffRec(addSt + 1, remSt, currCount + 1, depth + 1, res3)) < (res1 = this.diffRec(addSt, remSt + 1, currCount + 1, depth + 1, res0))) {
            return res3 <= res0 ? 2 : 0;
        }
        if (res0 > res1) {
            return res3 <= res1 ? 2 : 1;
        }
        if (res0 + weight < res1 - weight) {
            return res3 <= res0 ? 2 : 0;
        }
        return res3 <= res1 ? 2 : 1;
    }

    int diffRec(int addSt, int remSt, int currCount, int depth, int otherTree) {
        if (currCount - otherTree > 4) {
            return 9999;
        }
        if (depth > this.maxDiffDepth) {
            return currCount;
        }
        if (this.checkEnd(addSt, remSt)) {
            return currCount + (this.getAddLen() - addSt) + (this.getRemLen() - remSt);
        }
        int res3 = 10000;
        if (this.isEqual(addSt, remSt)) {
            res3 = this.diffRec(addSt + 1, remSt + 1, currCount, depth + 1, res3);
        }
        int res0 = this.diffRec(addSt + 1, remSt, currCount + 1, depth + 1, res3);
        int res1 = this.diffRec(addSt, remSt + 1, currCount + 1, depth + 1, res0);
        return Math.min(res3, Math.min(res0, res1));
    }

    boolean checkEnd(int addSt, int remSt) {
        if (remSt >= this.getRemLen()) {
            return true;
        }
        return addSt >= this.getAddLen();
    }

    void doDiff() {
        this.doDiff(0, 999999, 0, 999999);
    }

    public void doDiff(int addStart, int addEnd, int remStart, int remEnd) {
        int i;
        int res = 0;
        this.addSt = addStart;
        this.remSt = remStart;
        boolean end = false;
        int weight = 0;
        do {
            res = this.diffTop(this.addSt, this.remSt, 0, 0, weight);
            switch (res) {
                case 0: {
                    if (!this.isWhiteSpaceAdd(this.addSt)) {
                        weight = -this.continWeight;
                        this.setAddChange(this.addSt, this.addSt + 1);
                        ++this.addChanges;
                    } else {
                        weight = 0;
                    }
                    ++this.addSt;
                    break;
                }
                case 1: {
                    if (!this.isWhiteSpaceRem(this.remSt)) {
                        weight = this.continWeight;
                        this.setRemChange(this.remSt, this.remSt + 1);
                        ++this.remChanges;
                    } else {
                        weight = 0;
                    }
                    ++this.remSt;
                    break;
                }
                case 2: {
                    do {
                        this.setEqualChange(this.addSt, this.remSt);
                        ++this.remSt;
                        ++this.addSt;
                        ++this.equals;
                    } while (this.addSt < addEnd && this.remSt < remEnd && !this.checkEnd(this.addSt, this.remSt) && this.isEqual(this.addSt, this.remSt));
                    weight = 0;
                    break;
                }
                case 3: {
                    end = true;
                }
            }
        } while (!end && this.addSt < addEnd && this.remSt < remEnd);
        if (this.addSt < this.getAddLen()) {
            i = this.addSt;
            while (i < this.getAddLen()) {
                if (!this.isWhiteSpaceAdd(i)) {
                    this.setAddChange(i, i + 1);
                    ++this.addChanges;
                }
                ++i;
            }
        }
        if (this.remSt < this.getRemLen()) {
            i = this.remSt;
            while (i < this.getRemLen()) {
                if (!this.isWhiteSpaceRem(i)) {
                    this.setRemChange(i, i + 1);
                    ++this.remChanges;
                }
                ++i;
            }
        }
    }
}

