/*
 * Decompiled with CFR 0.152.
 */
package Jxe;

import Jxe.CharAttr;
import Jxe.CollapsedTextLine;
import Jxe.GeneralDiff;
import Jxe.JXEOptions;
import Jxe.TextDocument;
import de.netcomputing.anyj.debugger.DebuggerMainPanel;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.io.PrintStream;

public class AttributedTextLine {
    public static Color selectiontext = JWColor.For("selection.fg");
    public static Color selectionbg = JWColor.For("selection.bg");
    char marker = '\u0000';
    byte[] text;
    byte[] style;
    public short histate = 0;
    public short kldepth = 0;
    public Object mark;
    public static int StyleCount = 13;
    static char[] buffer = new char[32768];
    static byte[] styleBuff = new byte[32768];

    public static CharAttr[] createDefaultStyles(String fam, int size, Color fg, Color bg) {
        CharAttr[] ht = new CharAttr[StyleCount];
        ht[0] = new CharAttr(new Font(fam, 0, size), new Color(0, 0, 0), bg);
        ht[1] = new CharAttr(new Font(fam, 0, size), fg, bg);
        ht[2] = new CharAttr(new Font(fam, 0, size), new Color(0, 0, 100), bg);
        ht[3] = new CharAttr(new Font(fam, 0, size), new Color(200, 0, 0), bg);
        ht[4] = new CharAttr(new Font(fam, 0, size), new Color(0, 0, 100), bg);
        ht[5] = new CharAttr(new Font(fam, 0, size), Color.darkGray, bg);
        ht[6] = new CharAttr(new Font(fam, 0, size), new Color(100, 0, 0), bg);
        ht[7] = new CharAttr(new Font(fam, 0, size), new Color(0, 100, 0), bg);
        ht[8] = new CharAttr(new Font(fam, 0, size), new Color(200, 0, 0), bg);
        ht[9] = new CharAttr(new Font(fam, 0, size), Color.darkGray, bg);
        ht[10] = new CharAttr(new Font(fam, 0, size), new Color(100, 0, 0), bg);
        ht[11] = new CharAttr(new Font(fam, 0, size), new Color(0, 0, 0), bg);
        ht[12] = new CharAttr(new Font(fam, 0, size), bg.darker(), bg);
        return ht;
    }

    public AttributedTextLine() {
        this.text = new byte[0];
        this.style = new byte[0];
    }

    public AttributedTextLine(byte[] b, int offset, int length) {
        this.text = new byte[length];
        System.arraycopy(b, offset, this.text, 0, length);
        this.style = new byte[this.text.length];
    }

    public AttributedTextLine(StringBuffer s) {
        this.text = new byte[s.length()];
        int n = 0;
        while (n < this.text.length) {
            this.text[n] = (byte)s.charAt(n);
            ++n;
        }
        this.style = new byte[this.text.length];
        this.setStyle(0);
    }

    public AttributedTextLine(String s) {
        this.text = new byte[s.length()];
        int n = 0;
        while (n < this.text.length) {
            this.text[n] = (byte)s.charAt(n);
            ++n;
        }
        this.style = new byte[this.text.length];
        this.setStyle(0);
    }

    public byte[] getText() {
        return this.text;
    }

    public void mark(char c) {
        this.marker = c;
    }

    public char getMark() {
        return this.marker;
    }

    public String toString() {
        return new String(this.text);
    }

    public int translateX(int x) {
        int buffn = 0;
        int textn = 0;
        while (textn < Math.min(this.text.length, x)) {
            if (this.text[textn] == 9) {
                buffn += JXEOptions.TAB - buffn % JXEOptions.TAB;
                ++textn;
                continue;
            }
            ++buffn;
            ++textn;
        }
        return x + buffn - textn;
    }

    public int screenSize() {
        int buffn = 0;
        int textn = 0;
        while (textn < this.size()) {
            if (this.text[textn] == 9) {
                buffn += JXEOptions.TAB - buffn % JXEOptions.TAB;
                ++textn;
                continue;
            }
            ++buffn;
            ++textn;
        }
        return buffn;
    }

    public int untranslateX(int x) {
        return this.untranslateX(x, JXEOptions.TAB);
    }

    public int untranslateX(int x, int tabSize) {
        int buffn = 0;
        int textn = 0;
        while (textn < this.text.length && buffn < x) {
            if (this.text[textn] == 9) {
                buffn += tabSize - buffn % tabSize;
                ++textn;
                continue;
            }
            ++buffn;
            ++textn;
        }
        if (buffn >= x) {
            return textn;
        }
        return x - (buffn - textn);
    }

    private void clearBG(Graphics g, int x, int y, int w, int h, TextDocument doc, int lineNo) {
        char tmpMark = this.marker;
        int tmp = 0;
        if (DebuggerMainPanel.This() != null && doc.getFile() != null) {
            tmp = DebuggerMainPanel.This().getEditorMark(lineNo, doc.getFile().getAbsolutePath());
        }
        if (tmp != 0) {
            g.setColor(new Color(255, 0, 0, 48));
        } else if (DebuggerMainPanel.This() != null && DebuggerMainPanel.This().getState() != 6 && doc.cY() == lineNo && !doc.cursorHidden && !doc.hasSelection()) {
            g.setColor(JXEOptions.EditorLineBG);
        } else if (tmpMark == '\u0002') {
            g.setColor(JXEOptions.EditorBGDiff);
        } else if (tmpMark == '\u0001') {
            g.setColor(JXEOptions.EditorBGDiffDel);
        } else {
            g.setColor(JXEOptions.EditorBG);
        }
        if (tmpMark == '\u0000' || tmpMark > '\u0002') {
            g.fillRect(x, y, w, h);
        } else {
            g.fillRect(0, y, w + x, h);
        }
    }

    public void printHtml(PrintStream ps) {
        int textEnd = this.size();
        int start = 0;
        CharAttr curSty = null;
        int lastN = start;
        System.arraycopy(this.style, 0, styleBuff, 0, this.style.length);
        int buffn = 0;
        int textn = 0;
        while (textn < this.text.length) {
            if (this.text[textn] == 9) {
                int maxCnt = JXEOptions.TAB - buffn % JXEOptions.TAB;
                int tn = 0;
                while (tn < maxCnt) {
                    AttributedTextLine.styleBuff[buffn] = this.style[textn];
                    AttributedTextLine.buffer[buffn++] = 32;
                    ++tn;
                }
                ++textn;
                continue;
            }
            AttributedTextLine.styleBuff[buffn] = this.style[textn];
            AttributedTextLine.buffer[buffn++] = (char)(((char)this.text[textn++] + 256) % 256);
        }
        textEnd += buffn - textn;
        int n = start;
        while (n < textEnd) {
            if (n == textEnd - 1 || styleBuff[n] != styleBuff[n + 1]) {
                curSty = JXEOptions.GetStyles()[styleBuff[n]];
                if (curSty.font.isBold()) {
                    ps.print("<b>");
                }
                if (curSty.font.isItalic()) {
                    ps.print("<i>");
                }
                ps.print("<font color=#" + Integer.toHexString(curSty.fg.getRGB()).substring(2) + ">");
                String out = new String(buffer, lastN, n - lastN + 1);
                out = NCStringUtilities.Replace(out, "&", "&amp;");
                out = NCStringUtilities.Replace(out, "<", "&lt;");
                out = NCStringUtilities.Replace(out, ">", "&gt;");
                ps.print(out);
                ps.print("</font>");
                if (curSty.font.isItalic()) {
                    ps.print("</i>");
                }
                if (curSty.font.isBold()) {
                    ps.print("</b>");
                }
                lastN = n + 1;
            }
            ++n;
        }
    }

    public int drawOn(Graphics g, int pixY, int start, int end, int startInverse, int endInverse, CharAttr[] styles, int charW, int charH, int maxAsc, TextDocument doc, int[] charWidth, int docIndex) {
        int n;
        int textEnd = Math.min(end, this.size());
        start = Math.max(0, start);
        Color darkBG = Color.gray;
        CharAttr curSty = null;
        int lastN = start;
        int pixX = 0;
        String markWord = doc.getHiLightWord();
        if (markWord == null) {
            markWord = "";
        }
        int markWordCount = 0;
        boolean isAusblend = this.toString().trim().startsWith("//***");
        int buffn = 0;
        int textn = 0;
        while (textn < this.text.length) {
            if (this.text[textn] == 9) {
                int maxCnt = JXEOptions.TAB - buffn % JXEOptions.TAB;
                int tn = 0;
                while (tn < maxCnt) {
                    AttributedTextLine.styleBuff[buffn] = this.style[textn];
                    AttributedTextLine.buffer[buffn++] = 32;
                    ++tn;
                }
                ++textn;
                continue;
            }
            AttributedTextLine.styleBuff[buffn] = isAusblend ? 12 : this.style[textn];
            AttributedTextLine.buffer[buffn] = (char)(((char)this.text[textn++] + 256) % 256);
            if (markWord.length() > markWordCount) {
                if (!doc.getHilightWordMatchCase() && Character.toLowerCase(buffer[buffn]) == Character.toLowerCase(markWord.charAt(markWordCount)) || doc.getHilightWordMatchCase() && buffer[buffn] == markWord.charAt(markWordCount)) {
                    if (markWord.length() == ++markWordCount) {
                        boolean doMark = false;
                        if (doc.getHilightWordWholeWord()) {
                            if (!(buffn - markWordCount >= 0 && Character.isJavaIdentifierPart(buffer[buffn - markWordCount]) || textn < this.text.length && Character.isJavaIdentifierPart((char)this.text[textn]))) {
                                doMark = true;
                            }
                        } else {
                            doMark = true;
                        }
                        if (doMark) {
                            int n2 = 0;
                            while (n2 < markWordCount) {
                                AttributedTextLine.styleBuff[buffn - n2] = 11;
                                ++n2;
                            }
                        }
                        markWordCount = 0;
                    }
                } else {
                    markWordCount = 0;
                }
            }
            ++buffn;
        }
        doc.maxWidth = Math.max(doc.maxWidth, buffn);
        textEnd += buffn - textn;
        this.clearBG(g, 0, pixY - maxAsc, charW * 1024, charH, doc, docIndex);
        if (startInverse == -1 && endInverse == -1) {
            n = start;
            while (n < textEnd) {
                if (n == textEnd - 1 || styleBuff[n] != styleBuff[n + 1]) {
                    curSty = styles[styleBuff[n]];
                    pixX = charW * lastN;
                    if (styleBuff[n] == 11) {
                        g.setColor(darkBG);
                        g.fillRect(pixX, pixY - maxAsc, (n - lastN + 1) * charW, charH);
                        g.setColor(Color.white);
                    } else {
                        g.setColor(curSty.fg);
                    }
                    g.setFont(curSty.font);
                    g.drawChars(buffer, lastN, n - lastN + 1, pixX, pixY);
                    lastN = n + 1;
                }
                ++n;
            }
        } else {
            startInverse = this.translateX(startInverse);
            if ((endInverse = this.translateX(endInverse)) == 0 || textEnd == 0) {
                g.setColor(selectionbg);
                g.fillRect(0, pixY - maxAsc, charW / 2, charH);
            }
            if (endInverse > textEnd) {
                g.setColor(Color.lightGray);
                g.fillRect(charW * textEnd, pixY - maxAsc, charW * (endInverse - textEnd), charH);
            }
            n = start;
            while (n < textEnd) {
                if (n == textEnd - 1 || styleBuff[n] != styleBuff[n + 1] || n == startInverse - 1 || n == endInverse - 1) {
                    curSty = styles[styleBuff[n]];
                    pixX = charW * lastN;
                    if (startInverse <= lastN && endInverse > n && endInverse > startInverse) {
                        g.setColor(selectionbg);
                        g.fillRect(pixX, pixY - maxAsc, charW * (n - lastN + 1), charH);
                        g.setColor(selectiontext);
                    } else {
                        g.setColor(curSty.fg);
                    }
                    g.setFont(curSty.font);
                    g.drawChars(buffer, lastN, n - lastN + 1, pixX, pixY);
                    lastN = n + 1;
                }
                ++n;
            }
        }
        return buffn * charW;
    }

    public void setStyle(int sty, int start, int end) {
        int n = start;
        while (n < end && n < this.style.length) {
            this.style[n] = (byte)sty;
            ++n;
        }
    }

    public void setStyle(int sty) {
        this.setStyle(sty, 0, this.size());
    }

    public int size() {
        return this.text.length;
    }

    public char charAt(int x) {
        return (char)this.text[x];
    }

    public char styleAt(int x) {
        return (char)this.style[x];
    }

    public void insert(String s, int start, int line, TextDocument doc) {
        this.insert(new AttributedTextLine(s), start, line, doc);
    }

    public void insert(AttributedTextLine t, int start, int line, TextDocument doc) {
        if (doc != null) {
            if (doc.isReadOnly()) {
                return;
            }
            doc.addDiff(new GeneralDiff(line, start, 2, t.text, this));
        }
        byte[] newText = new byte[this.size() + t.size()];
        byte[] newStyle = new byte[this.size() + t.size()];
        System.arraycopy(this.text, 0, newText, 0, start);
        System.arraycopy(t.text, 0, newText, start, t.size());
        System.arraycopy(this.text, start, newText, start + t.size(), this.size() - start);
        System.arraycopy(this.style, 0, newStyle, 0, start);
        System.arraycopy(t.style, 0, newStyle, start, t.size());
        System.arraycopy(this.style, start, newStyle, start + t.size(), this.size() - start);
        this.text = newText;
        this.style = newStyle;
        if (doc != null) {
            doc.maxWidth = Math.max(this.text.length, doc.maxWidth);
        }
    }

    public void delete(int start, int end, int line, TextDocument doc) {
        start = Math.max(0, start);
        end = Math.max(0, end);
        start = Math.min(this.text.length, start);
        end = Math.min(this.text.length, end);
        if (doc != null && doc.isReadOnly()) {
            return;
        }
        byte[] del = new byte[Math.max(0, end - start)];
        System.arraycopy(this.text, start, del, 0, del.length);
        if (doc != null) {
            doc.addDiff(new GeneralDiff(line, start, 3, del, this));
        }
        start = Math.max(0, start);
        end = Math.min(end, this.size());
        byte[] newText = new byte[Math.max(0, this.size() - (end - start))];
        byte[] newStyle = new byte[Math.max(0, this.size() - (end - start))];
        System.arraycopy(this.text, 0, newText, 0, start);
        System.arraycopy(this.text, end, newText, start, this.size() - end);
        System.arraycopy(this.style, 0, newStyle, 0, start);
        System.arraycopy(this.style, end, newStyle, start, this.size() - end);
        this.text = newText;
        this.style = newStyle;
    }

    public AttributedTextLine copyFrom(int start, int end) {
        end = Math.min(end, this.size());
        start = Math.min(Math.max(0, start), end);
        AttributedTextLine result = new AttributedTextLine();
        result.text = new byte[end - start];
        result.style = new byte[end - start];
        try {
            System.arraycopy(this.text, start, result.text, 0, end - start);
            System.arraycopy(this.style, start, result.style, 0, end - start);
        }
        catch (Exception e) {
            Tracer.This.println("????? start:" + start + " end-start" + (end - start) + " textlen:" + result.text.length);
            e.printStackTrace();
            result.text = new byte[0];
            result.style = new byte[0];
        }
        return result;
    }

    public AttributedTextLine createCopy() {
        return this.copyFrom(0, this.size());
    }

    public CollapsedTextLine createCopyCollapsed() {
        return this.copyFromAsCollapsed(0, this.size());
    }

    public CollapsedTextLine copyFromAsCollapsed(int start, int end) {
        end = Math.min(end, this.size());
        start = Math.min(Math.max(0, start), end);
        CollapsedTextLine result = new CollapsedTextLine();
        result.text = new byte[end - start];
        result.style = new byte[end - start];
        try {
            System.arraycopy(this.text, start, result.text, 0, end - start);
            System.arraycopy(this.style, start, result.style, 0, end - start);
        }
        catch (Exception e) {
            Tracer.This.println("????? start:" + start + " end-start" + (end - start) + " textlen:" + result.text.length);
            e.printStackTrace();
            result.text = new byte[0];
            result.style = new byte[0];
        }
        return result;
    }

    public AttributedTextLine split(int pos, int line, TextDocument doc) {
        if (doc != null && doc.isReadOnly()) {
            return new AttributedTextLine("");
        }
        AttributedTextLine result = this.copyFrom(pos, this.size());
        this.delete(pos, this.size(), line, doc);
        return result;
    }

    public int getFirstChar() {
        int x = 0;
        while (x < this.size() && this.charAt(x) <= ' ') {
            ++x;
        }
        return x;
    }

    public char getFirstCharacter() {
        int x = 0;
        while (x < this.size() && this.charAt(x) <= ' ') {
            ++x;
        }
        return x >= 0 && x < this.size() ? this.charAt(x) : (char)'\u0000';
    }

    public int getLastChar() {
        int x = this.size() - 1;
        while (x >= 0 && this.charAt(x) <= ' ') {
            --x;
        }
        return x;
    }

    public char getLastCharacter() {
        int x = this.size() - 1;
        while (x >= 0 && this.charAt(x) <= ' ') {
            --x;
        }
        return x >= 0 && x < this.size() ? this.charAt(x) : (char)'\u0000';
    }

    public byte[] applyTabSettings(byte[] line, int start, int end) {
        if (JXEOptions.TAB == JXEOptions.READINTAB) {
            byte[] result = new byte[end - start];
            System.arraycopy(line, start, result, 0, end - start);
            return result;
        }
        int internal = JXEOptions.TAB;
        int external = JXEOptions.READINTAB;
        int externalCnt = 0;
        boolean internalCnt = false;
        int internalNumTabs = 0;
        int internalNumChars = 0;
        int idx = start;
        while (idx < end && (line[idx] == 32 || line[idx] == 9)) {
            externalCnt = line[idx] == 9 ? (externalCnt += external - externalCnt % external) : ++externalCnt;
            ++idx;
        }
        internalNumTabs = (idx -= start) / internal;
        internalNumChars = idx % internal;
        byte[] result = new byte[internalNumTabs + internalNumChars + (end - start) - idx];
        int n = internalNumTabs - 1;
        while (n >= 0) {
            result[n] = 9;
            --n;
        }
        int n2 = internalNumChars - 1;
        while (n2 >= 0) {
            result[n2 + internalNumTabs] = 32;
            --n2;
        }
        System.arraycopy(line, start + internalNumTabs + internalNumChars, result, idx, result.length - idx);
        return result;
    }

    public int hashCode() {
        if (this.text.length < 1) {
            return 0;
        }
        return this.text.length + (this.text[this.text.length / 2] << 8) + (this.text[this.text.length / 4] << 16) + (this.text[2 * this.text.length / 3] << 24);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof AttributedTextLine)) {
            return false;
        }
        return this.isEqual((AttributedTextLine)o, false);
    }

    public boolean isEqual(AttributedTextLine tl, boolean ignoreWS) {
        if (!ignoreWS && tl.size() != this.size()) {
            return false;
        }
        if (!ignoreWS) {
            int n = 0;
            while (n < this.size()) {
                if (this.text[n] != tl.text[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        int x1 = 0;
        int x2 = 0;
        while (true) {
            if (x1 < this.text.length && this.text[x1] <= 32) {
                ++x1;
                continue;
            }
            while (x2 < tl.text.length && tl.text[x2] <= 32) {
                ++x2;
            }
            if (x2 >= tl.text.length && x1 >= this.text.length) {
                return true;
            }
            if (x2 >= tl.text.length || x1 >= this.text.length) {
                return false;
            }
            if (tl.text[x2] != this.text[x1]) break;
            ++x1;
            ++x2;
        }
        return false;
    }
}

