/*
 * Decompiled with CFR 0.152.
 */
package Jxe.completers;

import JCollections.JUnsafeTable;
import Jxe.DocumentStream;
import Jxe.TextDocument;
import Jxe.completers.BasicMLCompleter;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.util.Tracer;
import java.awt.event.KeyEvent;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.Vector;

public class HtmlCompleter
extends BasicMLCompleter {
    JUnsafeTable tags = new JUnsafeTable(61);
    protected JUnsafeTable singles;
    boolean upperTags = false;

    public HtmlCompleter(File config) {
        try {
            FileInputStream fr = new FileInputStream(config);
            DataInputStream in = new DataInputStream(fr);
            String line = null;
            String lastTag = "notag";
            String lastAtt = "noatt";
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).length() <= 0) continue;
                switch (line.charAt(0)) {
                    case '-': {
                        lastAtt = line.substring(1);
                        this.addAttribute(lastTag, lastAtt);
                        break;
                    }
                    case '#': {
                        this.addAttributeValue(lastTag, lastAtt, line.substring(1));
                        break;
                    }
                    default: {
                        int i = line.indexOf("==");
                        if (i < 0) {
                            this.addTag(line, line);
                        } else {
                            String hid = line.substring(i + 2);
                            line = line.substring(0, i);
                            this.addTag(line, hid);
                        }
                        lastTag = line;
                    }
                }
            }
            fr.close();
        }
        catch (Exception th) {
            th.printStackTrace();
        }
        this.initSingles();
    }

    public void initSingles() {
        this.singles = new JUnsafeTable(11);
        String[] s = new String[]{"br", "p", "img", "li"};
        int n = 0;
        while (n < s.length) {
            this.singles.put(s[n], Boolean.TRUE);
            ++n;
        }
    }

    protected String getHid(String tag) {
        JUnsafeTable attTable = this.getAttributes(tag);
        if (attTable == null) {
            return null;
        }
        return (String)attTable.get("helpid");
    }

    Vector getValues(String tag, String attribute) {
        JUnsafeTable attTable = this.getAttributes(tag.toLowerCase());
        if (attTable == null) {
            return null;
        }
        Object res = attTable.get(attribute);
        if (res instanceof Vector) {
            return (Vector)res;
        }
        return null;
    }

    JUnsafeTable getAttributes(String tag) {
        return (JUnsafeTable)this.tags.get(tag.toLowerCase());
    }

    void addAttributeValue(String tag, String attribute, String value) {
        tag = tag.toLowerCase();
        value = value.toLowerCase();
        attribute = attribute.toLowerCase();
        JUnsafeTable atts = (JUnsafeTable)this.tags.get(tag);
        if (atts == null) {
            atts = new JUnsafeTable(5);
            this.tags.put(tag, atts);
        }
        Vector values = null;
        if (atts.get(attribute) instanceof Boolean || atts.get(attribute) == null) {
            atts.put(attribute, new Vector(3));
        }
        values = (Vector)atts.get(attribute);
        values.addElement(value);
    }

    void addAttribute(String tag, String attribute) {
        tag = tag.toLowerCase();
        attribute = attribute.toLowerCase();
        JUnsafeTable atts = (JUnsafeTable)this.tags.get(tag);
        if (atts == null) {
            atts = new JUnsafeTable(5);
            this.tags.put(tag, atts);
        }
        atts.put(attribute, Boolean.TRUE);
    }

    void addTag(String name, String helpId) {
        name = name.toLowerCase();
        helpId = helpId.toLowerCase();
        JUnsafeTable atts = (JUnsafeTable)this.tags.get(name);
        if (atts == null) {
            atts = new JUnsafeTable(5);
            this.tags.put(name, atts);
        }
        if (helpId == null || helpId.trim().length() == 0) {
            helpId = name;
        }
        if (atts.get("helpId") == null || name.equals(atts.get("helpId"))) {
            atts.put("helpid", helpId);
        }
    }

    Vector findLastOpenTags(TextDocument doc) {
        Tracer.This.println("-------looking for tags");
        DocumentStream ds = new DocumentStream(doc, doc.cX() - 2, doc.cY());
        Vector<String> result = new Vector<String>(10);
        int c = 0;
        int prevC = 0;
        int nestCount = 0;
        StringBuffer lastTag = new StringBuffer(50);
        while ((c = ds.readBackward()) > 0) {
            if (Character.isLetterOrDigit((char)c)) {
                lastTag.append((char)c);
            } else {
                if (c == 60) {
                    if (prevC == 47) {
                        ++nestCount;
                    } else {
                        String tag = lastTag.reverse().toString().trim();
                        Tracer.This.println("---candidate:" + tag + " nestCount:" + nestCount);
                        if (tag.length() > 0) {
                            result.addElement(tag + ">");
                        }
                        if (this.singles.get(tag.toLowerCase()) == null) {
                            --nestCount;
                        }
                        if (nestCount < 0) {
                            if (result.size() == 1) {
                                result.addElement("zzzzzzz");
                            }
                            return result;
                        }
                    }
                }
                lastTag.setLength(0);
            }
            if (c <= 32) continue;
            prevC = c;
        }
        return result;
    }

    protected Vector getAttributesAsVector(String tag) {
        JUnsafeTable atts = this.getAttributes(tag);
        if (atts != null) {
            Vector<String> res = new Vector<String>(atts.size());
            Enumeration en = atts.keys();
            while (en.hasMoreElements()) {
                String s = en.nextElement().toString();
                if (s.equals("helpid")) continue;
                res.addElement(s);
            }
            if (res.size() == 1) {
                res.addElement("zzzzzzz");
            }
            return res;
        }
        return null;
    }

    public Vector completeOnTagOpen(TextDocument doc) {
        Vector res = new Vector(this.tags.size());
        Enumeration en = this.tags.keys();
        while (en.hasMoreElements()) {
            res.addElement(en.nextElement());
        }
        return this.toUpper(res, this.upperTags);
    }

    public Vector completeOnEqual(TextDocument doc) {
        String tag = this.findIfInTag(doc);
        if (tag == null) {
            return null;
        }
        this.upperTags = tag.length() > 0 && Character.isUpperCase(tag.charAt(0));
        tag = tag.toLowerCase();
        JWidgetsUtil.HelpEvent("html" + File.separator + this.getHid(tag));
        if (doc.cX() > 0) {
            String cW1 = doc.completionWordAsString(doc.cX() - 1, doc.cY());
            Vector v = this.getValues(tag, cW1.toLowerCase());
            if (v != null) {
                v = (Vector)v.clone();
            }
            return this.toUpper(v, this.upperTags);
        }
        return null;
    }

    public Vector keyTyped(StringBuffer typedContext, KeyEvent e, TextDocument doc) {
        if (typedContext.length() >= 1) {
            if (typedContext.charAt(typedContext.length() - 1) == '/' && doc.cX() > 1 && doc.charAt(doc.cX() - 2, doc.cY()) == '<') {
                typedContext.setLength(0);
                return this.findLastOpenTags(doc);
            }
            if (typedContext.charAt(typedContext.length() - 1) == '<') {
                return this.completeOnTagOpen(doc);
            }
            if (typedContext.charAt(typedContext.length() - 1) == '=') {
                typedContext.setLength(0);
                return this.completeOnEqual(doc);
            }
        }
        if (e.getKeyCode() == 32 && !e.isControlDown() && !e.isAltDown()) {
            String tag = this.findIfInTag(doc);
            if (tag == null) {
                return null;
            }
            this.upperTags = tag.length() > 0 && Character.isUpperCase(tag.charAt(0));
            tag = tag.toLowerCase();
            JWidgetsUtil.HelpEvent("html" + File.separator + this.getHid(tag));
            typedContext.setLength(0);
            return this.toUpper(this.getAttributesAsVector(tag), this.upperTags);
        }
        if (e.getKeyChar() == '@') {
            String tag = this.findIfInTag(doc);
            if (tag == null) {
                return null;
            }
            Vector<String> res = new Vector<String>();
            res.add("page");
            res.add("include");
            res.add("taglib");
            JWidgetsUtil.HelpEvent("html" + File.separator + this.getHid(tag));
            typedContext.setLength(0);
            return res;
        }
        if (e.getKeyChar() == '%') {
            String tag = this.findIfInTag(doc);
            if (tag == null) {
                return null;
            }
            JWidgetsUtil.HelpEvent("html" + File.separator + this.getHid(tag));
            typedContext.setLength(0);
            return null;
        }
        typedContext.setLength(0);
        return null;
    }

    Vector toUpper(Vector ofStrings, boolean toUp) {
        if (!toUp || ofStrings == null) {
            return ofStrings;
        }
        int n = 0;
        while (n < ofStrings.size()) {
            ofStrings.setElementAt(ofStrings.elementAt(n).toString().toUpperCase(), n);
            ++n;
        }
        return ofStrings;
    }

    public Vector explicitCompletionRequest(TextDocument doc) {
        String compWord = doc.completionWordAsString();
        if (compWord.equals("<")) {
            return this.completeOnTagOpen(doc);
        }
        if (compWord.equals("=")) {
            return this.completeOnEqual(doc);
        }
        String tag = this.findIfInTag(doc);
        Tracer.This.println("#######found Tagstart " + tag);
        if (tag == null) {
            return super.explicitCompletionRequest(doc);
        }
        this.upperTags = tag.length() > 0 && Character.isUpperCase(tag.charAt(0));
        Tracer.This.println("UPPER TAGS DETECTED");
        JWidgetsUtil.HelpEvent("html" + File.separator + this.getHid(tag.toLowerCase()));
        if (compWord.equals(tag)) {
            Vector res = new Vector(this.tags.size());
            Enumeration en = this.tags.keys();
            while (en.hasMoreElements()) {
                res.addElement(en.nextElement());
            }
            return this.toUpper(res, this.upperTags);
        }
        if (doc.cX() > compWord.length() && (compWord.equals("=") || doc.charAt(doc.cX() - compWord.length() - 1, doc.cY()) == '=')) {
            String cW1 = "";
            if (compWord.equals("=")) {
                doc.completionWordAsString(doc.cX() - 1, doc.cY());
            } else {
                doc.completionWordAsString(doc.cX() - compWord.length() - 1, doc.cY());
            }
            Tracer.This.println("############cw1 " + cW1);
            Vector v = this.getValues(tag, cW1);
            if (v != null) {
                v = (Vector)v.clone();
            }
            return this.toUpper(v, this.upperTags);
        }
        return this.toUpper(this.getAttributesAsVector(tag), this.upperTags);
    }
}

