/*
 * Decompiled with CFR 0.152.
 */
package com.stevesoft.pat.apps;

import com.stevesoft.pat.FileRegex;
import com.stevesoft.pat.Regex;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Vector;

public class Grep {
    boolean iflag = false;
    boolean pflag = false;
    boolean vflag = false;
    boolean verbose = false;
    Regex re = null;
    Vector v = new Vector();
    int lineno = 0;
    String _file = "";

    public static void main(String[] args) throws Exception {
        Grep g = new Grep();
        g.doArgs(args);
    }

    public boolean getIFlag() {
        return this.iflag;
    }

    public void setIFlag(boolean b) {
        this.iflag = b;
    }

    public boolean getPFlag() {
        return this.pflag;
    }

    public void setPFlag(boolean b) {
        this.pflag = b;
    }

    public boolean getVFlag() {
        return this.vflag;
    }

    public void setVFlag(boolean b) {
        this.vflag = b;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean b) {
        this.verbose = b;
    }

    public void setRegex(Regex r) {
        this.re = r;
    }

    public Regex getRegex() {
        return this.re;
    }

    void setLineno(int n) {
        this.lineno = n;
    }

    int getLineno() {
        return this.lineno;
    }

    void incLineno() {
        ++this.lineno;
    }

    String getFile() {
        return this._file;
    }

    void setFile(String s) {
        this._file = s;
    }

    void doArgs(String[] args) throws Exception {
        int i = 0;
        while (i < args.length) {
            if (args[i].charAt(0) == '-') {
                int j = 1;
                while (j < args[i].length()) {
                    char c = args[i].charAt(j);
                    switch (c) {
                        case 'i': {
                            this.iflag = true;
                            break;
                        }
                        case 'p': {
                            this.pflag = true;
                            break;
                        }
                        case 'v': {
                            this.vflag = true;
                            break;
                        }
                        default: {
                            throw new Error("Unknown flag: " + c);
                        }
                    }
                    ++j;
                }
            } else if (this.re == null) {
                Regex r = new Regex((this.iflag ? "(?i)" : "") + args[i]);
                r.optimize();
                this.setRegex(r);
            } else {
                String[] files = FileRegex.list(args[i]);
                int j = 0;
                while (j < files.length) {
                    this.v.addElement(files[j]);
                    ++j;
                }
            }
            ++i;
        }
        if (this.v.size() > 1) {
            this.setVerbose(true);
        }
        if (this.v.size() == 0) {
            this.doInputStream(System.in);
        }
        int i2 = 0;
        while (i2 < this.v.size()) {
            this.doFile((String)this.v.elementAt(i2));
            ++i2;
        }
    }

    void doInputStream(InputStream is) throws Exception {
        InputStreamReader r = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(r);
        this.setFile("STDIN");
        this.setLineno(0);
        PrintWriter stdout = new PrintWriter(new OutputStreamWriter(System.out));
        this.process(br, stdout);
        stdout.close();
    }

    void doFile(String file2) throws Exception {
        FileReader fr = new FileReader(file2);
        BufferedReader br = new BufferedReader(fr);
        PrintWriter stdout = new PrintWriter(new OutputStreamWriter(System.out));
        this.setFile(file2);
        this.setLineno(0);
        this.process(br, stdout);
        br.close();
        stdout.close();
    }

    void process(BufferedReader br, PrintWriter pw) throws Exception {
        String s = this.nextLine(br);
        while (s != null) {
            if (this.re.search(s) ^ this.vflag) {
                if (this.verbose) {
                    pw.print(this.getFile() + " " + this.getLineno() + ": ");
                }
                pw.println(s);
            }
            s = this.nextLine(br);
        }
    }

    String nextLine(BufferedReader br) throws Exception {
        if (this.pflag) {
            StringBuffer sb = new StringBuffer();
            String s = null;
            while (s != null && !s.trim().equals("")) {
                sb.append(s);
                s = br.readLine();
                this.incLineno();
            }
            return sb.toString();
        }
        String s = br.readLine();
        this.incLineno();
        return s;
    }
}

