/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import Jxe.TextDocument;
import de.netcomputing.anyj.AJExternalToolsGUI;
import de.netcomputing.anyj.ToolItem;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.gui.AJEnvTextField;
import de.netcomputing.anyj.jwidgets.ISelectedContext;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.application.services.INCService;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.ToolActionSetup;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import jxeplugins.JEPluginOptions;
import netcomputing.tools.Executor;
import netcomputing.tools.PropWriter;
import plugins.tools.ToolExec;

public class AJExternalTools
extends JEPluginOptions {
    public static AJExternalTools This;
    NCButton addBtn;
    NCButton removeBtn;
    NCButton invokeBtn;
    AJEnvTextField clineFld;
    AJEnvTextField wdFld;
    NCButton cancelBtn;
    NCButton applyBtn;
    NCTextField toolFld;
    NCCheckBox consoleChk;
    NCTreeBean listPanel;
    Vector items = new Vector(20);

    public void initGui() {
        This = this;
        new AJExternalToolsGUI().createGui(this);
        this.init();
        this.applyBtn.setMnemonic('O');
        this.cancelBtn.setMnemonic('C');
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void enableApplyButtons(boolean b) {
        this.applyBtn.setEnabled(b);
        this.cancelBtn.setEnabled(b);
        if (this.listPanel.getSelectedItem() != null && this.getRootPane() != null) {
            this.getRootPane().setDefaultButton(this.applyBtn);
        }
    }

    public void init() {
        super.init();
        DocumentListener tl = new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                AJExternalTools.this.enableApplyButtons(true);
            }

            public void removeUpdate(DocumentEvent e) {
                AJExternalTools.this.enableApplyButtons(true);
            }

            public void changedUpdate(DocumentEvent e) {
                AJExternalTools.this.enableApplyButtons(true);
            }
        };
        this.clineFld.addDocumentListener(tl);
        this.toolFld.getDocument().addDocumentListener(tl);
        this.wdFld.addDocumentListener(tl);
        this.removeBtn.addTarget(this, "actionRemove");
        this.listPanel.addTarget(this, "actionListSelection");
        this.addBtn.addTarget(this, "actionAdd");
        this.applyBtn.addTarget(this, "actionApply");
        this.listPanel.clear();
        this.listPanel.setList(this.items, 0.0, -1);
        this.setName("hidplugins_toolsplugin");
        Tracer.This.println("app " + this.app);
        this.setUIState();
        JEBasicService ser = new JEBasicService("External Tools", "Add External Tool", 1){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                EditApp.App.openOptions("Global.External Tools");
                AJExternalTools.this.actionAdd(null, null);
            }
        };
        EditApp.ServReg.addService(ser);
    }

    public void setUIState() {
        if (this.listPanel.getSelectedItem() == null) {
            this.removeBtn.setEnabled(false);
            this.applyBtn.setEnabled(false);
            this.cancelBtn.setEnabled(false);
            this.clineFld.setText("");
            this.toolFld.setText("");
            this.wdFld.setText("");
            this.clineFld.setEnabled(false);
            this.toolFld.setEnabled(false);
            this.wdFld.setEnabled(false);
            this.consoleChk.setEnabled(false);
        } else {
            ToolItem t = (ToolItem)this.listPanel.getSelectedItem();
            this.removeBtn.setEnabled(true);
            this.applyBtn.setEnabled(true);
            this.cancelBtn.setEnabled(true);
            this.clineFld.setText(t.cline);
            this.toolFld.setText(t.tool);
            this.wdFld.setText(t.wDir);
            this.clineFld.setEnabled(true);
            this.toolFld.setEnabled(true);
            this.wdFld.setEnabled(true);
            this.consoleChk.setEnabled(true);
            this.consoleChk.setPressed(t.useConsole);
        }
    }

    public Object actionRemove(Object arg, Object sen) {
        this.listPanel.removeItemRepainting(this.listPanel.getSelectedItem());
        this.setUIState();
        this.getApplicationStub().binderApplication().notifyTargets("servicesChanged");
        return null;
    }

    public Object actionListSelection(Object arg, Object sen) {
        this.setUIState();
        this.applyBtn.setEnabled(false);
        this.cancelBtn.setEnabled(false);
        return null;
    }

    public Object actionAdd(Object arg, Object sen) {
        ToolItem t = new ToolItem();
        t.wDir = "($workspaceDir)";
        t.tool = "New Added";
        t.cline = "";
        this.listPanel.addItem(t);
        this.listPanel.setSelectionIndex(this.listPanel.listSize() - 1);
        this.listPanel.repaint();
        this.setUIState();
        return null;
    }

    public Object actionApply(Object arg, Object sen) {
        ToolItem t = (ToolItem)this.listPanel.getSelectedItem();
        INCService old = this.getApplicationStub().getServiceNamed("External Tools " + t.getDisplayString());
        this.getApplicationStub().remServiceNamed("External Tools " + t.getDisplayString());
        this.removeBtn.setEnabled(true);
        t.cline = this.clineFld.getText();
        t.tool = this.toolFld.getText();
        t.wDir = this.wdFld.getText();
        t.useConsole = this.consoleChk.isPressed();
        this.listPanel.repaint();
        this.applyBtn.setEnabled(false);
        this.cancelBtn.setEnabled(false);
        INCService newServ = this.constructService(t);
        if (old != null) {
            newServ.copyAttributes(old);
        }
        this.getApplicationStub().addService(newServ);
        this.getApplicationStub().binderApplication().notifyTargets("servicesChanged");
        return null;
    }

    public String getJIBName() {
        return "cline.jib";
    }

    INCService constructService(final ToolItem t) {
        final EditApp as = this.getApplicationStub();
        JEBasicService ser = new JEBasicService("External Tools", t.tool, 10){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof ISelectedContext;
            }

            public void doProcess(Object selection, Object selector) {
                ISelectedContext sel = (ISelectedContext)selection;
                Hashtable env = as.buildEnvironment(sel);
                String cline = as.insertEnvVars(t.cline, env);
                String wDir = as.insertEnvVars(t.wDir, env);
                if (t.useConsole) {
                    ToolExec toolEx = new ToolExec(AJExternalTools.this.app);
                    JEBatchHostFrame.This().addPanel(t.tool, toolEx, true, NCApplication.GetImage("/images/props/External Tools.gif"));
                    JEBatchHostFrame.This().showTab(t.tool);
                    toolEx.setWdir(wDir);
                    toolEx.setCommandText(cline);
                    toolEx.startProcess();
                } else {
                    Executor.ExecAndForget(cline, wDir);
                }
                if (EditFrame.Host().getCurrentEditFrame() != null) {
                    TextDocument doc = EditFrame.Host().getCurrentEditFrame().getDocument();
                    JWidgetsUtil.AddJob(new Runnable(this, doc){
                        private final /* synthetic */ TextDocument val$doc;
                        private final /* synthetic */ 3 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$doc = val$doc;
                        }

                        public void run() {
                            int n = 0;
                            while (n < 4) {
                                try {
                                    Thread.sleep(500L);
                                }
                                catch (Exception Ee) {
                                    Ee.printStackTrace();
                                }
                                Tracer.This.println("waiting for checkout to finish");
                                if (this.val$doc.getFile().canWrite()) {
                                    EditApp.App.updateDirTree();
                                    EditFrame.Host().getCurrentEditFrame().checkReadOnly();
                                    break;
                                }
                                ++n;
                            }
                        }
                    });
                }
            }
        };
        return ser;
    }

    public void addTool(String name, String wdir, String cline, boolean useConsole) {
        ToolItem ti = null;
        boolean exists = false;
        if (this.listPanel.indexOfByString(name) >= 0) {
            ti = (ToolItem)this.items.elementAt(this.listPanel.indexOfByString(name));
            exists = true;
        } else {
            ti = new ToolItem();
        }
        ti.tool = name;
        ti.wDir = wdir;
        ti.cline = cline;
        ti.useConsole = useConsole;
        if (!exists) {
            this.items.addElement(ti);
            this.listPanel.repaint();
        }
        INCService newServ = this.constructService(ti);
        this.getApplicationStub().addService(newServ);
        this.getApplicationStub().binderApplication().notifyTargets("servicesChanged");
    }

    public Vector getItems() {
        return this.items;
    }

    public void _storeProperty(PropWriter pw) throws Exception {
        DataOutputStream o = pw.createStream("ToolsConfig");
        Vector v = this.listPanel.getList();
        o.writeInt(v.size());
        int n = 0;
        while (n < v.size()) {
            ToolItem ti = (ToolItem)v.elementAt(n);
            o.writeUTF(ti.wDir);
            o.writeUTF(ti.tool);
            o.writeUTF(ti.cline);
            o.writeBoolean(ti.useConsole);
            ++n;
        }
    }

    public void _loadProperty(PropWriter pw) throws Exception {
        DataInputStream o = pw.getStream("ToolsConfig");
        if (this.items.size() != 0) {
            this.items.setSize(0);
        }
        if (this.listPanel != null) {
            this.listPanel.setList(this.items, 0.0, -1);
        }
        int N = o.readInt();
        int n = 0;
        while (n < N) {
            ToolItem ti = new ToolItem();
            ti.wDir = o.readUTF();
            ti.tool = o.readUTF();
            ti.cline = o.readUTF();
            ti.useConsole = o.readBoolean();
            this.items.addElement(ti);
            ++n;
        }
        int n2 = 0;
        while (n2 < this.items.size()) {
            this.getApplicationStub().addService(this.constructService((ToolItem)this.items.elementAt(n2)));
            ++n2;
        }
        this.setUIState();
    }

    public void executeTool(String name, final File context) {
        ToolItem t = null;
        int n = 0;
        while (n < this.items.size()) {
            ToolItem ti = (ToolItem)this.items.elementAt(n);
            if (ti.getDisplayString().equals(name)) {
                t = ti;
            }
            ++n;
        }
        if (t == null) {
            return;
        }
        ISelectedContext sel = new ISelectedContext(){

            public int size() {
                return 1;
            }

            public Object at(int n) {
                return context;
            }
        };
        Hashtable env = EditApp.App.buildEnvironment(sel);
        String cline = EditApp.App.insertEnvVars(t.cline, env);
        String wDir = EditApp.App.insertEnvVars(t.wDir, env);
        if (t.useConsole) {
            ToolExec toolEx = new ToolExec(this.app);
            JEBatchHostFrame.This().addPanel(t.tool, toolEx, true, NCApplication.GetImage("/images/props/External Tools.gif"));
            JEBatchHostFrame.This().showTab(t.tool);
            toolEx.setWdir(wDir);
            toolEx.setCommandText(cline);
            toolEx.startProcess();
        } else {
            Executor.ExecAndForget(cline, wDir);
        }
        if (!"checkout".equals(name.toLowerCase())) {
            JWidgetsUtil.AddLongRunningJob(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(2000L);
                        EditFrame f = EditApp.App.getEditFrameIfPresent(context);
                        if (f != null) {
                            f.checkReadOnly();
                            f.checkModified();
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
    }

    public void consoleChk_itemStateChanged(ItemEvent var0) {
        this.applyBtn.setEnabled(true);
        this.cancelBtn.setEnabled(true);
    }

    public void consoleChk_stateChanged(ChangeEvent var0) {
        this.applyBtn.setEnabled(true);
        this.cancelBtn.setEnabled(true);
    }

    public void invokeBtn_actionPerformed(ActionEvent var0) {
        ToolActionSetup.EditTools((Window)this.getFrame());
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.setUIState();
    }
}

