/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import Jxe.DocumentStream;
import Jxe.TextDocument;
import de.netcomputing.anyj.AJFindDialogGUI;
import de.netcomputing.anyj.AJFindUsage;
import de.netcomputing.anyj.AJSemanticFind;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.application.JDialog;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCCheckBox;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.beans.NCHistoryChoice;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

public class AJFindDialog
extends NCPanel
implements WindowListener {
    JComboBox advancedBox;
    NCCheckBox matchCaseBox;
    NCButton nextBtn;
    NCButton prevBtn;
    NCHistoryChoice findTxt;
    NCCheckBox wholeWordBox;
    TextDocument doc;
    DocumentStream ds;
    int rangeYS;
    int rangeYE;
    static String lastSearch = "";
    static boolean lastMatchCase = false;
    static boolean lastWholeWord;
    boolean enterPressed = false;
    boolean lastFailed = false;

    public static AJFindDialog CreateFrame(boolean show) {
        JFrame frame = new JFrame();
        AJFindDialog panel = new AJFindDialog();
        panel.getRootPane().setDefaultButton(panel.nextBtn);
        frame.getContentPane().add("Center", panel);
        frame.addWindowListener(panel);
        frame.pack();
        frame.setVisible(show);
        return panel;
    }

    public static AJFindDialog CreateDialog(Frame parent, boolean modal, boolean show) {
        JDialog dialog = new JDialog(parent, modal);
        AJFindDialog panel = new AJFindDialog();
        dialog.getContentPane().add("Center", panel);
        dialog.addWindowListener(panel);
        dialog.pack();
        dialog.setVisible(show);
        panel.wholeWordBox.setSelected(lastWholeWord);
        panel.matchCaseBox.setSelected(lastMatchCase);
        return panel;
    }

    public AJFindDialog() {
        this.initGui();
    }

    public void initGui() {
        new AJFindDialogGUI().createGui(this);
        this.nextBtn.setMnemonic('N');
        this.prevBtn.setMnemonic('P');
        this.findTxt.addKeyListener(new KeyFilter(10, this, "actionFindEnter"));
        this.prevBtn.addKeyListener(new KeyFilter(27, this, "actionClose"));
        this.nextBtn.addKeyListener(new KeyFilter(27, this, "actionClose"));
        this.advancedBox.setModel(new DefaultComboBoxModel<Object>(new Object[]{"Advanced ..", "Full Text Search", "Syntax Search", "Typed Search"}));
    }

    public void initSearch(TextDocument doc, String toSearch) {
        this.enterPressed = false;
        this.rangeYS = 0;
        this.rangeYE = doc.size() + 1;
        if (toSearch == null) {
            toSearch = "";
        }
        this.doc = doc;
        this.findTxt.setText(toSearch);
        this.saveStateToGlobal();
        this.findTxt.setSelectionStart(0);
        this.findTxt.setSelectionEnd(toSearch.length());
        this.findTxt.requestFocus();
    }

    void saveStateToGlobal() {
        lastSearch = this.findTxt.getText();
        lastMatchCase = this.matchCaseBox.isSelected();
        lastWholeWord = this.wholeWordBox.isSelected();
    }

    public Object actionFindEnter(Object sen, Object arg) {
        if (this.enterPressed) {
            return null;
        }
        this.enterPressed = true;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AJFindDialog.this.saveStateToGlobal();
                AJFindDialog.this.findAndSelectForward(AJFindDialog.this.doc);
            }
        });
        this.actionClose(null, null);
        return null;
    }

    public Object actionClose(Object sen, Object arg) {
        this.saveStateToGlobal();
        this.getDialog().hide();
        this.getDialog().dispose();
        ((JComponent)((Object)this.doc.getView())).getTopLevelAncestor().show();
        return null;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public javax.swing.JDialog getDialog() {
        return (javax.swing.JDialog)this.getTopLevelAncestor();
    }

    public Container getFrame() {
        return (JFrame)this.getTopLevelAncestor();
    }

    public void findAndSelectForward(TextDocument doc) {
        this.doc = doc;
        this.findAndSelectForward(lastSearch);
    }

    public void findAndSelectBackward(TextDocument doc) {
        this.doc = doc;
        this.findAndSelectBackward(lastSearch);
    }

    boolean isRangeEnabled() {
        return false;
    }

    private boolean findNextInRange(DocumentStream ds, String s, boolean ignoreCase, boolean whole) {
        boolean b = true;
        do {
            b = ds.findNext(s, ignoreCase, whole);
            if (this.isRangeEnabled()) continue;
            return b;
        } while (b && (ds.posY() < this.rangeYS || ds.posY() > this.rangeYE));
        return b && ds.posY() >= this.rangeYS && ds.posY() <= this.rangeYE;
    }

    private boolean findPrevInRange(DocumentStream ds, String s, boolean ignoreCase, boolean whole) {
        boolean b = true;
        do {
            b = ds.findPrev(s, ignoreCase, whole);
            if (this.isRangeEnabled()) continue;
            return b;
        } while (b && (ds.posY() < this.rangeYS || ds.posY() > this.rangeYE));
        return b && ds.posY() >= this.rangeYS && ds.posY() <= this.rangeYE;
    }

    public void findAndSelectForward(String s) {
        this.doc.setHiLightWord(s);
        this.doc.setHilightWordMatchCase(this.matchCaseBox.isSelected());
        this.doc.setHilightWordWholeWord(this.wholeWordBox.isSelected());
        if (s == null) {
            return;
        }
        if (s.length() == 0) {
            return;
        }
        if (this.lastFailed) {
            this.doc.moveCursorAbs(0, 0);
        }
        this.ds = new DocumentStream(this.doc, this.doc.cX(), this.doc.cY());
        if (this.findNextInRange(this.ds, s, !this.matchCaseBox.isPressed(), this.wholeWordBox.isSelected())) {
            this.doc.setSelection(this.ds.posX() - s.length(), this.ds.posY(), this.ds.posX(), this.ds.posY());
            this.doc.setSelectingPoint(this.ds.posX() - s.length(), this.ds.posY());
            this.doc.moveCursorAbs(this.ds.posX(), this.ds.posY());
            this.doc.centerPosition();
            EditFrame.Host().setStatusText(EditFrame.Host().getCurrentEditFrame(), "F3 for next match");
            this.lastFailed = false;
        } else {
            this.doc.unsetSelection();
            this.lastFailed = true;
            EditFrame.Host().setStatusText(EditFrame.Host().getCurrentEditFrame(), "'" + s + "' not found, press F3 to start from top");
        }
        this.doc.repaintAll();
    }

    public void findAndSelectBackward() {
        this.findAndSelectBackward(lastSearch);
    }

    public void findAndSelectBackward(String s) {
        this.doc.setHiLightWord(s);
        this.doc.setHilightWordMatchCase(this.matchCaseBox.isSelected());
        this.doc.setHilightWordWholeWord(this.wholeWordBox.isSelected());
        if (s == null) {
            return;
        }
        if (s.length() == 0) {
            return;
        }
        if (this.lastFailed) {
            this.doc.moveCursorAbs(this.doc.lineAt(this.doc.size() - 1).size(), this.doc.size() - 1);
        }
        this.ds = new DocumentStream(this.doc, this.doc.cX(), this.doc.cY());
        if (this.findPrevInRange(this.ds, s, !this.matchCaseBox.isPressed(), this.wholeWordBox.isSelected())) {
            this.doc.setSelection(this.ds.posX(), this.ds.posY(), this.ds.posX() + s.length(), this.ds.posY());
            this.doc.moveCursorAbs(this.ds.posX(), this.ds.posY());
            this.doc.setSelectingPoint(this.ds.posX(), this.ds.posY());
            this.doc.centerPosition();
            this.lastFailed = false;
        } else {
            this.doc.unsetSelection();
            this.lastFailed = true;
            EditFrame.Host().setStatusText(EditFrame.Host().getCurrentEditFrame(), "'" + s + "' not found, press F3 to start from bottom");
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        ((Window)this.getDialog()).hide();
        this.getDialog().dispose();
    }

    public void windowClosed(WindowEvent e) {
        this.saveStateToGlobal();
    }

    public void windowActivated(WindowEvent e) {
    }

    public void advancedBox_itemStateChanged(ItemEvent var0) {
        int i = this.advancedBox.getSelectedIndex();
        switch (i) {
            case 0: {
                return;
            }
            case 1: {
                EditApp.App.openNewFindPanel(this.doc.getFile(), this.findTxt.getText());
                break;
            }
            case 2: {
                EditApp.App.openNewFindPanel(new AJSemanticFind(), this.doc.getFile(), this.findTxt.getText(), "Syntax Search '" + this.findTxt.getText() + "'");
                break;
            }
            case 3: {
                AJFindUsage ajfu = new AJFindUsage();
                EditApp.App.openNewFindPanel(ajfu, this.doc.getFile(), this.findTxt.getText(), "Syntax Search '" + this.findTxt.getText() + "'");
                ajfu.findTypeFromSel(this.doc, this.findTxt.getText());
            }
        }
        this.advancedBox.setSelectedIndex(0);
        this.actionClose(null, null);
    }

    public void prevBtn_actionPerformed(ActionEvent var0) {
        this.findAndSelectBackward(this.findTxt.getText());
    }

    public void nextBtn_actionPerformed(ActionEvent var0) {
        this.findAndSelectForward(this.findTxt.getText());
    }

    public void closeBtn_actionPerformed(ActionEvent var0) {
        this.getDialog().hide();
        this.getDialog().dispose();
    }
}

