/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJJDKOptionsGUI;
import de.netcomputing.anyj.ITabbedPaneDiag;
import de.netcomputing.anyj.LibraryItem;
import de.netcomputing.anyj.debugger.DebuggerMainPanel;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.propertystore.beans.PathEditorBean;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.JWJavaParser;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import javax.swing.DefaultListModel;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JTabbedPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import netcomputing.tools.PropWriter;

public class AJJDKOptions
extends NCPanel
implements ITabbedPaneDiag {
    NCButton cancelBtn;
    NCButton applyBtn;
    JTabbedPane mainTabbedPane;
    NCButton setJDKBtn;
    PropertyFileSel msHome;
    JCheckBox assertChk;
    NCButton wizBtn;
    NCTextField jdkHome;
    PropertyFileSel javacFile;
    PropertyFileSel libSource;
    PropertyFileSel libClass;
    JList libList;
    PathEditorBean jdocPath;
    DefaultListModel model;
    public static AJJDKOptions This;
    static String[] toSave;
    boolean ignoreUpdates = false;
    LibraryItem sys;
    LibraryItem swing;
    LibraryItem servlet;
    LibraryItem tools;
    int lastSel = -1;

    public AJJDKOptions() {
        This = this;
    }

    public void initGui() {
        new AJJDKOptionsGUI().createGui(this);
        this.enableApplyButtons(false);
        DocumentListener enableButtons = new DocumentListener(){

            public void removeUpdate(DocumentEvent e) {
                AJJDKOptions.this.enableApplyButtons(true);
            }

            public void insertUpdate(DocumentEvent e) {
                AJJDKOptions.this.enableApplyButtons(true);
            }

            public void changedUpdate(DocumentEvent e) {
                AJJDKOptions.this.enableApplyButtons(true);
            }
        };
        this.msHome.addDocumentListener(enableButtons);
        this.javacFile.addDocumentListener(enableButtons);
        this.jdkHome.addDocumentListener(enableButtons);
        this.libSource.addDocumentListener(enableButtons);
        this.libClass.addDocumentListener(enableButtons);
        this.jdocPath.addDocumentListener(enableButtons);
        this.applyBtn.setMnemonic('O');
        this.cancelBtn.setMnemonic('C');
        this.assertChk.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperty(PropWriter pw) throws Exception {
        DebuggerMainPanel.This().resetLoadedClasses();
        try {
            DataInputStream in = pw.getStream("JDKAndLibs");
            int i = 0;
            while (i < toSave.length) {
                try {
                    String key = toSave[i];
                    String val = in.readUTF();
                    EditApp.App.setWorkspaceProperty(key, val);
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
                ++i;
            }
            Object var7_7 = null;
            this.readFromSysProps();
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            this.readFromSysProps();
            throw throwable;
        }
    }

    public void storeProperty(PropWriter pw) throws Exception {
        DataOutputStream out = pw.createStream("JDKAndLibs");
        int i = 0;
        while (i < toSave.length) {
            try {
                String key = toSave[i];
                String val = (String)EditApp.App.getWorkspaceProperty(key);
                out.writeUTF(val);
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
            ++i;
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public JTabbedPane getMainTabbedPane() {
        return this.mainTabbedPane;
    }

    void enableApplyButtons(boolean b) {
        this.applyBtn.setEnabled(b);
        this.cancelBtn.setEnabled(b);
    }

    public void writeLibList() {
        LibraryItem it = (LibraryItem)this.libList.getSelectedValue();
        if (it != null) {
            it.source = this.libSource.getText();
            it.jar = this.libClass.getText();
        }
        int n = 0;
        while (n < this.model.size()) {
            LibraryItem item = (LibraryItem)this.model.elementAt(n);
            if (item.name.equals("SystemClasses")) {
                EditApp.App.setWorkspaceProperty("Library.Classes", item.jar);
                EditApp.App.setWorkspaceProperty("Library.Source.Classes", item.source);
            } else if (item.name.equals("Swing")) {
                EditApp.App.setWorkspaceProperty("Library.Swing", item.jar);
                EditApp.App.setWorkspaceProperty("Library.Source.Swing", item.source);
            } else if (item.name.equals("ServletSDK")) {
                EditApp.App.setWorkspaceProperty("Library.ServletSDK", item.jar);
                EditApp.App.setWorkspaceProperty("Library.Source.ServletSDK", item.source);
            } else if (item.name.equals("Tools")) {
                EditApp.App.setWorkspaceProperty("Library.Tools", item.jar);
                EditApp.App.setWorkspaceProperty("Library.Source.Tools", item.source);
            }
            ++n;
        }
    }

    public void writeToSysProps() {
        this.ignoreUpdates = true;
        EditApp.App.setWorkspaceProperty("Directory.msdkHome", this.msHome.getText());
        EditApp.App.setWorkspaceProperty("File.javac", this.javacFile.getText());
        EditApp.App.setWorkspaceProperty("Directory.jdkHome", this.jdkHome.getText());
        EditApp.App.setWorkspaceProperty("Path.javadoc", this.jdocPath.getText());
        this.javacFile.setText("" + EditApp.App.getWorkspaceProperty("File.javac"));
        this.jdkHome.setText("" + EditApp.App.getWorkspaceProperty("Directory.jdkHome"));
        this.jdocPath.setText("" + EditApp.App.getWorkspaceProperty("Path.javadoc"));
        this.msHome.setText("" + EditApp.App.getWorkspaceProperty("Directory.msdkHome"));
        if (this.assertChk.isSelected()) {
            JWJavaParser.ResetParser("java14.oos");
        } else {
            JWJavaParser.ResetParser("java14.oos");
        }
        this.writeLibList();
        this.ignoreUpdates = false;
        EditApp.App.getOptions().updatePropertiesInPropDiag();
    }

    public void readFromSysProps() {
        if (this.ignoreUpdates) {
            return;
        }
        this.msHome.setText("" + EditApp.App.getWorkspaceProperty("Directory.msdkHome"));
        this.javacFile.setText("" + EditApp.App.getWorkspaceProperty("File.javac"));
        this.jdkHome.setText("" + EditApp.App.getWorkspaceProperty("Directory.jdkHome"));
        this.jdocPath.setText("" + EditApp.App.getWorkspaceProperty("Path.javadoc"));
        this.assertChk.setSelected(!"java14.oos".equals(JWJavaParser.getJavaGrammarFile()));
        this.model = new DefaultListModel();
        this.libList.setModel(this.model);
        this.readLibList();
    }

    void readLibList() {
        this.model.removeAllElements();
        this.sys = new LibraryItem("SystemClasses", "" + EditApp.App.getWorkspaceProperty("Library.Classes"), "" + EditApp.App.getWorkspaceProperty("Library.Source.Classes"));
        this.model.addElement(this.sys);
        this.swing = new LibraryItem("Swing", "" + EditApp.App.getWorkspaceProperty("Library.Swing"), "" + EditApp.App.getWorkspaceProperty("Library.Source.Swing"));
        this.model.addElement(this.swing);
        this.servlet = new LibraryItem("ServletSDK", "" + EditApp.App.getWorkspaceProperty("Library.ServletSDK"), "" + EditApp.App.getWorkspaceProperty("Library.Source.ServletSDK"));
        this.model.addElement(this.servlet);
        this.tools = new LibraryItem("Tools", "" + EditApp.App.getWorkspaceProperty("Library.Tools"), "" + EditApp.App.getWorkspaceProperty("Library.Source.Tools"));
        this.model.addElement(this.tools);
        this.libList.setSelectedIndex(0);
    }

    public void assertChk_itemStateChanged(ItemEvent var0) {
        this.enableApplyButtons(true);
    }

    public void setJDKBtn_actionPerformed(ActionEvent var0) {
        this.wizBtn_actionPerformed(var0);
    }

    public void libList_valueChanged(ListSelectionEvent var0) {
        LibraryItem sel;
        if (this.ignoreUpdates) {
            return;
        }
        int i = this.libList.getSelectedIndex();
        if (this.lastSel >= 0 && this.lastSel < this.model.size()) {
            sel = (LibraryItem)this.model.elementAt(this.lastSel);
            sel.source = this.libSource.getText();
            sel.jar = this.libClass.getText();
        }
        if (i >= 0 && i < this.model.size()) {
            sel = (LibraryItem)this.model.elementAt(i);
            this.libSource.setText(sel.source);
            this.libClass.setText(sel.jar);
        }
        this.lastSel = i;
    }

    public void wizBtn_actionPerformed(ActionEvent var0) {
        this.enableApplyButtons(false);
        EditApp.App.jol.menuTools_resetJDK(null, null);
        this.readFromSysProps();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.readFromSysProps();
        this.enableApplyButtons(false);
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        this.writeToSysProps();
        this.enableApplyButtons(false);
        DebuggerMainPanel.This().resetLoadedClasses();
    }

    static {
        toSave = new String[]{"Library.Classes", "Library.Source.Classes", "Library.Swing", "Library.Source.Swing", "Library.ServletSDK", "Library.Source.ServletSDK", "Library.Tools", "Library.Source.Tools", "Directory.msdkHome", "File.javac", "Directory.jdkHome", "Path.javadoc"};
    }
}

