/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import de.netcomputing.anyj.AJRenameClassGUI;
import de.netcomputing.anyj.AJSemanticFind;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Image;
import java.io.File;
import javax.swing.SwingUtilities;

public class AJRenameClass
extends AJSemanticFind {
    IndexEntry clazzIE = null;

    public void initGui() {
        new AJRenameClassGUI().createGui(this);
        super.init();
        this.classRefChk.setSelected(true);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AJRenameClass.this.actionProcess(null, null);
            }
        });
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void setClazzIE(IndexEntry clazzIE) {
        this.clazzIE = clazzIE;
    }

    public IndexEntry getClazzIE() {
        return this.clazzIE;
    }

    protected void replaceAll() {
        super.replaceAll();
        String oldName = this.toSearch;
        String newName = this.getReplaceText();
        if (this.clazzIE == null) {
            this.clazzIE = SourceBase.This().getPossibleClassDefFor(oldName, null);
        }
        if (this.clazzIE == null) {
            Confirm.ModalMsg("No File renamed", "No File " + oldName + ".java found.");
        } else {
            File f = new File(this.clazzIE.fileString());
            if (f.getName().equals(oldName + ".java")) {
                File newF;
                EditFrame fr = EditApp.App.getEditFrameIfPresent(f);
                if (fr != null) {
                    fr.save();
                }
                if (!f.renameTo(newF = new File(f.getParent(), newName + ".java"))) {
                    Confirm.ModalMsg("File renaming failed", "Check for OS locks:" + f.getAbsolutePath());
                } else {
                    SourceBase.This().update(f.getAbsolutePath());
                    SourceBase.This().update(newF.getAbsolutePath());
                    if (fr != null) {
                        fr.load(newF);
                        fr.getDocument().repaint();
                    }
                }
            }
        }
    }
}

