/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.DirIterator;
import de.netcomputing.anyj.AJCompileAndBuild;
import de.netcomputing.anyj.AJWorkspaceNurseryGUI;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.NCStatusImpl;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCCollectionUtil;
import de.netcomputing.util.NCFileUtilities;
import editapp.EditApp;
import editapp.SourceBase;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.INCExtendedPrintout;

public class AJWorkspaceNursery
extends NCPanel
implements Runnable {
    NCButton okBtn;
    NCButton cancelBtn;
    JProgressBar progress;
    JLabel text;
    boolean cancel = false;
    ArrayList doubles = new ArrayList(100);
    ArrayList packMismatch = new ArrayList(100);
    int errors = 0;
    INCExtendedPrintout out;

    public static void Open() {
        JDialog dlg = new JDialog(EditApp.App.getMainWindow(), "Workspace Check", true);
        AJWorkspaceNursery ajem = new AJWorkspaceNursery();
        dlg.getContentPane().add(ajem);
        dlg.pack();
        ApplicationHelper.Singleton().centerWindow(dlg);
        Thread t = new Thread(ajem);
        t.setPriority(1);
        t.start();
        dlg.setVisible(true);
    }

    public AJWorkspaceNursery() {
        this.initGui();
        this.cancelBtn.setEnabled(true);
        this.okBtn.setEnabled(false);
    }

    public void initGui() {
        new AJWorkspaceNurseryGUI().createGui(this);
    }

    public void run() {
        this.out = JEBatchHostFrame.This().createOutput("Workspace Check");
        this.out.clear();
        this.out.printLine("checking jdk ..");
        this.checkJDKAndPathes();
        this.out.printLine(".. finished checking jdk");
        this.out.printLine("");
        this.out.printLine("");
        if (this.cancel) {
            this.out.printLine("ABORTED BY USER");
            return;
        }
        this.out.printLine("checking mounted directories ..");
        this.checkMountedDirs();
        this.out.printLine(".. checking mounted directories");
        this.out.printLine("");
        this.out.printLine("");
        if (this.cancel) {
            this.out.printLine("ABORTED BY USER");
            return;
        }
        this.out.printLine("start package and sourcepath check ..");
        HashMap fqClazzToPack = this.searchDoublePackages();
        this.out.printLine(".. finished package and sourcepath check");
        this.out.printLine("");
        this.out.printLine("");
        if (this.cancel) {
            this.out.printLine("ABORTED BY USER");
            return;
        }
        this.out.printLine("updating SourceIndex ..");
        this.checkSourceIndex();
        this.out.printLine(".. updating SourceIndex");
        this.out.printLine("");
        this.out.printLine("");
        if (this.cancel) {
            this.out.printLine("ABORTED BY USER");
            return;
        }
        this.out.printLine("start checking for missing packages in sourcebase   ..");
        this.checkForMissingPackages();
        this.out.printLine(".. finished checking for missing packages in sourcebase");
        this.out.printLine("");
        this.out.printLine("");
        if (this.cancel) {
            this.out.printLine("CHECK ABORTED BY USER");
            return;
        }
        this.progress.setString("FINISHED [ " + (this.doubles.size() + this.packMismatch.size() + this.errors) + " errors/warnings ]");
        this.cancelBtn.setEnabled(false);
        this.okBtn.setEnabled(true);
    }

    public void checkSourceIndex() {
        this.text.setText("<html><h3>Updating SourceIndex</h3><br>The SourceIndex is a repository storing all definitions.<br>Browsers, Code completion and Refactoring features rely on<br>the content of the SourceIndex.");
        SourceBase.This().buildSynchronous(EditApp.App.getScanableDirs(), this.out, new NCStatusImpl(this.progress), true, false, true);
    }

    public void checkMountedDirs() {
        this.text.setText("<html><h3>Checking Mounted Directories</h3><br>AnyJ checks, if mounted directories/jars exist.<br>Note that directories can be mounted 'hidden'");
        Vector v = EditApp.App.getAllDirs();
        int i = 0;
        while (i < v.size()) {
            String s = (String)v.get(i);
            if (!new File(s).exists()) {
                ++this.errors;
                this.out.printLine("[WARN ] Mounted directory/jar does not exist, check Preferences,Directories - " + s);
            }
            ++i;
        }
    }

    public void checkForMissingPackages() {
        this.text.setText("<html><h3>Checking SourceIndex completness</h3><br>Code Completion, Browsing and Refactoring features<br>rely on the completness of the SourceIndex. AnyJ now checks, if all packages referenced from the sourcepath are known to the SourceIndex.");
        HashSet definedPacks = new HashSet(EditApp.App.getKnownPackages());
        HashMap fiToImp = new HashMap(1000);
        String sp = AJCompileAndBuild.This.getSourcePathAndCompute();
        Vector spV = NCFileUtilities.GetPathAsVector(sp);
        Vector v = new Vector(2000);
        int i = 0;
        while (i < spV.size()) {
            v.addAll(DirIterator.DirContent(new File((String)spV.get(i)), ".java"));
            ++i;
        }
        HashSet tmpSet = new HashSet(v);
        v.clear();
        v.addAll(tmpSet);
        NCFileUtilities.BuildImportMap(v, fiToImp, new HashSet(), this.out, new NCStatusImpl(this.progress));
        HashMap errorMap = new HashMap();
        Iterator it = new TreeSet(fiToImp.keySet()).iterator();
        while (it.hasNext()) {
            String fi = (String)it.next();
            Vector imps = (Vector)fiToImp.get(fi);
            int i2 = 0;
            while (i2 < imps.size()) {
                String imp = (String)imps.get(i2);
                if (!definedPacks.contains(imp)) {
                    ++this.errors;
                    NCCollectionUtil.PutVect(errorMap, imp, fi);
                }
                ++i2;
            }
        }
        it = new TreeSet(errorMap.keySet()).iterator();
        while (it.hasNext()) {
            String pack = (String)it.next();
            this.out.printLine("[ERROR] package " + pack + " unknown to SourceBase, may hurt Coding Assistance and Refactoring");
            HashSet fiV = (HashSet)errorMap.get(pack);
            Iterator itt = new TreeSet(fiV).iterator();
            while (itt.hasNext()) {
                this.out.printLine("        - " + itt.next() + ":0:");
            }
        }
    }

    public HashMap searchDoublePackages() {
        String sp = AJCompileAndBuild.This.getSourcePathAndCompute();
        Vector v = NCFileUtilities.GetPathAsVector(sp);
        HashSet sourcepath = new HashSet(v);
        HashMap fqClazz2File = new HashMap();
        INCExtendedPrintout out = JEBatchHostFrame.This().createOutput("Workspace Check");
        int i = 0;
        while (i < v.size()) {
            if (this.cancel) {
                out.printLine("ABORTED BY USER");
                return fqClazz2File;
            }
            this.text.setText("<html><h3>Checking for double Classes/Package mismatch</h3><br>AnyJ checks, whether your SourcePath contains classes twice.<br><br>Checking:<br>" + v.get(i) + "<br><br>[ sourcepath = " + sp + " ]");
            NCFileUtilities.CheckSourceDir((String)v.elementAt(i), fqClazz2File, out, new NCStatusImpl(this.progress), this.packMismatch, this.doubles);
            ++i;
        }
        Iterator clazzes = fqClazz2File.keySet().iterator();
        while (clazzes.hasNext()) {
            String fqCl = (String)clazzes.next();
            String path = (String)fqClazz2File.get(fqCl);
            String sub = path.substring(0, path.length() - fqCl.length() - ".java".length() - 1);
            if (sourcepath.contains(sub)) continue;
            ++this.errors;
            out.printLine("[ERROR] Package Root not part of Sourcepath - " + path);
        }
        return fqClazz2File;
    }

    public void checkJDKAndPathes() {
        this.text.setText("<html><h3>Checking JDK</h3><br>AnyJ checks, if your JDK settings are valid.<br>");
        String jdkHome = (String)EditApp.App.getWorkspaceProperty("Directory.jdkHome");
        if (!new File(jdkHome, "lib" + File.separator + "tools.jar").exists()) {
            ++this.errors;
            this.out.printLine("[ERROR] JDK is not valid [JRE instead JDK ?] - missing tools.jar");
        }
        if (!new File(jdkHome, "jre" + File.separator + "lib" + File.separator + "rt.jar").exists()) {
            ++this.errors;
            this.out.printLine("[ERROR] JDK is not valid - missing rt.jar");
        }
        if (!new File(AJCompileAndBuild.This.getCompilerString()).exists()) {
            ++this.errors;
            this.out.printLine("[ERROR] Could not find compiler - " + AJCompileAndBuild.This.getCompilerString());
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void okBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).dispose();
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        this.cancel = true;
        SourceBase.This().waitForBuilderStop();
        ((Window)this.getTopLevelAncestor()).dispose();
    }
}

