/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj;

import JCollections.DirIterator;
import JCollections.JUnsafeVector;
import Jxe.AttributedTextLine;
import Jxe.TextDocument;
import de.netcomputing.anyj.DBSirMarksGUI;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.application.JDialog;
import de.netcomputing.anyj.gui.ListSelector;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.snapshots.SnapShotRegistry;
import de.netcomputing.propertystore.beans.PropertyFileSel;
import de.netcomputing.runtime.ApplicationHelper;
import editapp.EditApp;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jxeplugins.JEBatchHostFrame;
import netcomputing.tools.INCExtendedPrintout;
import netcomputing.tools.INCPrintOut;

public class DBSirMarks
extends JPanel {
    public static boolean DBSystems = false;
    static JDialog ThisFrame;
    public static DBSirMarks This;
    NCButton snapshotBtn;
    JCheckBox joinChk;
    JCheckBox collapseChk;
    PropertyFileSel diffPathTxt;
    PropertyFileSel pathTxt;
    NCButton applyBtn;
    NCButton cancelBtn;
    JTextField pastAdd;
    JTextField preAdd;
    JTextField pastRem;
    JTextField preRem;
    public boolean isRunning;

    public static JDialog ThisFrame(String path) {
        DBSirMarks.This(path);
        return ThisFrame;
    }

    public static DBSirMarks This(String path) {
        if (ThisFrame == null) {
            ThisFrame = new JDialog(EditApp.App.getMainWindow());
            This = new DBSirMarks();
            ThisFrame.getContentPane().add(This);
            ThisFrame.pack();
            ThisFrame.setTitle("Mark Diff in File(s)");
            JWidgetsUtil.CenterOnScreen(ThisFrame);
        }
        if (path != null) {
            DBSirMarks.This.pathTxt.setText(path);
        }
        return This;
    }

    public DBSirMarks() {
        this.initGui();
    }

    public void initGui() {
        new DBSirMarksGUI().createGui(this);
        this.setMark("SIR X");
    }

    public void setMark(String tag) {
        this.preRem.setText("//*** SIR 18555 DELETE");
        this.pastRem.setText("//*** END DELETED SIR 18555 (" + tag + ")");
        this.preAdd.setText("//*** SIR 18555 BEGIN");
        this.pastAdd.setText("//*** SIR 18555 END");
        this.collapseChk.setSelected(true);
        this.joinChk.setSelected(true);
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void snapshotBtn_actionPerformed(ActionEvent var0) {
        ArrayList al = SnapShotRegistry.This().getTagsFor(this.pathTxt.getText());
        Object[] tags = new String[al.size()];
        int i = 0;
        while (i < al.size()) {
            tags[i] = ((String[])al.get(i))[0];
            ++i;
        }
        String s = (String)ListSelector.SelectFromList("Available Snapshots:", (Window)EditApp.App.getMainWindow(), tags, 0);
        if (s != null) {
            int index = -1;
            int i2 = 0;
            while (i2 < al.size()) {
                if (((String[])al.get(i2))[0].equals(s)) {
                    index = i2;
                }
                ++i2;
            }
            if (index >= 0) {
                this.diffPathTxt.setText(((String[])al.get(index))[1]);
            }
        }
    }

    public void markDiffsInDir(final File old, final File toModify) {
        final INCExtendedPrintout po = JEBatchHostFrame.This().createOutput("Mark Diffs");
        po.clear();
        new Thread(){

            public void run() {
                DBSirMarks.this.isRunning = true;
                if (System.getProperty("DBS", null) != null) {
                    DBSystems = true;
                }
                Vector cont = DirIterator.DirContent(toModify, ".java");
                TextDocument header = null;
                if (DBSystems) {
                    header = new TextDocument(new File("c:\\temp\\header.txt"));
                }
                int i = 0;
                while (i < cont.size()) {
                    File toMod = (File)cont.get(i);
                    if (!toMod.isDirectory()) {
                        String nettoToDiff = toMod.getAbsolutePath().substring(toModify.getAbsolutePath().length());
                        File toDiff = new File(old.getAbsolutePath(), nettoToDiff);
                        if (!toDiff.exists()) {
                            po.printLine("No File to Compare found for:" + toMod.getAbsolutePath() + ", [tried " + toDiff.getAbsolutePath() + "]");
                            if (header != null) {
                                TextDocument doc = new TextDocument(toMod);
                                DBSirMarks.this.replaceHeader(doc, header, po);
                                try {
                                    doc.replaceAll("TRYST", toMod.getName());
                                }
                                catch (Exception ex) {
                                    // empty catch block
                                }
                                try {
                                    doc.setFile(toMod);
                                    doc.save();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                                po.printLine("     [Inserted new header]");
                            }
                        } else {
                            try {
                                if (DBSystems) {
                                    DBSirMarks.this.markDiffDBS(toDiff, toMod, po);
                                } else {
                                    DBSirMarks.this.markDiff(toDiff, toMod);
                                }
                            }
                            catch (Exception ex) {
                                po.printLine("ERROR:" + toMod.getAbsolutePath());
                                po.printLine("     :" + ex.getClass().getName() + " ");
                                po.printLine("     :" + ex.getMessage());
                                po.printLine("");
                                ex.printStackTrace();
                            }
                        }
                    }
                    ++i;
                }
                DBSirMarks.this.isRunning = false;
            }
        }.start();
    }

    public TextDocument copyHeader(TextDocument doc, INCPrintOut out) {
        try {
            int line = 0;
            while (line < doc.size() && !doc.lineAt(line).toString().trim().equals("*/")) {
                ++line;
            }
            if (line + 1 < doc.size()) {
                TextDocument res = doc.createCopy(0, line + 1, 0, 0);
                return res;
            }
        }
        catch (Exception ex) {
            out.printLine("WARNING: EXCEPTION DURING HEADER COPY:" + doc.getFile().getAbsolutePath());
        }
        out.printLine("Unable to find header in " + doc.getFile().getAbsolutePath());
        return null;
    }

    public void replaceHeader(TextDocument doc, TextDocument header, INCPrintOut out) {
        try {
            int line = 0;
            while (line < doc.size() && !doc.lineAt(line).toString().trim().equals("*/")) {
                doc.remLineAt(line);
            }
            doc.remLineAt(line);
            if (line < doc.size()) {
                doc.moveCursorAbs(0, 0);
                doc.pasteDoc(header);
                return;
            }
        }
        catch (Exception ex) {
            out.printLine("WARNING: EXCEPTION DURING HEADER REPLACE:" + doc.getFile().getAbsolutePath());
        }
        out.printLine("Unable to find header in " + doc.getFile().getAbsolutePath());
    }

    public void insertHeaderLine(TextDocument doc, String lineString, INCPrintOut out) {
        int line = 0;
        try {
            while (line < doc.size() && !doc.lineAt(line).toString().trim().equals("*/")) {
                ++line;
            }
            if (line + 1 < doc.size()) {
                if (doc.lineAt(line - 2).toString().trim().equals("*")) {
                    doc.insertLine(line - 2, lineString);
                } else {
                    doc.insertLine(line - 1, " *");
                    doc.insertLine(line - 1, lineString);
                }
                return;
            }
        }
        catch (Exception ex) {
            out.printLine("WARNING: EXCEPTION DURING HEADER INSERT LINE:" + doc.getFile().getAbsolutePath());
        }
        out.printLine("Unable to find header in " + doc.getFile().getAbsolutePath());
    }

    public float markDiffDBS(File old, File toModify, INCPrintOut out) throws Exception {
        TextDocument doc = new TextDocument(old);
        TextDocument oldDoc = new TextDocument(old);
        EditFrame ef = EditApp.App.getEditFrameIfPresent(toModify);
        doc = ef != null ? ef.getDocument() : new TextDocument(toModify);
        TextDocument oldHeader = this.copyHeader(oldDoc, out);
        if (oldHeader != null) {
            this.replaceHeader(doc, oldHeader, out);
        }
        doc.save();
        int[] changeCount = new int[]{0};
        TextDocument savedDoc = doc.createCopy();
        TextDocument result = this.markDiffInDocs(doc, old, toModify, changeCount);
        savedDoc.setFile(toModify);
        float ratio = (float)changeCount[0] / (float)result.size();
        if (ratio > 0.25f || changeCount[0] == 0) {
            result = savedDoc;
            if (changeCount[0] > 0) {
                out.printLine("REDESIGN:" + toModify.getAbsolutePath() + " (ratio:" + ratio + ")");
                this.insertHeaderLine(result, " *  15-APR-2002  E60_GUI    18555   Java GUI Eurex 6.0: Framework Adaption Redesign", out);
            } else {
                out.printLine("NODIFFS:" + toModify.getAbsolutePath());
            }
        } else {
            out.printLine("MARKED:" + toModify.getAbsolutePath() + " RATIO:" + ratio);
            this.insertHeaderLine(result, " *  15-APR-2002  E60_GUI    18555   Java GUI Eurex 6.0: Framework Adaption", out);
        }
        if (ef != null) {
            doc.guessHiLighter();
            doc.highlightAll();
            ef.editPanel.setDocument(result);
        }
        result.save();
        doc.setModified(true);
        return 0.0f;
    }

    public float markDiff(File old, File toModify) throws Exception {
        TextDocument doc = null;
        EditFrame ef = EditApp.App.getEditFrameIfPresent(toModify);
        doc = ef != null ? ef.getDocument() : new TextDocument(toModify);
        int[] changeCount = new int[]{0};
        TextDocument result = this.markDiffInDocs(doc, old, toModify, changeCount);
        if (ef != null) {
            doc.guessHiLighter();
            doc.highlightAll();
            ef.editPanel.setDocument(result);
        } else {
            result.save();
        }
        return (float)result.size() / (float)changeCount[0];
    }

    TextDocument markDiffInDocs(TextDocument doc, File old, File toModify, int[] changeCount) throws Exception {
        doc.setModified(true);
        Vector diffs = TextDocument.DiffExternal(toModify, old, " -b -B --minimal");
        doc.applyDiffEntries(diffs);
        TextDocument result = new TextDocument(new JUnsafeVector());
        if (diffs.size() == 0) {
            changeCount[0] = 0;
            return doc.createCopy();
        }
        int prevMode = 0;
        int i = 0;
        while (i < doc.size()) {
            if (doc.lineAt(i).getMark() == '\u0001') {
                changeCount[0] = changeCount[0] + 1;
                if (prevMode != 1) {
                    result.addLine(this.preRem.getText());
                }
                if (!this.collapseChk.isSelected()) {
                    result.addLine("//" + doc.lineAt(i));
                    result.lineAt(result.size() - 1).mark('\u0001');
                }
                prevMode = 1;
            } else if (doc.lineAt(i).getMark() == '\u0002') {
                changeCount[0] = changeCount[0] + 1;
                if (prevMode != 2) {
                    if (i > 0 && result.lineAt(result.size() - 1).toString().trim().equals(this.preRem.getText().trim())) {
                        result.setLine(result.size() - 1, new AttributedTextLine(this.preAdd.getText()));
                    } else {
                        result.addLine(this.preAdd.getText());
                    }
                }
                result.addLine(doc.lineAt(i));
                prevMode = 2;
            } else {
                if (prevMode == 1 && !this.collapseChk.isSelected()) {
                    result.addLine(this.pastRem.getText());
                }
                if (prevMode == 2) {
                    result.addLine(this.pastAdd.getText());
                }
                result.addLine(doc.lineAt(i));
                prevMode = 0;
            }
            ++i;
        }
        result.setFile(toModify);
        return result;
    }

    public void cancelBtn_actionPerformed(ActionEvent var0) {
        ((Window)this.getTopLevelAncestor()).hide();
    }

    public void applyBtn_actionPerformed(ActionEvent var0) {
        try {
            File toModify = new File(this.pathTxt.getText());
            File oldVersion = new File(this.diffPathTxt.getText());
            if (!oldVersion.exists() || !toModify.exists()) {
                Confirm.ModalMsg(EditApp.App.getMainWindow(), "Error", new String[]{"One of the specified files", "does not exist."});
                return;
            }
            if (toModify.isDirectory()) {
                this.markDiffsInDir(oldVersion, toModify);
            } else {
                this.markDiff(oldVersion, toModify);
            }
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
            ex.printStackTrace();
        }
    }
}

