/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.application;

import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWScrollPane;
import de.netcomputing.anyj.jwidgets.KeyFilter;
import de.netcomputing.anyj.jwidgets.ListItem;
import java.awt.BorderLayout;
import java.util.Vector;
import javax.swing.JComponent;

public class NCCompletionPopup
extends JComponent {
    String initialText;
    Object[] from;
    public JListPanel list;
    public Object userData;
    int resIndex;
    Object result;

    public static NCCompletionPopup Select(String text, JWScrollPane parent, Object[] from, int x, int y, int lineHeight) {
        NCCompletionPopup pop = new NCCompletionPopup(text, from);
        pop.show(parent, x, y, lineHeight);
        pop.revalidate();
        parent.repaintDeferred();
        return pop;
    }

    public NCCompletionPopup(String text, Object[] from) {
        this.initialText = text;
        Vector<ListItem> items = new Vector<ListItem>();
        int n = 0;
        while (n < from.length) {
            if (!"zzzzzzz".equals(from[n].toString())) {
                items.addElement(new ListItem(from[n]));
            }
            ++n;
        }
        this.initList(items);
    }

    public void show(JWScrollPane comp, int x, int y, int lineHeight) {
        comp.setOverlayedComponent(this);
        int height = comp.getHeight();
        int width = comp.getWidth();
        int minHeight = 200;
        if (y < 100) {
            minHeight = 100;
        }
        int popupHeight = Math.max(50, Math.min(minHeight, this.list.listSize() * 16));
        if (x + 400 > width) {
            x = width - 400;
        }
        if (y + popupHeight > height && (y = y - popupHeight - lineHeight) < 0) {
            popupHeight += y;
            y = 0;
        }
        this.setBounds(x, y, 400, popupHeight);
    }

    void initList(Vector items) {
        this.setLayout(new BorderLayout());
        this.list = new JListPanel();
        this.add("Center", this.list);
        this.list.init();
        this.list.initIndent(0);
        this.list.setDrawLines(false);
        this.list.setTree(false);
        this.list.setBackground(JWColor.For("popup.bg"));
        this.list.setForeground(JWColor.For("listpanel.foreground"));
        this.list.setList(items, 0.0, -1);
        this.list.setSelectionIndexMoveToTop(0);
        this.list.noHorz();
        this.list.noVert();
        this.list.setInitialSearchText(this.initialText);
        this.list.listCanvas().binderMouseSel().addTarget(this, "actionListOK");
        this.list.addKeyListener(new KeyFilter(10, this, "actionListOK"));
        this.list.addKeyListener(new KeyFilter(27, this, "actionListESC"));
    }

    public Object actionListOK(Object arg, Object sen) {
        this.result = this.list.getSelectedObject();
        this.resIndex = this.list.getSelectionIndex();
        return null;
    }

    public Object actionListESC(Object arg, Object sen) {
        this.result = null;
        this.resIndex = -1;
        return null;
    }
}

