/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import JCollections.DirIterator;
import JCollections.JArray;
import JWVFile.VFile;
import Jxe.DocumentStream;
import Jxe.JXEOptions;
import Jxe.TextDocument;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.LaunchingConnector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventIterator;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.DuplicateRequestException;
import com.sun.jdi.request.StepRequest;
import de.netcomputing.anyj.application.EditFrame;
import de.netcomputing.anyj.application.MultiFrameEditorHost;
import de.netcomputing.anyj.debugger.DBGEvalPanel;
import de.netcomputing.anyj.debugger.DBGWatchPanel;
import de.netcomputing.anyj.debugger.DebuggerBreakpointList;
import de.netcomputing.anyj.debugger.DebuggerClassloader;
import de.netcomputing.anyj.debugger.DebuggerConnect;
import de.netcomputing.anyj.debugger.DebuggerDBLList;
import de.netcomputing.anyj.debugger.DebuggerItem;
import de.netcomputing.anyj.debugger.DebuggerMainPanelGUI;
import de.netcomputing.anyj.debugger.DebuggerOutputPanel;
import de.netcomputing.anyj.debugger.DebuggerWatchPanel;
import de.netcomputing.anyj.debugger.EvalResultNode;
import de.netcomputing.anyj.debugger.LocalVarItem;
import de.netcomputing.anyj.debugger.MonitorItem;
import de.netcomputing.anyj.debugger.RemoteInterpreter;
import de.netcomputing.anyj.debugger.StackframeItem;
import de.netcomputing.anyj.debugger.ThreadItem;
import de.netcomputing.anyj.debugger.WatchNode;
import de.netcomputing.anyj.debugger.communication.BreakPoint;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.JListPanel;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.application.services.NCCustomPopupGetter;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.swingx.NCButtonTabbedPane;
import de.netcomputing.util.NCFileUtilities;
import de.netcomputing.util.NCStringUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import jxeplugins.DocumentPosition;
import jxeplugins.IJEBreakpointListener;
import jxeplugins.JEBasicService;
import jxeplugins.JEBatchHostFrame;
import plugins.DebuggerPlugin;

public class DebuggerMainPanel
extends NCPanel
implements WindowListener,
IJEBreakpointListener {
    public static boolean CLASSFILTER = true;
    public static boolean STEPCOUNTFILTER = true;
    static DebuggerMainPanel This;
    NCButtonTabbedPane tabbedPane;
    JCheckBox hideStaticBox;
    JLabel statusLabel;
    JButton continueButton;
    JButton stepButton;
    JButton stepIntoButton;
    JButton stepOutButton;
    NCTreeBean printPanel;
    DebuggerDBLList currentDBLList;
    DebuggerDBLList threadDBLList;
    DebuggerDBLList monitorDBLList;
    DBGEvalPanel evalPanel;
    DBGWatchPanel watchPanel;
    JSplitPane evalSplit;
    JButton addWatchButton;
    JButton remWatchButton;
    NCTreeBean watchList;
    JListPanel breakPointsList;
    JButton removeBPBtn;
    JButton clearAllBPBtn;
    JButton remEvalButton;
    JButton clearEvalBtn;
    NCTreeBean evalTree;
    NCTreeBean threadList;
    NCTreeBean stackList;
    NCTreeBean localList;
    NCTreeBean thisList;
    NCTreeBean monitorList;
    NCTreeBean monitorStackList;
    Process proc;
    VirtualMachine machine;
    Hashtable classMap = new Hashtable(1000);
    Hashtable breakPoints = new Hashtable(100);
    Hashtable bpLocToJSP = new Hashtable(100);
    HashSet jspClasses = new HashSet(100);
    ThreadReference currentDebugThread;
    Location currentLoc = null;
    Thread errSuck;
    Thread outSuck;
    TextDocument runToCursorDoc = null;
    int runToCursorLine = -1;
    int state = 0;
    public static final int STOPPED = 0;
    public static final int RUNNING = 1;
    public static final int STARTING = 5;
    public static final int ATBREAKPOINT = 2;
    public static final int WAITFORSTEP = 3;
    public static final int ATEXCEPTION = 4;
    public static final int BREAKED = 6;
    DebuggerOutputPanel doPanel;
    int lastBPLineNumber = -1;
    String lastBPFile;
    Vector sourcePath = new Vector(10);
    static ClassLoader debuggerClassLoader;
    static Object bootStrap;
    HashSet filterSet = new HashSet(31);
    int threadSel = -1;
    boolean sourceNotFoundMecker = false;
    long classprepareTime = 0L;
    int clcount = 0;
    static /* synthetic */ Class class$java$util$Map;
    static /* synthetic */ Class class$com$sun$jdi$VirtualMachine;

    public static DebuggerMainPanel This() {
        return This;
    }

    public DebuggerMainPanel() {
        This = this;
        this.initGui();
        this.currentDBLList = new DebuggerDBLList();
        this.currentDBLList.setText("Local Variables / This' Variables");
        this.tabbedPane.addTab("Current", "Current Stackframe", (JComponent)this.currentDBLList, NCApplication.GetImage("/images/dbgobject.gif"));
        this.doPanel = new DebuggerOutputPanel(this);
        this.printPanel = this.doPanel.getPrintPanel();
        this.tabbedPane.addTab("DebuggerOutput", "Process Output", (JComponent)this.doPanel, NCApplication.GetImage("batchframe"));
        this.threadDBLList = new DebuggerDBLList();
        this.threadDBLList.setText("Threads / Thread's Stackframe");
        this.tabbedPane.addTab("Threads", "Threads and their StackFrames", (JComponent)this.threadDBLList, NCApplication.GetImage("/images/thread.gif"));
        DebuggerWatchPanel dwPanel = new DebuggerWatchPanel();
        this.evalPanel = dwPanel.getEvalPanel();
        this.watchPanel = dwPanel.getWatchPanel();
        this.evalSplit = dwPanel.getEvalSplit();
        this.tabbedPane.addTab("Watch", "Watch selected variables, Expression Evaluation", (JComponent)dwPanel, NCApplication.GetImage("/images/menus/find.gif"));
        this.monitorDBLList = new DebuggerDBLList();
        this.monitorDBLList.setText("Owned Monitors / Stackframe");
        this.tabbedPane.addTab("Monitors", "Owned Monitors", (JComponent)this.monitorDBLList, NCApplication.GetImage("/images/vapub.gif"));
        DebuggerBreakpointList dbList = new DebuggerBreakpointList(this);
        this.breakPointsList = dbList.getBreakPointsList();
        this.removeBPBtn = dbList.getRemoveBPBtn();
        this.clearAllBPBtn = dbList.getClearAllBPBtn();
        this.tabbedPane.addTab("Breakpoints", "Breakpoint List", (JComponent)dbList, NCApplication.GetImage("/images/flagred.gif"));
        this.pastInitGUI();
        NCCustomPopupGetter popper = new NCCustomPopupGetter(EditApp.ServReg, new String[]{"Step"});
        this.thisList.setPopUpGetter(popper);
        this.watchList.setPopUpGetter(popper);
        this.stackList.setPopUpGetter(popper);
        this.localList.setPopUpGetter(popper);
        NCCustomPopupGetter popperBP = new NCCustomPopupGetter(EditApp.ServReg, new String[]{"Debug"});
        this.breakPointsList.setPopUpGetter(popperBP);
        this.tabbedPane.setSelectedIndex(0);
        this.tabbedPane.doLayout();
    }

    public void refreshFonts() {
        this.printPanel.setFont(JXEOptions.StyleTable[0].font);
        this.printPanel.repaint();
    }

    public NCButtonTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public int getEditorMark(int line, String file2) {
        if (this.getState() != 2) {
            return 0;
        }
        if (this.lastBPLineNumber == line && file2.equals(this.lastBPFile)) {
            return 2;
        }
        return 0;
    }

    public String redefineClasses(Map clazzNameToAbsFile) {
        HashMap tmpTab = new HashMap(clazzNameToAbsFile.size());
        if (this.getState() == 0 || this.machine == null) {
            return null;
        }
        try {
            Iterator it = clazzNameToAbsFile.keySet().iterator();
            while (it.hasNext()) {
                String clz = (String)it.next();
                List l = this.machine.classesByName(clz);
                if (l == null || l.size() <= 0) continue;
                System.out.println("REDEF:" + clz);
                System.out.println("REFTYPE LIST SIZE:" + l.size());
                File f = new File((String)clazzNameToAbsFile.get(clz));
                byte[] b = NCFileUtilities.GetFileBytes(f);
                tmpTab.put(l.get(0), b);
            }
            Class[] types = new Class[]{class$java$util$Map == null ? (class$java$util$Map = DebuggerMainPanel.class$("java.util.Map")) : class$java$util$Map};
            Method m = (class$com$sun$jdi$VirtualMachine == null ? (class$com$sun$jdi$VirtualMachine = DebuggerMainPanel.class$("com.sun.jdi.VirtualMachine")) : class$com$sun$jdi$VirtualMachine).getMethod("redefineClasses", types);
            m.invoke((Object)this.machine, tmpTab);
            DebuggerPlugin.This().redefineAllBreakpoints();
        }
        catch (Throwable ex) {
            if (ex instanceof InvocationTargetException) {
                ex = ((InvocationTargetException)ex).getTargetException();
            }
            ex.printStackTrace(Tracer.This);
            return ex.getClass().getName() + ":" + ex.getMessage();
        }
        return null;
    }

    public DebuggerItem getDebugItem(String var) {
        Vector v = this.localList.getList();
        int n = 0;
        while (n < v.size()) {
            if (v.elementAt(n) instanceof DebuggerItem && ((DebuggerItem)v.elementAt(n)).getDepth() == 1 && ((DebuggerItem)v.elementAt(n)).getVarName().equals(var)) {
                return (DebuggerItem)v.elementAt(n);
            }
            ++n;
        }
        v = this.thisList.getList();
        int n2 = 0;
        while (n2 < v.size()) {
            if (v.elementAt(n2) instanceof DebuggerItem && ((DebuggerItem)v.elementAt(n2)).getDepth() == 1 && ((DebuggerItem)v.elementAt(n2)).getVarName().equals(var)) {
                return (DebuggerItem)v.elementAt(n2);
            }
            ++n2;
        }
        return null;
    }

    public String evaluateVar(String var) {
        Vector v = this.localList.getList();
        int n = 0;
        while (n < v.size()) {
            if (v.elementAt(n) instanceof DebuggerItem && ((DebuggerItem)v.elementAt(n)).getDepth() == 1 && ((DebuggerItem)v.elementAt(n)).getVarName().equals(var)) {
                return ((DebuggerItem)v.elementAt(n)).getDisplayString();
            }
            ++n;
        }
        v = this.thisList.getList();
        int n2 = 0;
        while (n2 < v.size()) {
            if (v.elementAt(n2) instanceof DebuggerItem && ((DebuggerItem)v.elementAt(n2)).getDepth() == 1 && ((DebuggerItem)v.elementAt(n2)).getVarName().equals(var)) {
                return ((DebuggerItem)v.elementAt(n2)).getDisplayString();
            }
            ++n2;
        }
        return null;
    }

    public void initGui() {
        new DebuggerMainPanelGUI().createGui(this);
    }

    public void pastInitGUI() {
        this.tabbedPane.remove(this.evalPanel);
        this.tabbedPane.remove(this.watchPanel);
        EditApp.AdjustSplitPane(this.evalSplit);
        this.evalSplit.setLeftComponent(this.watchPanel);
        this.evalSplit.setRightComponent(this.evalPanel);
        this.remWatchButton = this.watchPanel.remWatchButton;
        this.addWatchButton = this.watchPanel.addWatchButton;
        this.watchList = this.watchPanel.watchList;
        this.remEvalButton = this.evalPanel.remEvalButton;
        this.clearEvalBtn = this.evalPanel.clearEvalBtn;
        this.evalTree = this.evalPanel.evalTree;
        this.printPanel.setFont(new Font(JXEOptions.Monospaced, 0, JXEOptions.FontSize));
        this.threadList = this.threadDBLList.getLeftList();
        this.stackList = this.threadDBLList.getRightList();
        this.thisList = this.currentDBLList.getRightList();
        this.localList = this.currentDBLList.getLeftList();
        this.monitorList = this.monitorDBLList.getLeftList();
        this.monitorStackList = this.monitorDBLList.getRightList();
        this.threadList.setTree(true);
        this.evalTree.setTree(true);
        this.threadList.binder().addTarget(this, "actionThreadSel");
        this.threadList.binderDoubleClick().addTarget(this, "actionThreadFrameSel");
        this.monitorList.binder().addTarget(this, "actionMonitorThreadSel");
        this.monitorList.binderDoubleClick().addTarget(this, "actionMonitorThreadFrameSel");
        this.threadDBLList.getSplitPane().setDividerLocation(350);
        this.currentDBLList.getSplitPane().setDividerLocation(350);
        this.monitorDBLList.getSplitPane().setDividerLocation(350);
        this.breakPointsList.addTarget(this, "actionBreakPointSel");
        this.breakPointsList.binderDoubleClick().addTarget(this, "actionBreakPointDoubleSel");
        this.removeBPBtn.setEnabled(false);
        JEBasicService ser = new JEBasicService("Step", "Step Over", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state == 2;
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    DebuggerMainPanel.this.stepOver();
                }
                catch (Exception ex) {
                    DebuggerMainPanel.this.processException("Step Over", ex);
                }
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Step Out", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state == 2;
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    DebuggerMainPanel.this.stepOut();
                }
                catch (Exception ex) {
                    DebuggerMainPanel.this.processException("Step Out", ex);
                }
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Show Current Execution Line", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state == 2;
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    DebuggerMainPanel.this.showCurrentExecLine();
                }
                catch (Exception ex) {
                    DebuggerMainPanel.this.processException("Show Current Execution Line", ex);
                }
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Debug", "Show Breakpoint List", 101){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                EditFrame.Host().showCompilePanel(true);
                JEBatchHostFrame.This().showTab("Debugger");
                DebuggerMainPanel.this.tabbedPane.setSelectedTab("BreakPoints");
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Step Into", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state == 2;
            }

            public void doProcess(Object selection, Object selector) {
                try {
                    DebuggerMainPanel.this.stepInto();
                }
                catch (Exception ex) {
                    DebuggerMainPanel.this.processException("Step Into", ex);
                }
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Evaluate in Debugger", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state == 2 && selection instanceof TextDocument && ((TextDocument)selection).hasSelection();
            }

            public void doProcess(Object selection, Object selector) {
                TextDocument doc = (TextDocument)selection;
                RemoteInterpreter ri = RemoteInterpreter.interpreter;
                ri.initRemoteInterpreter(DebuggerMainPanel.this.machine);
                DebuggerMainPanel.this.enableGui(false);
                String old = DebuggerMainPanel.this.statusLabel.getText();
                DebuggerMainPanel.this.statusLabel.setBackground(Color.yellow);
                DebuggerMainPanel.this.statusLabel.setText("Wait for evaluation ..");
                new Thread(this, ri, doc, old){
                    private final /* synthetic */ RemoteInterpreter val$ri;
                    private final /* synthetic */ TextDocument val$doc;
                    private final /* synthetic */ String val$old;
                    private final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$ri = val$ri;
                        this.val$doc = val$doc;
                        this.val$old = val$old;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Loose catch block
                     */
                    public void run() {
                        block11: {
                            block10: {
                                Value res = (Value)this.val$ri.interpretSelection(6.access$000(this.this$1).getAllVars(6.access$000(this.this$1).currentDebugThread.frame(0)), this.val$doc, 6.access$000(this.this$1).currentDebugThread, 6.access$000(this.this$1).machine);
                                String evnam = this.val$doc.getSelectedString();
                                if (evnam.length() > 24) {
                                    evnam = evnam.substring(0, 24) + "..";
                                }
                                if (res == null) {
                                    6.access$000(this.this$1).evalTree.insertItemRepaintingAt(0, new ListItem("Evaluation failed"));
                                    break block10;
                                }
                                6.access$000(this.this$1).evalTree.insertItemRepaintingAt(0, new EvalResultNode("[evaluated '" + evnam + "']", res));
                            }
                            Object var4_4 = null;
                            6.access$000(this.this$1).statusLabel.setBackground(Color.red);
                            6.access$000(this.this$1).statusLabel.setText(this.val$old);
                            6.access$000(this.this$1).enableGui(true);
                            try {
                                6.access$000(this.this$1).tabbedPane.setSelectedTab("Watch");
                                6.access$000(this.this$1).updateState();
                            }
                            catch (Exception ex2) {
                                ex2.printStackTrace();
                            }
                            break block11;
                            {
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    Object var4_5 = null;
                                    6.access$000(this.this$1).statusLabel.setBackground(Color.red);
                                    6.access$000(this.this$1).statusLabel.setText(this.val$old);
                                    6.access$000(this.this$1).enableGui(true);
                                    try {
                                        6.access$000(this.this$1).tabbedPane.setSelectedTab("Watch");
                                        6.access$000(this.this$1).updateState();
                                    }
                                    catch (Exception ex2) {
                                        ex2.printStackTrace();
                                    }
                                }
                            }
                            catch (Throwable throwable) {
                                Object var4_6 = null;
                                6.access$000(this.this$1).statusLabel.setBackground(Color.red);
                                6.access$000(this.this$1).statusLabel.setText(this.val$old);
                                6.access$000(this.this$1).enableGui(true);
                                try {
                                    6.access$000(this.this$1).tabbedPane.setSelectedTab("Watch");
                                    6.access$000(this.this$1).updateState();
                                }
                                catch (Exception ex2) {
                                    ex2.printStackTrace();
                                }
                                throw throwable;
                            }
                        }
                    }
                }.start();
            }

            static /* synthetic */ DebuggerMainPanel access$000(6 x0) {
                return x0.DebuggerMainPanel.this;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Open Collection as Object[]", 101){

            public boolean canProcess(Object selection, Object selector) {
                boolean res = DebuggerMainPanel.this.state == 2 && (selection instanceof DebuggerItem || selection instanceof TextDocument && ((TextDocument)selection).hasSelection());
                return DebuggerMainPanel.this.state == 2 && (selection instanceof DebuggerItem || selection instanceof TextDocument && ((TextDocument)selection).hasSelection());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void doProcess(Object selection, Object selector) {
                try {
                    block18: {
                        block19: {
                            val = null;
                            ri = RemoteInterpreter.interpreter;
                            ri.initRemoteInterpreter(DebuggerMainPanel.this.machine);
                            if (selection instanceof TextDocument) {
                                doc = (TextDocument)selection;
                                val = (Value)DebuggerMainPanel.this.getAllVars(DebuggerMainPanel.this.currentDebugThread.frame(0)).get(((TextDocument)selection).getSelectedString());
                            } else if (selection instanceof DebuggerItem) {
                                val = ((DebuggerItem)selection).getValue();
                            }
                            if (val == null) break block18;
                            res = (Value)ri.getCollectionView(val, DebuggerMainPanel.this.currentDebugThread);
                            if (res != null) break block19;
                            Confirm.ModalMsg("Could not Evaluate", "Please select a valid varname [subtype of Collection!]");
                            var8_7 = null;
                            ** GOTO lbl59
                        }
                        evnam = "failure";
                        if (selection instanceof TextDocument) {
                            evnam = ((TextDocument)selection).getSelectedString();
                        } else if (selection instanceof DebuggerItem) {
                            evnam = ((DebuggerItem)selection).getVarName();
                        }
                        if (evnam.length() > 12) {
                            evnam = evnam.substring(0, 12) + "..";
                        }
                        DebuggerMainPanel.this.evalTree.insertItemRepaintingAt(0, new EvalResultNode("[as Object[] '" + evnam + "']", res));
                        ** GOTO lbl76
                    }
                    Confirm.ModalMsg("Could not Evaluate", "Please select a valid varname [subtype of Collection!]");
                    ** GOTO lbl67
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    var8_10 = null;
                    try {
                        DebuggerMainPanel.this.tabbedPane.setSelectedTab("Watch");
                        DebuggerMainPanel.this.updateState();
                        DebuggerMainPanel.this.enableGui(true);
                        return;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        return;
                    }
                }
                {
                    catch (Throwable var7_18) {
                        var8_11 = null;
                        ** try [egrp 2[TRYBLOCK] [6 : 287->317)] { 
lbl52:
                        // 1 sources

                        DebuggerMainPanel.this.tabbedPane.setSelectedTab("Watch");
                        DebuggerMainPanel.this.updateState();
                        DebuggerMainPanel.this.enableGui(true);
                        throw var7_18;
lbl56:
                        // 1 sources

                        catch (Exception ex) {
                            ex.printStackTrace();
                        }
                        throw var7_18;
                    }
lbl59:
                    // 1 sources

                    ** try [egrp 2[TRYBLOCK] [6 : 287->317)] { 
lbl60:
                    // 1 sources

                    DebuggerMainPanel.this.tabbedPane.setSelectedTab("Watch");
                    DebuggerMainPanel.this.updateState();
                    DebuggerMainPanel.this.enableGui(true);
                    return;
lbl64:
                    // 1 sources

                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
lbl67:
                    // 1 sources

                    var8_8 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 287->317)] { 
lbl69:
                    // 1 sources

                    DebuggerMainPanel.this.tabbedPane.setSelectedTab("Watch");
                    DebuggerMainPanel.this.updateState();
                    DebuggerMainPanel.this.enableGui(true);
                    return;
lbl73:
                    // 1 sources

                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    return;
lbl76:
                    // 1 sources

                    var8_9 = null;
                    try {}
                    catch (Exception ex) {}
                    ex.printStackTrace();
                    return;
                    DebuggerMainPanel.this.tabbedPane.setSelectedTab("Watch");
                    DebuggerMainPanel.this.updateState();
                    DebuggerMainPanel.this.enableGui(true);
                    return;
                }
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Debug", "Stop Debugging", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state != 0;
            }

            public void doProcess(Object selection, Object selector) {
                DebuggerMainPanel.this.stopDebugger();
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Break", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state == 1;
            }

            public void doProcess(Object selection, Object selector) {
                DebuggerMainPanel.this.breakDebugger();
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Run To Caret", 101){

            public boolean canProcess(Object selection, Object selector) {
                return DebuggerMainPanel.this.state == 2 && selection instanceof TextDocument;
            }

            public void doProcess(Object selection, Object selector) {
                TextDocument doc = (TextDocument)selection;
                DebuggerMainPanel.this.clearRunToCursor();
                DebuggerPlugin.This().setBreakpoint(doc.cY(), doc.getFile(), true);
                DebuggerMainPanel.this.runToCursorLine = doc.cY();
                DebuggerMainPanel.this.runToCursorDoc = doc;
                DebuggerMainPanel.this.continueExecution();
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        ser = new JEBasicService("Step", "Add Watch", 101){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof String;
            }

            public void doProcess(Object selection, Object selector) {
                JEBatchHostFrame.This().addPanel("Debugger", DebuggerMainPanel.this, true, NCApplication.GetImage("/images/menus/Debug (Continue).gif"));
                JEBatchHostFrame.This().showTab("Debugger");
                DebuggerMainPanel.this.tabbedPane.setSelectedTab("Watch");
                DebuggerMainPanel.this.watchList.addItemRepainting(new WatchNode((String)selection));
            }

            public boolean isDynamic() {
                return true;
            }
        };
        EditApp.ServReg.addService(ser);
        this.watchList.binder().addTarget(this, "actionWatchListSel");
        this.evalTree.binder().addTarget(this, "actionEvalListSel");
        this.actionWatchListSel(null, null);
        this.actionEvalListSel(null, null);
        this.printPanel.binder().addTarget(this, "actionOutputClick");
        this.evalTree.setPopUpGetter(EditApp.ServReg);
        this.localList.setPopUpGetter(EditApp.ServReg);
        this.monitorStackList.setPopUpGetter(EditApp.ServReg);
        this.stackList.setPopUpGetter(EditApp.ServReg);
        this.thisList.setPopUpGetter(EditApp.ServReg);
        this.watchList.setPopUpGetter(EditApp.ServReg);
    }

    public int getState() {
        return this.state;
    }

    public Object actionOutputClick(Object sen, Object arg) {
        Object s = this.printPanel.getSelectedObject();
        if (s == null) {
            return null;
        }
        DocumentPosition dp = DocumentPosition.ExtractFromStackTrace(EditApp.App, s.toString(), 0, File.separator);
        if (dp != null) {
            --dp.line;
            --dp.lineEnd;
            dp.path = EditApp.App.normalizePath(dp.path);
            EditApp.App.openEditorOrShow(dp);
        }
        return null;
    }

    void clearRunToCursor() {
        if (this.runToCursorDoc != null) {
            DebuggerPlugin.This().setBreakpoint(this.runToCursorLine, this.runToCursorDoc.getFile(), false);
            this.runToCursorDoc = null;
        }
    }

    public void breakDebugger() {
        try {
            this.machine.suspend();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.setState(6);
        try {
            this.currentDebugThread = null;
            this.updateState();
        }
        catch (Exception ex) {
            this.processException("suspend", ex);
        }
    }

    public Object actionEvalListSel(Object arg, Object sen) {
        this.remEvalButton.setEnabled(this.evalTree.getSelectedItem() != null && this.evalTree.getSelectedItem().getDepth() == 1);
        return null;
    }

    public Object actionWatchListSel(Object arg, Object sen) {
        this.remWatchButton.setEnabled(this.watchList.getSelectedItem() != null && this.watchList.getSelectedItem().getDepth() == 1);
        return null;
    }

    public void setSourcePath(String sp) {
        Vector v = NCStringUtilities.SplitSeparatedString(File.pathSeparator, sp);
        this.sourcePath.setSize(0);
        int n = 0;
        while (n < v.size()) {
            this.sourcePath.add(new File(v.elementAt(n).toString()));
            ++n;
        }
    }

    public File locateFile(String packFinamDotJava) {
        return this.locateFile(packFinamDotJava, null);
    }

    public File locateFile(String packFinamDotJava, File[] match) {
        Tracer.This.println("LOCATEFILE:" + packFinamDotJava);
        int n = 0;
        while (n < this.sourcePath.size()) {
            File f = new File((File)this.sourcePath.elementAt(n), packFinamDotJava);
            Tracer.This.println("LOOKUP:" + f.getAbsolutePath());
            Tracer.This.println(f.getAbsolutePath());
            if (f.exists()) {
                if (match != null) {
                    match[0] = (File)this.sourcePath.elementAt(n);
                }
                return f;
            }
            ++n;
        }
        int i = packFinamDotJava.lastIndexOf(File.separatorChar);
        if (i < 0) {
            return null;
        }
        packFinamDotJava = packFinamDotJava.substring(i + 1);
        int n2 = 0;
        while (n2 < this.sourcePath.size()) {
            File f = new File((File)this.sourcePath.elementAt(n2), packFinamDotJava);
            Tracer.This.println("LOOKUP:" + f.getAbsolutePath());
            Tracer.This.println(f.getAbsolutePath());
            if (f.exists()) {
                return f;
            }
            ++n2;
        }
        Tracer.This.println("LOOKUP: FULL SCAN !");
        int n3 = 0;
        while (n3 < this.sourcePath.size()) {
            File f = (File)this.sourcePath.elementAt(n3);
            Vector v = DirIterator.DirContent(f, ".java");
            int ii = 0;
            while (ii < v.size()) {
                File fi = (File)v.get(ii);
                if (packFinamDotJava.equals(fi.getName())) {
                    return fi;
                }
                ++ii;
            }
            ++n3;
        }
        return null;
    }

    void stopThreads() {
        if (this.outSuck != null) {
            this.outSuck.stop();
        }
        if (this.errSuck != null) {
            this.errSuck.stop();
        }
        this.outSuck = null;
        this.errSuck = null;
        this.classMap.clear();
        this.currentDebugThread = null;
        this.currentLoc = null;
        this.machine = null;
        this.proc = null;
    }

    public boolean isStopped() {
        return this.state == 0;
    }

    public void enableGui(boolean b) {
        this.watchList.setEnabled(b);
        this.evalTree.setEnabled(b);
        this.threadList.setEnabled(b);
        this.localList.setEnabled(b);
        this.thisList.setEnabled(b);
        this.stackList.setEnabled(b);
        this.monitorList.setEnabled(b);
        this.monitorStackList.setEnabled(b);
    }

    void clearGUI() {
        Hashtable classMap = new Hashtable(1000);
        Hashtable breakPoints = new Hashtable(100);
        Hashtable bpLocToJSP = new Hashtable(100);
        HashSet jspClasses = new HashSet(100);
        this.evalTree.clear();
        this.threadList.clear();
        this.localList.clear();
        this.thisList.clear();
        this.stackList.clear();
        this.monitorList.clear();
        this.monitorStackList.clear();
        this.updateWatchList();
    }

    void clearBreakHilight() {
        TextDocument doc;
        if (this.lastBPFile != null && (doc = EditApp.App.findOpenFileNamed(this.lastBPFile)) != null) {
            final int finalLine = this.lastBPLineNumber;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    if (EditFrame.Host() instanceof MultiFrameEditorHost) {
                        doc.repaint();
                    } else {
                        doc.repaintLines(finalLine - 1, finalLine + 1);
                    }
                }
            });
        }
    }

    void setState(int newState) {
        switch (newState) {
            case 0: {
                this.clearGUI();
                this.stopThreads();
                this.enableGui(true);
                this.statusLabel.setText("Stopped");
                this.statusLabel.setBackground(this.getBackground());
                this.continueButton.setEnabled(false);
                this.stepButton.setEnabled(false);
                this.stepIntoButton.setEnabled(false);
                this.stepOutButton.setEnabled(false);
                this.clearGUI();
                this.clearBreakHilight();
                break;
            }
            case 1: {
                this.enableGui(false);
                this.statusLabel.setText("Running");
                this.statusLabel.setBackground(Color.green);
                this.continueButton.setEnabled(false);
                this.stepButton.setEnabled(false);
                this.stepIntoButton.setEnabled(false);
                this.stepOutButton.setEnabled(false);
                this.clearBreakHilight();
                break;
            }
            case 5: {
                this.statusLabel.setText("Starting ..");
                this.statusLabel.setBackground(Color.yellow);
                this.continueButton.setEnabled(false);
                this.stepButton.setEnabled(false);
                this.stepIntoButton.setEnabled(false);
                this.stepOutButton.setEnabled(false);
                this.clearBreakHilight();
                break;
            }
            case 6: {
                this.enableGui(true);
                this.statusLabel.setText("Breaked ");
                this.statusLabel.setBackground(Color.red);
                this.continueButton.setEnabled(true);
                this.stepButton.setEnabled(false);
                this.stepIntoButton.setEnabled(false);
                this.stepOutButton.setEnabled(false);
                this.clearBreakHilight();
                break;
            }
            case 2: {
                this.enableGui(true);
                String loc = "missing debug information " + (this.currentLoc != null ? this.currentLoc.declaringType().name() : "");
                try {
                    loc = this.currentLoc != null ? this.currentLoc.sourceName() + ":" + this.currentLoc.lineNumber() + "  " + this.currentLoc.method().name() : "";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.statusLabel.setText("At Breakpoint -- " + loc);
                this.statusLabel.setBackground(Color.red);
                this.continueButton.setEnabled(true);
                this.stepButton.setEnabled(true);
                this.stepIntoButton.setEnabled(true);
                this.stepOutButton.setEnabled(true);
                break;
            }
            case 3: {
                this.enableGui(true);
                this.statusLabel.setText("Wait for step ..");
                this.statusLabel.setBackground(Color.yellow);
                this.continueButton.setEnabled(false);
                this.stepButton.setEnabled(false);
                this.stepIntoButton.setEnabled(false);
                this.stepOutButton.setEnabled(false);
                this.clearBreakHilight();
                break;
            }
            case 4: {
                this.enableGui(true);
                this.statusLabel.setText("At exception");
                this.statusLabel.setBackground(Color.red);
                this.continueButton.setEnabled(true);
                this.stepButton.setEnabled(true);
                this.stepIntoButton.setEnabled(true);
                this.stepOutButton.setEnabled(true);
            }
        }
        this.state = newState;
    }

    public void processException(String hint, Exception ex) {
        if (ex instanceof AbsentInformationException) {
            this.printPanel.addLine("MISSING DEBUG INFO, (Compile using -g):" + ex.getClass().getName() + ":" + ex.getMessage());
        } else {
            this.printPanel.addLine("INTERNAL EXCEPTION " + ex.getClass().getName() + ":" + ex.getMessage());
            this.tabbedPane.setSelectedTab("DebuggerOutput");
            ex.printStackTrace();
        }
    }

    public void resetLoadedClasses() {
        debuggerClassLoader = null;
    }

    public VirtualMachineManager getVMManager() {
        try {
            if (debuggerClassLoader == null) {
                debuggerClassLoader = new DebuggerClassloader(EditApp.App.getLibraryRepository().getLibraryPath("tools"));
                Class<?> dbg = debuggerClassLoader.loadClass("com.sun.jdi.Bootstrap");
                bootStrap = dbg.newInstance();
                Tracer.This.println("boot CLASSLOADER:" + bootStrap.getClass().getClassLoader());
            }
            Method m = bootStrap.getClass().getMethod("virtualMachineManager", new Class[0]);
            return (VirtualMachineManager)m.invoke(bootStrap, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
            return null;
        }
    }

    void dumpProps(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            Object key = iter.next();
            Tracer.This.println(key + " :" + map.get(key) + "  :" + map.get(key) + " : " + map.get(key).getClass().getName());
        }
    }

    public void startDebugProcess(String javaHome, String wdir, String vmoptions, String mainClazz, String mainArgs) {
        this.startDebugProcess(javaHome, wdir, vmoptions, mainClazz, mainArgs, false);
    }

    public void startRemoteDebugProcess(String javaHome, String wdir, String vmoptions, String mainClazz, String mainArgs) {
        this.startDebugProcess(javaHome, wdir, vmoptions, mainClazz, mainArgs, true);
    }

    void startDebugProcess(String javaHome, String wdir, String vmoptions, String mainClazz, String mainArgs, boolean remote) {
        Tracer.This.println(vmoptions + "|" + mainClazz + "|" + mainArgs);
        EditFrame.Host().notifyViewSwitch("Debug");
        this.filterSet.clear();
        String mainLine = mainClazz + " " + mainArgs;
        this.clearRunToCursor();
        this.sourceNotFoundMecker = false;
        if (wdir.trim().length() > 0) {
            vmoptions = vmoptions + " -Duser.dir=" + wdir + " -Dnc.currdir=" + wdir + " -Dnc.dllbase=" + VFile.ResolveName("#staticdata");
        }
        this.stopThreads();
        this.printPanel.clear();
        this.setState(5);
        this.classMap = new Hashtable(500);
        VirtualMachineManager manager = this.getVMManager();
        if (vmoptions.toUpperCase().startsWith("JAVA ")) {
            vmoptions = vmoptions.substring(5);
        }
        if (vmoptions.toUpperCase().startsWith("JAVAW ")) {
            vmoptions = vmoptions.substring(6);
        }
        if (remote) {
            JDialog conDiag = new JDialog(EditApp.App.getMainWindow(), "Debugger Connect", true);
            DebuggerConnect con = new DebuggerConnect();
            conDiag.getContentPane().add(con);
            con.setStartUpData(mainClazz, vmoptions, mainArgs, javaHome);
            con.setConnectors(manager.allConnectors());
            conDiag.pack();
            JWidgetsUtil.CenterWindow(conDiag);
            conDiag.show();
            Connector connector = con.getResult();
            if (connector == null) {
                this.setState(0);
                return;
            }
            Map map = con.getResultMap();
            try {
                if (connector instanceof LaunchingConnector) {
                    this.machine = ((LaunchingConnector)connector).launch(map);
                } else if (connector instanceof AttachingConnector) {
                    this.machine = ((AttachingConnector)connector).attach(map);
                } else if (connector instanceof ListeningConnector) {
                    this.machine = ((ListeningConnector)connector).accept(map);
                }
            }
            catch (Exception ex) {
                this.processException("launch", ex);
                this.setState(0);
                return;
            }
            this.setState(1);
            this.listAllClasses();
            this.machine.resume();
        } else {
            List l = manager.attachingConnectors();
            int n = 0;
            while (n < l.size()) {
                Tracer.This.println("ATTACHING CONNECTOR:        " + l.get(n).getClass().getName());
                this.dumpProps(((Connector)l.get(n)).defaultArguments());
                ++n;
            }
            l = manager.launchingConnectors();
            Connector connector = null;
            int n2 = 0;
            while (n2 < l.size()) {
                if (connector == null && l.get(n2).getClass().getName().indexOf("Raw") < 0) {
                    connector = (LaunchingConnector)l.get(n2);
                }
                Tracer.This.println("CONNECTOR:        " + l.get(n2).getClass().getName());
                this.dumpProps(((Connector)l.get(n2)).defaultArguments());
                ++n2;
            }
            Map map = connector.defaultArguments();
            Connector.StringArgument mainArg = (Connector.StringArgument)map.get("main");
            mainArg.setValue(mainLine);
            Connector.StringArgument optionsArg = (Connector.StringArgument)map.get("options");
            optionsArg.setValue(vmoptions);
            Connector.StringArgument homeArg = (Connector.StringArgument)map.get("home");
            if (javaHome != null) {
                homeArg.setValue(javaHome);
            }
            Connector.BooleanArgument suspend = (Connector.BooleanArgument)map.get("suspend");
            suspend.setValue(true);
            try {
                this.machine = connector.launch(map);
            }
            catch (Exception ex) {
                this.processException("launch", ex);
                return;
            }
        }
        Tracer.This.println(this.machine.description());
        this.machine.eventRequestManager().createThreadStartRequest().enable();
        this.machine.eventRequestManager().createThreadDeathRequest().enable();
        if (!CLASSFILTER) {
            this.machine.eventRequestManager().createClassPrepareRequest().enable();
        } else {
            this.addAllBPFilters();
        }
        new Thread(){

            public void run() {
                try {
                    while (DebuggerMainPanel.this.machine != null) {
                        EventSet evSet = DebuggerMainPanel.this.machine.eventQueue().remove();
                        EventIterator it = evSet.eventIterator();
                        Object e = null;
                        while (it.hasNext()) {
                            Event event = it.nextEvent();
                            Tracer.This.println(event.getClass().getName());
                            if (event instanceof BreakpointEvent) {
                                DebuggerMainPanel.this.handleBreakpointEvent((BreakpointEvent)event);
                                continue;
                            }
                            if (event instanceof StepEvent) {
                                DebuggerMainPanel.this.handleStepEvent((StepEvent)event);
                                continue;
                            }
                            if (event instanceof VMStartEvent) {
                                DebuggerMainPanel.this.clearGUI();
                                DebuggerMainPanel.this.setState(1);
                                DebuggerMainPanel.this.listAllClasses();
                                DebuggerMainPanel.this.machine.resume();
                                continue;
                            }
                            if (event instanceof VMDeathEvent) {
                                DebuggerMainPanel.this.stopDebugger();
                                Thread.currentThread().stop();
                                continue;
                            }
                            if (event instanceof VMDisconnectEvent) {
                                DebuggerMainPanel.this.stopDebugger();
                                Thread.currentThread().stop();
                                continue;
                            }
                            if (event instanceof ClassPrepareEvent) {
                                DebuggerMainPanel.this.handleClassPrepareEvent((ClassPrepareEvent)event);
                                DebuggerMainPanel.this.machine.resume();
                                continue;
                            }
                            DebuggerMainPanel.this.machine.resume();
                        }
                    }
                }
                catch (Exception ex) {
                    DebuggerMainPanel.this.processException("EventLoop", ex);
                }
            }
        }.start();
        this.proc = this.machine.process();
        if (this.proc != null) {
            this.outSuck = new Thread(){

                public void run() {
                    try {
                        StringBuffer actLine = new StringBuffer(200);
                        while (true) {
                            int c;
                            if ((c = DebuggerMainPanel.this.proc.getInputStream().read()) >= 0) {
                                if (c == 10) {
                                    DebuggerMainPanel.this.printPanel.addLine(actLine.toString());
                                    actLine.setLength(0);
                                    continue;
                                }
                                if (c == 9) {
                                    actLine.append("                                     ".substring(0, JXEOptions.INDENT));
                                    continue;
                                }
                                if (c == 13) continue;
                                actLine.append((char)c);
                                continue;
                            }
                            Thread.sleep(50L);
                        }
                    }
                    catch (Exception ex) {
                        DebuggerMainPanel.this.processException("OutputLoop", ex);
                        return;
                    }
                }
            };
            this.outSuck.start();
            this.errSuck = new Thread(){

                public void run() {
                    try {
                        StringBuffer actLine = new StringBuffer(200);
                        while (true) {
                            int c;
                            if ((c = DebuggerMainPanel.this.proc.getErrorStream().read()) >= 0) {
                                if (c == 10) {
                                    DebuggerMainPanel.this.printPanel.addLine(actLine.toString());
                                    actLine.setLength(0);
                                    continue;
                                }
                                if (c == 9) {
                                    actLine.append("                                     ".substring(0, JXEOptions.INDENT));
                                    continue;
                                }
                                if (c == 13) continue;
                                actLine.append((char)c);
                                continue;
                            }
                            Thread.sleep(50L);
                        }
                    }
                    catch (Exception ex) {
                        DebuggerMainPanel.this.processException("ErrLoop", ex);
                        return;
                    }
                }
            };
            this.errSuck.start();
        } else {
            this.printPanel.addLine("No output available (Remote Debugging or missing process handle)");
        }
    }

    void addAllBPFilters() {
        Enumeration it = this.breakPoints.elements();
        while (it.hasMoreElements()) {
            Vector v = (Vector)it.nextElement();
            int n = 0;
            while (n < v.size()) {
                BreakPoint p = (BreakPoint)v.elementAt(n);
                this.addClazzFilter(p);
                ++n;
            }
        }
    }

    void addCLFilterHashed(String filter) {
        if (!CLASSFILTER) {
            return;
        }
        if (this.filterSet.contains(filter)) {
            return;
        }
        Tracer.This.println("############################# addingClassFilter:" + filter);
        this.filterSet.add(filter);
        ClassPrepareRequest clpreq = this.machine.eventRequestManager().createClassPrepareRequest();
        clpreq.addClassFilter(filter);
        clpreq.enable();
    }

    void addClazzFilter(BreakPoint bp) {
        if (this.getState() != 0) {
            if (bp.getClazz().equals("JSP")) {
                this.addCLFilterHashed("org.apache.jsp.*");
                return;
            }
            try {
                String pk = bp.getClazz();
                int i = pk.lastIndexOf(46);
                if (i >= 0) {
                    pk = pk.substring(0, i);
                    JArray arr = SourceBase.This().classDefinitionsIn(bp.getFile());
                    if (arr != null && arr.size() > 0) {
                        int n = 0;
                        while (arr != null && n < arr.size()) {
                            IndexEntry ie = (IndexEntry)arr.at(n);
                            this.addCLFilterHashed(pk + "." + ie.realClassName() + "*");
                            ++n;
                        }
                    } else {
                        pk = pk + ".*";
                        this.addCLFilterHashed(pk);
                    }
                } else {
                    JArray arr = SourceBase.This().classDefinitionsIn(bp.getFile());
                    if (arr != null && arr.size() > 0) {
                        int n = 0;
                        while (arr != null && n < arr.size()) {
                            IndexEntry ie = (IndexEntry)arr.at(n);
                            this.addCLFilterHashed(ie.realClassName() + "*");
                            ++n;
                        }
                    } else {
                        this.addCLFilterHashed(pk + "*");
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.processException("classPrepareEvent", ex);
            }
        }
    }

    public boolean canRedefine() {
        return false;
    }

    public void addBreakPoint(BreakPoint bp) {
        ClassType ct;
        HashSet cls;
        this.addClazzFilter(bp);
        Tracer.This.println("DEBUGGER: BREAKPOINT ADDED:" + bp.getClazz());
        Vector<BreakPoint> v = (Vector<BreakPoint>)this.breakPoints.get(bp.getClazz());
        if (v == null) {
            v = new Vector<BreakPoint>(7);
            this.breakPoints.put(bp.getClazz(), v);
        }
        v.add(bp);
        if (this.getState() != 0) {
            this.listAllClasses();
        }
        if ((cls = (HashSet)this.classMap.get(bp.getClazz())) != null) {
            Tracer.This.println("ITERATING CLASSES:" + cls.size());
            Iterator it = cls.iterator();
            while (it.hasNext()) {
                ct = (ClassType)it.next();
                Tracer.This.println("CHECKING CLASSTYPE:" + ct);
                this.checkForBreakPoint(ct);
            }
        }
        if (bp.getClazz().equals("JSP")) {
            Iterator jspIt = this.jspClasses.iterator();
            while (jspIt.hasNext()) {
                ct = (ClassType)jspIt.next();
                this.checkForJSPBreakPoint(ct);
            }
        }
    }

    public void removeBreakPoint(BreakPoint bp) {
        Tracer.This.println("REMOVING BREAKPOINT:" + bp);
        Vector v = (Vector)this.breakPoints.get(bp.getClazz());
        if (v == null) {
            return;
        }
        v.remove(bp);
        try {
            if (this.machine != null && this.classMap != null) {
                if (bp.getClazz().equals("JSP")) {
                    HashSet<String> bpLocationsToRemove = new HashSet<String>(29);
                    Iterator it = this.bpLocToJSP.keySet().iterator();
                    while (it.hasNext()) {
                        String key = (String)it.next();
                        BreakPoint tbp = (BreakPoint)this.bpLocToJSP.get(key);
                        if (!tbp.equals(bp)) continue;
                        bpLocationsToRemove.add(key);
                    }
                    List bprsOriginal = this.machine.eventRequestManager().breakpointRequests();
                    ArrayList bprs = new ArrayList(bprsOriginal.size());
                    bprs.addAll(bprsOriginal);
                    int n = 0;
                    while (n < bprs.size()) {
                        BreakpointRequest bpr = (BreakpointRequest)bprs.get(n);
                        if (bpLocationsToRemove.contains(bpr.location().declaringType().name() + "#" + bpr.location().lineNumber())) {
                            bpr.disable();
                            this.machine.eventRequestManager().deleteEventRequest(bpr);
                        }
                        ++n;
                    }
                } else {
                    List bprsOriginal = this.machine.eventRequestManager().breakpointRequests();
                    ArrayList bprs = new ArrayList(bprsOriginal.size());
                    bprs.addAll(bprsOriginal);
                    int n = 0;
                    while (n < bprs.size()) {
                        BreakpointRequest bpr = (BreakpointRequest)bprs.get(n);
                        Tracer.This.println("TESTING:" + bpr.location().lineNumber() + " " + bpr.location().declaringType().name());
                        if (bpr.location().lineNumber() == bp.getLine() + 1 && bpr.location().declaringType().name().startsWith(bp.getClazz())) {
                            bpr.disable();
                            this.machine.eventRequestManager().deleteEventRequest(bpr);
                        }
                        ++n;
                    }
                }
            }
        }
        catch (VMDisconnectedException vex) {
            this.stopDebugger();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void putClassType(String majorClassName, ClassType clsTyp) {
        HashSet<ClassType> v = (HashSet<ClassType>)this.classMap.get(majorClassName);
        if (v == null) {
            v = new HashSet<ClassType>(7);
            this.classMap.put(majorClassName, v);
        }
        v.add(clsTyp);
    }

    void mapJSPBreakPointToGenBreakPoint(File source, ClassType clsTyp, String relativeFile) {
        TextDocument doc = new TextDocument(source);
        DocumentStream ds = new DocumentStream(doc, 0, 0);
        StringBuffer curr = new StringBuffer(120);
        while (ds.readJavaToken(curr)) {
            String tok = curr.toString().trim();
            int i = 0;
            if (tok.startsWith("//") && (i = tok.indexOf("begin [file=")) >= 0) {
                String file2 = tok.substring(i + 13, tok.indexOf("\";", i + 16));
                file2 = VFile.StripDoubleSeps(file2, File.separatorChar).toString();
                file2 = file2.replace('/', File.separatorChar);
                while (file2.startsWith(File.separator)) {
                    file2 = file2.substring(1);
                }
                i = tok.indexOf("from=(");
                String line = tok.substring(i + 6, tok.indexOf(44, i + 6));
                i = tok.indexOf("to=(");
                String lineTo = tok.substring(i + 4, tok.indexOf(44, i + 4));
                int liFrom = Integer.parseInt(line);
                int liTo = Integer.parseInt(lineTo);
                System.out.println("JSP File:" + file2 + " " + liFrom + " to " + liTo);
                Vector jspBreakPoints = (Vector)this.breakPoints.get("JSP");
                int n = 0;
                while (jspBreakPoints != null && n < jspBreakPoints.size()) {
                    try {
                        BreakPoint bp = (BreakPoint)jspBreakPoints.elementAt(n);
                        Tracer.This.println("CHECK FILE:" + VFile.NameWithoutExtension(bp.getFile()) + " " + file2.toLowerCase());
                        if (VFile.NameWithoutExtension(bp.getFile().toLowerCase()).equals(VFile.NameWithoutExtension(file2.toLowerCase())) && bp.getLine() >= liFrom && bp.getLine() <= liTo) {
                            int actLine = ds.posY() + 2 + (bp.getLine() - liFrom);
                            if (bp.getEnabled()) {
                                this.setBP(actLine, clsTyp);
                            }
                            if (this.bpLocToJSP.put(clsTyp.name() + "#" + actLine, bp) == null) {
                                this.bpLocToJSP.put(clsTyp.name() + "#" + actLine, bp);
                                Tracer.This.println("PUT JSP BREAKPOINT:" + clsTyp.name() + "#" + actLine + " " + bp);
                            }
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    ++n;
                }
            }
            curr.setLength(0);
        }
    }

    public void checkForJSPBreakPoint(ClassType clsTyp) {
        Tracer.This.println("CHECKFORJSPBREAKPOINT:" + clsTyp.name());
        String clNameDotJava = clsTyp.name();
        if (!clNameDotJava.startsWith("org.apache.jsp.")) {
            return;
        }
        clNameDotJava = clNameDotJava.substring("org.apache.jsp.".length());
        clNameDotJava = clNameDotJava.replace('.', File.separatorChar);
        clNameDotJava = clNameDotJava.replace('/', File.separatorChar) + ".java";
        Tracer.This.println("clNameDotJava:" + clNameDotJava);
        File[] match = new File[]{null};
        File f = null;
        try {
            Tracer.This.println("clNameDotJava getSource:" + clsTyp.sourceName());
            String s = clsTyp.sourceName();
            f = this.locateFile(s, match);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (f == null) {
            f = this.locateFile(clNameDotJava, match);
        }
        if (f == null) {
            int i = clNameDotJava.lastIndexOf(File.separatorChar);
            String pureName = VFile.NameWithExtension(clNameDotJava);
            this.printPanel.addLine("[DEBUGGER] Unable to locate generated JSP-Java file (" + pureName + "). Check SourcePath.");
        }
        if (match[0] != null) {
            try {
                Tracer.This.println("Scanning for JSP position:" + f.getAbsolutePath());
                this.mapJSPBreakPointToGenBreakPoint(f, clsTyp, f.getAbsolutePath().substring(match[0].getAbsolutePath().length()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void checkForBreakPoint(ClassType clsTyp) {
        String sourceName;
        String name = clsTyp.name();
        String majorClazzName = name;
        int i = majorClazzName.indexOf("$");
        if (i >= 0) {
            majorClazzName = majorClazzName.substring(0, i);
        } else {
            sourceName = null;
            try {
                sourceName = clsTyp.sourceName();
            }
            catch (AbsentInformationException ex) {
            }
            catch (Exception ex) {
                ex.printStackTrace(Tracer.This);
            }
            if (sourceName != null) {
                sourceName = sourceName.substring(0, sourceName.length() - 5);
                if (!majorClazzName.endsWith("." + sourceName) && !majorClazzName.equals(sourceName) && (majorClazzName = majorClazzName.substring(0, Math.max(0, majorClazzName.lastIndexOf("."))) + "." + sourceName).charAt(0) == '.') {
                    majorClazzName = majorClazzName.substring(1);
                }
            }
        }
        try {
            sourceName = clsTyp.sourceName();
        }
        catch (AbsentInformationException ex) {
        }
        catch (Exception ex) {
            this.processException("Absent Debug Info", ex);
        }
        this.putClassType(majorClazzName, clsTyp);
        Vector v = (Vector)this.breakPoints.get(majorClazzName);
        if (v != null) {
            int n = 0;
            while (n < v.size()) {
                BreakPoint bp = (BreakPoint)v.elementAt(n);
                try {
                    if (bp.getEnabled()) {
                        this.setBP(bp.getLine() + 1, clsTyp);
                    }
                }
                catch (Exception ex) {
                    this.processException("set breakpoint", ex);
                }
                ++n;
            }
        }
    }

    void setBP(int line, ClassType clsTyp) throws Exception {
        if (!clsTyp.isPrepared()) {
            return;
        }
        try {
            List locations = clsTyp.locationsOfLine(line);
            int nn = 0;
            while (locations != null && nn < locations.size()) {
                this.machine.eventRequestManager().createBreakpointRequest((Location)locations.get(nn)).enable();
                ++nn;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    void step(int type) throws Exception {
        Tracer.This.println("CREATING STEPREQUEST:" + type + " " + -2);
        try {
            StepRequest step = this.machine.eventRequestManager().createStepRequest(this.currentDebugThread, -2, type);
            if (STEPCOUNTFILTER) {
                step.addCountFilter(1);
            }
            step.setSuspendPolicy(2);
            step.enable();
            this.setState(3);
        }
        catch (DuplicateRequestException ex) {
            ex.printStackTrace(Tracer.This);
            this.setState(3);
        }
        this.machine.resume();
    }

    public void stepOver() throws Exception {
        this.step(2);
    }

    public void stepInto() throws Exception {
        this.step(1);
    }

    public void stepOut() throws Exception {
        this.step(3);
    }

    public void continueExecution() {
        this.setState(1);
        this.machine.resume();
    }

    public void handleStepEvent(StepEvent ev) {
        this.clearRunToCursor();
        this.setState(2);
        this.machine.eventRequestManager().deleteEventRequest(ev.request());
        this.currentDebugThread = ev.thread();
        try {
            this.currentLoc = ev.location();
            this.updateState();
        }
        catch (Exception ex) {
            this.processException("handle step event", ex);
        }
    }

    public void handleBreakpointEvent(BreakpointEvent ev) {
        this.clearRunToCursor();
        this.setState(2);
        this.currentDebugThread = ev.thread();
        try {
            this.currentLoc = ev.location();
            this.updateState();
            final BreakPoint bp = (BreakPoint)this.bpLocToJSP.get(ev.location().declaringType().name() + "#" + ev.location().lineNumber());
            if (bp != null) {
                final TextDocument doc = new TextDocument(new File(bp.getFile()));
                EditApp.App.jol.showSecondDoc(doc);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        doc.centerPosition(bp.getLine());
                        doc.setSelection(0, bp.getLine(), 1024, bp.getLine());
                        EditApp.SetLastSelectionProvider(EditApp.App.jol.getSecondEditor());
                    }
                });
            }
        }
        catch (Exception ex) {
            this.processException("handleBreakpointEvent", ex);
        }
    }

    void updateVarList(JListPanel list, StackFrame current) {
        Vector expanded = list.getExpandedNodes(false);
        Vector localsV = list.getList();
        localsV.setSize(0);
        try {
            List vals = current.visibleVariables();
            int n = 0;
            while (n < vals.size()) {
                localsV.addElement(new LocalVarItem((LocalVariable)vals.get(n), current));
                ++n;
            }
        }
        catch (Exception ex) {
            this.processException("expanding list", ex);
        }
        int n = 0;
        while (n < expanded.size()) {
            String s = (String)expanded.get(n);
            int i = list.findString(s);
            if (i != -1) {
                list.expandNodeAt(i);
            }
            ++n;
        }
        list.repaint();
    }

    void showCurrentExecLine() {
        try {
            this.updateState();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public HashMap getAllVars(StackFrame current) {
        HashMap<String, Value> res = new HashMap<String, Value>(20);
        try {
            ObjectReference ref = current.thisObject();
            if (ref != null) {
                res.put("this_internal", ref);
                List fields = ref.referenceType().allFields();
                int n = 0;
                while (n < fields.size()) {
                    res.put(((Field)fields.get(n)).name(), ref.getValue((Field)fields.get(n)));
                    ++n;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            List vals = current.visibleVariables();
            int n = 0;
            while (n < vals.size()) {
                res.put(((LocalVariable)vals.get(n)).name(), current.getValue((LocalVariable)vals.get(n)));
                ++n;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return res;
    }

    public void updateState() throws Exception {
        Tracer.This.println("============================== HALT ====================================");
        List threads = this.machine.allThreads();
        Vector expanded = this.threadList.getExpandedNodes(false);
        Vector threadsV = this.threadList.getList();
        threadsV.setSize(0);
        this.threadSel = -1;
        int n = 0;
        while (n < threads.size()) {
            if (this.currentDebugThread != null && ((ThreadReference)threads.get(n)).name().equals(this.currentDebugThread.name())) {
                threadsV.addElement(new ThreadItem((ThreadReference)threads.get(n)){
                    Image myIm;

                    public Image getImage() {
                        if (this.myIm == null) {
                            this.myIm = NCApplication.GetImage("/images/actthread.gif");
                        }
                        return this.myIm;
                    }
                });
                this.threadSel = n;
            } else {
                threadsV.addElement(new ThreadItem((ThreadReference)threads.get(n)));
            }
            ++n;
        }
        if (this.threadSel != -1 && this.threadSel < this.threadList.listSize()) {
            this.threadList.setSelectionIndex(this.threadSel);
            this.threadList.expandNodeAt(this.threadSel);
        }
        this.threadList.repaint();
        expanded = this.localList.getExpandedNodes(false);
        Vector localsV = this.localList.getList();
        localsV.setSize(0);
        StackFrame current = null;
        if (this.currentDebugThread != null) {
            current = this.currentDebugThread.frame(0);
            try {
                List vals = current.visibleVariables();
                int n2 = 0;
                while (n2 < vals.size()) {
                    localsV.addElement(new LocalVarItem((LocalVariable)vals.get(n2), current));
                    ++n2;
                }
            }
            catch (Exception ex) {
                this.processException("expanding locals", ex);
            }
            int n3 = 0;
            while (n3 < expanded.size()) {
                String s = (String)expanded.get(n3);
                int i = this.localList.findString(s);
                if (i != -1) {
                    this.localList.expandNodeAt(i);
                }
                ++n3;
            }
        }
        this.localList.repaint();
        expanded = this.thisList.getExpandedNodes(false);
        Vector thisV = this.thisList.getList();
        thisV.setSize(0);
        if (this.currentDebugThread != null) {
            try {
                ObjectReference ref = current.thisObject();
                if (ref != null) {
                    IListItem[] cont = DebuggerItem.GetContent(ref);
                    int n4 = 0;
                    while (n4 < cont.length) {
                        thisV.addElement(cont[n4]);
                        ++n4;
                    }
                } else {
                    Tracer.This.println("THIS == NULL");
                }
            }
            catch (Exception ex) {
                this.processException("expanding thislist", ex);
            }
            int n5 = 0;
            while (n5 < expanded.size()) {
                String s = (String)expanded.get(n5);
                int i = this.thisList.findString(s);
                if (i != -1) {
                    this.thisList.expandNodeAt(i);
                }
                ++n5;
            }
        }
        this.thisList.repaint();
        this.updateWatchList();
        this.updateThreads();
        this.updateMonitorList();
        this.updateEvalList();
        if (this.currentDebugThread != null) {
            Location actLocation = this.currentLoc;
            if (actLocation == null) {
                actLocation = current.location();
            }
            this.currentDBLList.setText("Current locals of Thread '" + this.currentDebugThread.name() + "'    -     Current 'this':" + (current.thisObject() == null ? actLocation.sourceName() : current.thisObject().type().name()));
            this.showLocation(actLocation);
        } else {
            this.currentDBLList.setText("No Current Thread (BREAK)'");
        }
    }

    void updateMonitorList() {
        try {
            Vector expanded = this.monitorList.getExpandedNodes(false);
            this.monitorList.clear();
            Hashtable<String, MonitorItem> mon2Node = new Hashtable<String, MonitorItem>(31);
            List threads = this.machine.allThreads();
            int n = 0;
            while (n < threads.size()) {
                try {
                    ThreadReference ref = (ThreadReference)threads.get(n);
                    List locks = ref.ownedMonitors();
                    int nn = 0;
                    while (nn < locks.size()) {
                        String lockString = ((ObjectReference)locks.get(nn)).toString();
                        MonitorItem monItem = (MonitorItem)mon2Node.get(lockString);
                        if (monItem == null) {
                            monItem = new MonitorItem((ObjectReference)locks.get(nn));
                            this.monitorList.addItem(monItem);
                            mon2Node.put(lockString, monItem);
                        }
                        monItem.addThread(ref);
                        ++nn;
                    }
                }
                catch (UnsupportedOperationException ex) {
                    if (this.monitorList.isEnabled()) {
                        this.monitorList.setEnabled(false);
                        this.monitorStackList.setEnabled(false);
                        this.monitorList.setToolTipText("Operation not supported by target VM");
                        this.monitorStackList.setToolTipText("Operation not supported by target VM");
                    }
                }
                catch (Exception ex) {
                    this.processException("monitorlist", ex);
                }
                ++n;
            }
            this.monitorList.sortByString();
            try {
                int n2 = 0;
                while (n2 < expanded.size()) {
                    String s = (String)expanded.get(n2);
                    int i = this.monitorList.findString(s);
                    if (i != -1) {
                        this.monitorList.expandNodeAt(i);
                    }
                    ++n2;
                }
            }
            catch (Exception ex) {
                this.processException("expanding thislist", ex);
            }
            this.monitorList.repaint();
            this.updateMonitorThreadFrames();
        }
        catch (Exception ex1) {
            this.processException("updateMonitorList()", ex1);
        }
    }

    void updateWatchList() {
        Vector expanded = this.watchList.getExpandedNodes(false);
        int n = 0;
        while (n < this.watchList.listSize()) {
            if (this.watchList.at(n).getDepth() > 1) {
                this.watchList.remWithSelectionAt(n);
                --n;
            }
            ++n;
        }
        try {
            int n2 = 0;
            while (n2 < expanded.size()) {
                String s = (String)expanded.get(n2);
                int i = this.watchList.findString(s);
                if (i != -1) {
                    this.watchList.expandNodeAt(i);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            this.processException("expanding thislist", ex);
        }
        this.watchList.repaint();
    }

    void updateEvalList() {
        Vector expanded = this.evalTree.getExpandedNodes(false);
        int n = 0;
        while (n < this.evalTree.listSize()) {
            if (this.evalTree.at(n).getDepth() > 1) {
                this.evalTree.remWithSelectionAt(n);
                --n;
            }
            ++n;
        }
        try {
            int n2 = 0;
            while (n2 < expanded.size()) {
                String s = (String)expanded.get(n2);
                int i = this.evalTree.findString(s);
                if (i != -1) {
                    this.evalTree.expandNodeAt(i);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            this.processException("expanding thislist", ex);
        }
        this.evalTree.repaint();
    }

    void showLocation(Location actLocation) throws Exception {
        String finam = null;
        try {
            finam = actLocation.declaringType().sourceName();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        String clazz = "";
        if (finam == null || finam.length() == 0) {
            clazz = actLocation.declaringType().name();
        } else {
            clazz = actLocation.declaringType().name().substring(0, Math.max(0, actLocation.declaringType().name().lastIndexOf("."))) + "." + finam.substring(0, finam.length() - 5);
            if (clazz.charAt(0) == '.') {
                clazz = clazz.substring(1);
            }
            Tracer.This.println("LOOKUP BP:" + clazz);
        }
        String pack = clazz.substring(0, Math.max(0, clazz.lastIndexOf(".")));
        String file2 = pack.replace('.', File.separatorChar) + File.separator + actLocation.sourceName();
        int line = actLocation.lineNumber();
        Tracer.This.println("LINE:" + line);
        File f = this.locateFile(file2);
        if (f != null) {
            this.lastBPFile = f.getAbsolutePath();
            this.lastBPLineNumber = line - 1;
            EditApp.App.openEditorOrShow(f.getAbsolutePath());
            final TextDocument doc = EditApp.App.findOpenFileNamed(f.getAbsolutePath());
            if (doc != null) {
                final int finalLine = line;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (EditFrame.Host() instanceof MultiFrameEditorHost) {
                            doc.repaint();
                        } else {
                            doc.repaintLines(finalLine - 1, finalLine + 1);
                        }
                        doc.centerPosition(finalLine - 1);
                    }
                });
            } else {
                Tracer.This.println("COULD NOT FIND DOCUMENT:" + f.getAbsolutePath());
            }
        } else {
            if (!this.sourceNotFoundMecker) {
                Confirm.ModalMsg((Window)this.getTopLevelAncestor(), "Source not found", new String[]{"The file " + file2 + " could not be located", "Please check the Sourcepath setting in", "'Workspace|Preference,Debug & Run'"});
                this.sourceNotFoundMecker = true;
            }
            Tracer.This.println("FILE NOT FOUND == null :" + file2);
        }
    }

    public void updateThreads() {
        if (this.threadList.getSelectedItem() instanceof StackframeItem) {
            StackframeItem it = (StackframeItem)this.threadList.getSelectedItem();
            if (it == null) {
                this.stackList.clear();
                this.stackList.repaint();
                return;
            }
            this.updateVarList(this.stackList, it.frame);
        } else {
            this.stackList.clear();
        }
        this.stackList.repaint();
    }

    public void updateMonitorThreadFrames() {
        if (this.monitorList.getSelectedItem() instanceof StackframeItem) {
            StackframeItem it = (StackframeItem)this.monitorList.getSelectedItem();
            if (it == null) {
                this.monitorStackList.clear();
                this.monitorStackList.repaint();
                return;
            }
            this.updateVarList(this.monitorStackList, it.frame);
        } else {
            this.monitorStackList.clear();
        }
        this.monitorStackList.repaint();
    }

    public Object actionThreadFrameSel(Object arg, Object sen) {
        StackframeItem it;
        if (this.threadList.getSelectedItem() instanceof StackframeItem && (it = (StackframeItem)this.threadList.getSelectedItem()) != null) {
            StackFrame fr = it.frame;
            try {
                this.showLocation(fr.location());
            }
            catch (Exception ex) {
                this.processException("stackframesel", ex);
            }
        }
        return null;
    }

    public Object actionMonitorThreadFrameSel(Object arg, Object sen) {
        StackframeItem it;
        if (this.monitorList.getSelectedItem() instanceof StackframeItem && (it = (StackframeItem)this.monitorList.getSelectedItem()) != null) {
            StackFrame fr = it.frame;
            try {
                this.showLocation(fr.location());
            }
            catch (Exception ex) {
                this.processException("stackframesel", ex);
            }
        }
        return null;
    }

    public Object actionThreadSel(Object arg, Object sen) {
        this.updateThreads();
        return null;
    }

    public Object actionMonitorThreadSel(Object arg, Object sen) {
        this.updateMonitorThreadFrames();
        return null;
    }

    void checkClassForBP(ClassType ct) {
        if (ct.name().endsWith("$jsp")) {
            this.checkForJSPBreakPoint(ct);
            this.jspClasses.add(ct);
        }
        this.checkForBreakPoint(ct);
    }

    public void handleClassPrepareEvent(ClassPrepareEvent ev) {
        Tracer.This.println("######################### CLASSPREP:" + ev.referenceType().name());
        long tim = System.currentTimeMillis();
        try {
            if (ev.referenceType() instanceof ClassType) {
                this.checkClassForBP((ClassType)ev.referenceType());
            }
        }
        catch (Exception ex) {
            this.processException("handleClassPrepareEvent", ex);
        }
        this.classprepareTime += System.currentTimeMillis() - tim;
        ++this.clcount;
        if (this.clcount % 100 == 0) {
            Tracer.This.println("ACCUMULATED CLASSPREPARE:" + this.classprepareTime + " classes:" + this.clcount);
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void listAllClasses() {
        List l = this.machine.allClasses();
        Tracer.This.println("------------------------- loaded classes");
        int n = 0;
        while (n < l.size()) {
            ReferenceType act = (ReferenceType)l.get(n);
            if (act instanceof ClassType) {
                this.checkForBreakPoint((ClassType)act);
            }
            ++n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopDebugger() {
        if (this.getState() != 0) {
            EditFrame.Host().notifyViewSwitch("Edit");
        }
        try {
            block6: {
                try {
                    this.clearRunToCursor();
                    if (this.proc != null) {
                        this.proc.destroy();
                    }
                    if (this.machine == null) break block6;
                    this.machine.exit(0);
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                    Object var3_2 = null;
                    this.classMap.clear();
                    this.proc = null;
                    this.bpLocToJSP = new Hashtable(101);
                    this.jspClasses = new HashSet(101);
                    EditApp.App.jol.hideSecondDoc();
                }
            }
            Object var3_1 = null;
            this.classMap.clear();
            this.proc = null;
            this.bpLocToJSP = new Hashtable(101);
            this.jspClasses = new HashSet(101);
            EditApp.App.jol.hideSecondDoc();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.classMap.clear();
            this.proc = null;
            this.bpLocToJSP = new Hashtable(101);
            this.jspClasses = new HashSet(101);
            EditApp.App.jol.hideSecondDoc();
            throw throwable;
        }
        this.setState(0);
        EditApp.App.getMainWindow().repaint();
        this.lastBPLineNumber = -1;
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public boolean showStatics() {
        return !this.hideStaticBox.isSelected();
    }

    public void clearAllBPBtn_actionPerformed(ActionEvent var0) {
        int timeout = 0;
        while (this.breakPointsList.getList().size() != 0 && timeout < 20) {
            Enumeration en = this.breakPointsList.getList().elements();
            while (en.hasMoreElements()) {
                BreakPoint bp = (BreakPoint)en.nextElement();
                DebuggerPlugin.This().setBreakpoint(bp.getLine(), new File(bp.getFile()), false);
            }
            ++timeout;
        }
        EditFrame.Host().refreshDocumentFonts();
    }

    public void removeBPBtn_actionPerformed(ActionEvent var0) {
        BreakPoint bp = (BreakPoint)this.breakPointsList.getSelectedItem();
        if (bp != null) {
            DebuggerPlugin.This().setBreakpoint(bp.getLine(), new File(bp.getFile()), false);
        }
        EditFrame.Host().refreshDocumentFonts();
    }

    public Object actionBreakPointSel(Object sen, Object arg) {
        this.removeBPBtn.setEnabled(this.breakPointsList.getSelectedItem() != null);
        return null;
    }

    public Object actionBreakPointDoubleSel(Object sen, Object arg) {
        BreakPoint bp = (BreakPoint)this.breakPointsList.getSelectedItem();
        EditApp.App.openEditorOrShow(new DocumentPosition(bp.getFile(), bp.getLine(), 0, 0));
        return null;
    }

    public void notifyBreakpointChanged(int line, File f, boolean enabled) {
        BreakPoint bp = new BreakPoint(line, f);
        int i = this.breakPointsList.getList().indexOf(bp);
        if (i >= 0) {
            BreakPoint bp1 = (BreakPoint)this.breakPointsList.getList().get(i);
            bp1.setEnabled(enabled);
            this.breakPointsList.repaintStartingAt(i, 2);
        }
        if (enabled) {
            this.addBreakPoint(bp);
        } else {
            this.removeBreakPoint(bp);
        }
    }

    public void notifyBreakpointAdded(int line, File f) {
        BreakPoint bp = new BreakPoint(line, f);
        if (!this.breakPointsList.getList().contains(bp)) {
            this.breakPointsList.addItemRepainting(bp);
        }
    }

    public void notifyBreakpointRemoved(int line, File f) {
        Tracer.This.println("AJRunDebug BREAKPOINT REMOVED:" + f + "," + line);
        BreakPoint bp = new BreakPoint(line, f);
        while (this.breakPointsList.getList().contains(bp)) {
            this.breakPointsList.removeItem(bp);
        }
        this.breakPointsList.repaint();
    }

    public void clearBtn_actionPerformed(ActionEvent var0) {
        this.printPanel.clear();
    }

    public void openBtn_actionPerformed(ActionEvent var0) {
        try {
            int cnt = (int)(Math.random() * 500.0);
            PrintStream out = new PrintStream(new FileOutputStream(new VFile("#process/outtmp" + cnt + ".txt")));
            Vector v = this.printPanel.getList();
            int n = 0;
            while (n < v.size()) {
                out.println(((BasicListItem)v.elementAt(n)).getDisplayString());
                ++n;
            }
            out.close();
            EditApp.App.openEditorOrShow(new VFile("#process/outtmp" + cnt + ".txt").getAbsolutePath());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void evalEvalBtn_actionPerformed(ActionEvent var0) {
    }

    public void clearEvalBtn_actionPerformed(ActionEvent var0) {
        this.evalTree.clear();
    }

    public void remEvalButton_actionPerformed(ActionEvent var0) {
        int i = this.evalTree.getSelectionIndex();
        if (i >= 0) {
            this.evalTree.remSelection();
            while (i < this.evalTree.listSize() && this.evalTree.at(i).getDepth() != 1) {
                this.evalTree.remSelection();
            }
        }
    }

    public void tabbedPane_stateChanged(ChangeEvent var0) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DebuggerMainPanel.this.tabbedPane.repaint();
            }
        });
    }

    public void remWatchButton_actionPerformed(ActionEvent var0) {
        int i = this.watchList.getSelectionIndex();
        if (i >= 0) {
            this.watchList.remSelection();
            while (i < this.watchList.listSize() && this.watchList.at(i).getDepth() != 1) {
                this.watchList.remSelection();
            }
        }
    }

    public void addWatchButton_actionPerformed(ActionEvent var0) {
        String s = Confirm.GetText(EditApp.App.getMainWindow(), null, "Add Watch", new String[]{"Enter Variable Name"});
        if (s != null) {
            this.watchList.addItemRepainting(new WatchNode(s));
        }
    }

    public void hideStaticBox_itemStateChanged(ItemEvent var0) {
        try {
            this.updateState();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void continueButton_actionPerformed(ActionEvent var0) {
        this.continueExecution();
    }

    public void stepOutButton_actionPerformed(ActionEvent var0) {
        try {
            this.stepOut();
        }
        catch (Exception ex) {
            this.processException("Step Out", ex);
        }
    }

    public void stepIntoButton_actionPerformed(ActionEvent var0) {
        try {
            this.stepInto();
        }
        catch (Exception ex) {
            this.processException("Step Into", ex);
        }
    }

    public void stepButton_actionPerformed(ActionEvent var0) {
        try {
            this.stepOver();
        }
        catch (Exception ex) {
            this.processException("Step Over", ex);
        }
    }

    public static void main(String[] arg) {
        JFrame frame = new JFrame();
        DebuggerMainPanel panel = new DebuggerMainPanel();
        BreakPoint bp = new BreakPoint(23, new File("D:\\work\\anyj\\debugger\\source\\de\\netcomputing\\anyj\\debugger\\DebugTest.java"));
        panel.addBreakPoint(bp);
        frame.getContentPane().add("Center", panel);
        frame.addWindowListener(panel);
        frame.pack();
        frame.setBounds(0, 0, 700, 550);
        frame.setVisible(true);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

