/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import de.netcomputing.anyj.debugger.DebuggerItem;
import de.netcomputing.anyj.debugger.ThreadItem;
import de.netcomputing.anyj.jwidgets.IListItem;
import java.util.ArrayList;

public class MonitorItem
extends DebuggerItem {
    ObjectReference val;
    ArrayList threads;
    String cachedDisplay;

    public MonitorItem(ObjectReference aVal) {
        this.val = aVal;
        this.threads = new ArrayList(1);
    }

    public String getDisplayString() {
        try {
            if (this.cachedDisplay == null) {
                this.cachedDisplay = this.createDisplayString();
            }
            return this.cachedDisplay;
        }
        catch (Throwable ex) {
            return "invalid";
        }
    }

    public String createDisplayString() {
        try {
            return this.val.toString();
        }
        catch (Exception ex) {
            return "Exc:" + ex.getClass().getName();
        }
    }

    public Value getValue() {
        return this.val;
    }

    public void addThread(ThreadReference ref) {
        this.threads.add(ref);
    }

    public IListItem[] contents() {
        IListItem[] result = new IListItem[this.threads.size()];
        int n = 0;
        while (n < this.threads.size()) {
            result[n] = new ThreadItem((ThreadReference)this.threads.get(n));
            ++n;
        }
        return result;
    }
}

