/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.debugger;

import com.sun.jdi.ThreadReference;
import de.netcomputing.anyj.debugger.StackframeItem;
import de.netcomputing.anyj.jwidgets.BasicListItem;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import java.awt.Image;

public class ThreadItem
extends BasicListItem {
    ThreadReference thread;
    static Image im;
    int d = 1;

    public ThreadItem(ThreadReference ref) {
        this.thread = ref;
    }

    String decodeStatus(int stat) {
        switch (stat) {
            case 5: {
                return "NOT_STARTED";
            }
            case 3: {
                return "MONITOR";
            }
            case 1: {
                return "RUNNING";
            }
            case 2: {
                return "SLEEPING";
            }
            case -1: {
                return "UNKNOWN";
            }
            case 4: {
                return "WAIT";
            }
            case 0: {
                return "ZOMBIE";
            }
        }
        return "undefined";
    }

    public int getDepth() {
        return this.d;
    }

    public void setDepth(int d) {
        this.d = d;
    }

    public String getDisplayString() {
        try {
            return this.thread.name() + " (" + this.decodeStatus(this.thread.status()) + ")";
        }
        catch (Throwable ex) {
            return "invalid";
        }
    }

    public boolean hasContent() {
        return true;
    }

    public IListItem[] contents() {
        try {
            int count = this.thread.frameCount();
            IListItem[] contents = new IListItem[count];
            int n = 0;
            while (n < count) {
                contents[n] = new StackframeItem(this.thread.frame(n));
                ++n;
            }
            return contents;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new IListItem[0];
        }
    }

    public Image getImage() {
        if (im == null) {
            im = NCApplication.GetImage("/images/thread.gif");
        }
        return im;
    }
}

