/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.filenodes;

import JWVFile.VFile;
import de.netcomputing.anyj.jwidgets.IListItem;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import java.util.Hashtable;

public class FileType
implements FilenameFilter {
    public static Hashtable TypeRegistry = new Hashtable(10);
    public static FileType This = new FileType();
    String ending;
    String image;
    boolean isSource;

    public static void RegisterType(FileType f) {
        TypeRegistry.put(f.ending, f);
    }

    public static void UnRegisterType(FileType f) {
        TypeRegistry.remove(f.ending);
    }

    public static Enumeration GetFileTypes() {
        return TypeRegistry.elements();
    }

    public static Enumeration GetFileEndings() {
        return TypeRegistry.keys();
    }

    public static FileType Named(String ending) {
        if (ending == null) {
            return null;
        }
        FileType result = (FileType)TypeRegistry.get(ending);
        if (result == null) {
            result = (FileType)TypeRegistry.get(ending.toUpperCase());
        }
        if (result == null) {
            result = (FileType)TypeRegistry.get(ending.toLowerCase());
        }
        return result;
    }

    public static FileType Of(String path) {
        String ending = VFile.Extension(path);
        if (ending != null) {
            return FileType.Named(ending);
        }
        return null;
    }

    FileType() {
    }

    public FileType(String end, String im) {
        this(end, im, true);
    }

    public FileType(String end, String im, boolean isSource) {
        this.ending = end;
        this.image = im;
        this.isSource = isSource;
        FileType.RegisterType(this);
    }

    public String getExtension() {
        return this.ending.toLowerCase();
    }

    public boolean acceptDir(File dir, String name) {
        return !"CVS".equals(name) && !"cvs".equals(name);
    }

    public boolean accept(File dir, String name) {
        if (name.indexOf(46) < 0) {
            return FileType.Named(name) != null;
        }
        String s = VFile.Extension(name);
        return FileType.Named(s) != null;
    }

    public String getImageName() {
        return this.image == null ? this.getExtension() : this.image;
    }

    public boolean isSource() {
        return this.isSource;
    }

    public boolean hasContent() {
        return false;
    }

    public IListItem[] constructContent(File f) {
        return null;
    }
}

