/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.gui;

import de.netcomputing.anyj.gui.AJEnvTextFieldGUI;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.templates.TemplateEngine;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JComboBox;
import javax.swing.event.DocumentListener;

public class AJEnvTextField
extends NCPanel {
    JComboBox comboBox;
    NCTextField txtField;
    long lastEvent;
    boolean ignoreNext = false;

    public AJEnvTextField() {
        this.initGui();
    }

    public void initGui() {
        new AJEnvTextFieldGUI().createGui(this);
        this.fillCombo();
    }

    public void setEnabled(boolean b) {
        this.fillCombo();
        this.txtField.setEnabled(b);
        this.comboBox.setEnabled(b);
    }

    public void addDocumentListener(DocumentListener tl) {
        this.fillCombo();
        this.txtField.getDocument().addDocumentListener(tl);
    }

    void fillCombo() {
        this.ignoreNext = true;
        if (this.comboBox.getItemCount() <= 0) {
            this.comboBox.removeAllItems();
            if (EditApp.App != null) {
                try {
                    this.comboBox.addItem("Select to insert ..");
                    Hashtable hash = EditApp.App.getTemplateEngine().buildEnvironment(TemplateEngine.CreateContext(new Object()));
                    Enumeration en = hash.keys();
                    while (en.hasMoreElements()) {
                        this.comboBox.addItem("($" + en.nextElement() + ")");
                    }
                    en = EditApp.App.getMergedUserProperties().keys();
                    while (en.hasMoreElements()) {
                        this.comboBox.addItem("($" + en.nextElement() + ")");
                    }
                    this.comboBox.addItem("($Swing)");
                    this.comboBox.addItem("($ServletSDK)");
                    this.comboBox.addItem("($Tools)");
                    this.comboBox.addItem("($SystemClasses)");
                }
                catch (Exception ex) {
                    ex.printStackTrace(Tracer.This);
                }
            }
        }
        if (this.comboBox.getItemCount() > 0) {
            this.comboBox.setSelectedIndex(0);
        }
        this.ignoreNext = false;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void setText(String text) {
        this.fillCombo();
        this.txtField.setText(text);
    }

    public String getText() {
        this.fillCombo();
        return this.txtField.getText();
    }

    public void comboBox_itemStateChanged(ItemEvent var0) {
        if (this.ignoreNext) {
            return;
        }
        if (System.currentTimeMillis() - this.lastEvent > 500L) {
            this.txtField.replaceSelection(this.comboBox.getSelectedItem() + "");
        }
        this.lastEvent = System.currentTimeMillis();
        this.fillCombo();
    }
}

