/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.gui;

import JWVFile.VFile;
import de.netcomputing.anyj.AJDirSelector;
import de.netcomputing.anyj.gui.AJFileSetBeanGUI;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTreeBean;
import de.netcomputing.runtime.ApplicationHelper;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;

public class AJFileSetBean
extends NCPanel {
    NCButton downBtn;
    NCButton upBtn;
    NCButton sortBtn;
    NCTreeBean listPanel;
    NCButton addBtn;
    NCButton remBtn;
    NCButton clearBtn;
    Vector files;
    String label = "";
    String acceptedFiles = "";
    Vector actionListeners = new Vector(3);

    public AJFileSetBean() {
        this.files = new Vector(13);
        this.initGui();
        this.listPanel.binder().addTarget(this, "actionListSel");
        this.setGuiState();
    }

    public void initGui() {
        new AJFileSetBeanGUI().createGui(this);
        this.remBtn.setMnemonic('R');
        this.addBtn.setMnemonic('A');
        this.clearBtn.setMnemonic('C');
        this.sortBtn.setMnemonic('S');
        this.upBtn.setMnemonic('U');
        this.downBtn.setMnemonic('D');
    }

    public Object actionListSel(Object sen, Object arg) {
        this.setGuiState();
        return null;
    }

    public NCButton getRemBtn() {
        return this.remBtn;
    }

    public NCButton getClearBtn() {
        return this.clearBtn;
    }

    public NCButton getAddBtn() {
        return this.addBtn;
    }

    public void addActionListener(ActionListener act) {
        this.actionListeners.addElement(act);
    }

    public void removeActionListener(ActionListener act) {
        this.actionListeners.removeElement(act);
    }

    public void fireActionEvent(String s) {
        ActionEvent ae = new ActionEvent(this, 0, s);
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(ae);
            ++n;
        }
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void setFiles(Vector files) {
        this.files = files;
    }

    public Vector getFiles() {
        return this.files;
    }

    public void valuesFromGUI() {
        this.files.setSize(0);
        int n = 0;
        while (n < this.listPanel.listSize()) {
            this.files.addElement(((ListItem)this.listPanel.at(n)).wrappedObject());
            ++n;
        }
    }

    public void valuesToGUI() {
        this.listPanel.clear();
        int n = 0;
        while (n < this.files.size()) {
            this.listPanel.addItem(new ListItem(this.files.elementAt(n)));
            ++n;
        }
        this.listPanel.repaint();
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public void setAcceptedFiles(String acceptedFiles) {
        this.acceptedFiles = acceptedFiles;
    }

    public String getAcceptedFiles() {
        return this.acceptedFiles;
    }

    public void addFile(File f) {
        if (this.listPanel.indexOfByString(f.getAbsolutePath(), 0) < 0) {
            this.listPanel.addItemRepainting(new ListItem(f));
            this.fireActionEvent(f.getAbsolutePath());
        }
    }

    void setGuiState() {
        int i = this.listPanel.getSelectionIndex();
        this.remBtn.setEnabled(i >= 0);
        this.upBtn.setEnabled(i > 0);
        this.downBtn.setEnabled(i >= 0 && i < this.listPanel.listSize() - 1);
    }

    public void remBtn_actionPerformed(ActionEvent var0) {
        this.listPanel.remSelection();
        this.setGuiState();
    }

    public void addBtn_actionPerformed(ActionEvent var0) {
        File sel;
        String act = VFile.ResolveName("#actproject");
        if (this.listPanel.getSelectedItem() != null) {
            act = ((ListItem)this.listPanel.getSelectedItem()).getDisplayString();
        }
        if ((sel = AJDirSelector.SelectDirModal((Window)this.getFrame(), null, this.getLabel(), null, act, this.getAcceptedFiles())) != null) {
            this.addFile(sel);
        }
        this.setGuiState();
    }

    public void clearBtn_actionPerformed(ActionEvent var0) {
        this.listPanel.clear();
        this.setGuiState();
    }

    public void sortBtn_actionPerformed(ActionEvent var0) {
        this.listPanel.sortByString();
        this.setGuiState();
    }

    public void downBtn_actionPerformed(ActionEvent var0) {
        this.listPanel.moveSelDown();
        this.setGuiState();
    }

    public void upBtn_actionPerformed(ActionEvent var0) {
        this.listPanel.moveSelUp();
        this.setGuiState();
    }

    public NCTreeBean getListPanel() {
        return this.listPanel;
    }
}

