/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class JPopupPanel
extends NCPanel {
    Component pop;
    Component normal;
    boolean isOpen = false;
    NCPanel popPanel;
    PopCanvas btn;
    String label;

    public JPopupPanel(String label, Component popper, Component _normal) {
        this.setLayout(new BorderLayout(0, 0));
        this.pop = (NCPanel)popper;
        this.normal = _normal;
        this.label = label;
        this.popPanel = new NCPanel();
        this.popPanel.setLayout(new BorderLayout(0, 0));
        this.btn = new PopCanvas();
        this.popPanel.add("North", this.btn);
        this.btn.init();
        this.add("North", this.popPanel);
        this.add("Center", this.normal);
        this.btn.binder().addTarget(this, "actionPop");
    }

    public void setOpen(boolean b) {
        if (b != this.isOpen()) {
            this.actionPop(null, null);
        }
    }

    public void init() {
        super.init();
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public Object actionPop(Object arg, Object sender) {
        if (this.isOpen()) {
            this.popPanel.remove(this.pop);
            this.isOpen = false;
            this.btn.repaint();
            this.validate();
        } else {
            this.popPanel.add("Center", this.pop);
            this.isOpen = true;
            this.btn.repaint();
            this.validate();
        }
        return null;
    }

    static {
        NCApplication.PutImage("popArrow", "buttons/arrow8.gif");
    }

    class PopCanvas
    extends NCPanel
    implements MouseListener,
    MouseMotionListener {
        boolean in = false;

        PopCanvas() {
        }

        public void init() {
            super.init();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
            this.setFont(new Font("SansSerif", 0, 10));
        }

        public void mouseMoved(MouseEvent e) {
            if (e.getX() < this.getSize().height && !this.in) {
                this.in = true;
                this.cursorHand();
                this.repaint();
            } else if (e.getX() >= this.getSize().height && this.in) {
                this.in = false;
                this.cursorDefault();
                this.repaint();
            }
        }

        public void mouseDragged(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent e) {
            if (e.getX() < this.getSize().height) {
                JPopupPanel.this.actionPop(null, null);
            }
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
            this.in = false;
            this.cursorDefault();
            this.repaint();
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public Dimension preferredSize() {
            if (this.getFont() != null) {
                return new Dimension(0, this.getFontMetrics(this.getFont()).getHeight());
            }
            return new Dimension(0, 0);
        }

        public void jwPaint(Graphics g) {
            Dimension d = this.getSize();
            g.setColor(JWColor.For("background"));
            g.fillRect(0, 0, d.width, d.height);
            if (JPopupPanel.this.isOpen()) {
                JWidgetsUtil.DrawButton(g, (this.in ? 4 : 0) | 0x20, 2, 0, d.height, d.height);
            } else {
                JWidgetsUtil.DrawButton(g, 1 | (this.in ? 4 : 0) | 0x20, 2, 0, d.height, d.height);
            }
            g.setColor(Color.black);
            int masc = g.getFontMetrics().getMaxAscent();
            g.drawString(JPopupPanel.this.label, 20, masc);
        }
    }
}

