/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.anyj.jwidgets;

import JCollections.JArray;
import de.netcomputing.anyj.jwidgets.JWColor;
import de.netcomputing.anyj.jwidgets.JWMenuBar;
import de.netcomputing.anyj.jwidgets.JWMenuItem;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import netcomputing.collections.NCBinder;

public class NCMenuImageBar
extends JComponent {
    public static Font BBarFont = new Font("SansSerif", 0, 11);
    static int VERSION_TRANS;
    static int VERSION_TRANS_LOW;
    static int gap;
    public JArray items;
    public Image disMask = NCApplication.GetImage("disablemask16");
    int mx = -1;
    int my = -1;
    int imw = 0;
    int imh = 0;
    int selIdx = -1;
    boolean mbutton = false;
    boolean sharedImages = false;
    boolean minimized = false;
    boolean drawBorder = false;
    int sepIndex = -1;
    NCBinder binderMouseEnter = new NCBinder(this);
    NCBinder binderActionDone = new NCBinder(this);
    private Color col1 = new Color(255, 255, 255, 0);
    private Color col2 = new Color(0, 0, 0, 10);
    private Color col3 = new Color(0, 0, 0, VERSION_TRANS);

    public NCMenuImageBar() {
        this.reset();
        this.setToolTipText("");
    }

    public NCBinder binderMouseEnter() {
        return this.binderMouseEnter;
    }

    public NCBinder binderActionDone() {
        return this.binderActionDone;
    }

    public NCMenuImageBar(JArray im, int iw, int ih) {
        this.items = im;
        this.imw = iw + gap;
        this.imh = ih + gap;
    }

    public void setEnabled(boolean enable) {
        int n = 0;
        while (n < this.items.size()) {
            this.setEnabled(n, enable);
            ++n;
        }
    }

    public void setEnabled(int index, boolean enable) {
        this.itemAt(index).setEnabled(enable);
    }

    public String getCurrentTip() {
        if (this.selIdx < 0 || this.selIdx >= this.items.size()) {
            return null;
        }
        String s = this.itemAt(this.selIdx).getDisplayString();
        if ("-".equals(s)) {
            return "Double Click to move/unmove icons to next row";
        }
        if (s.indexOf("::") >= 0) {
            int i = s.indexOf("::");
            s = s.substring(0, i) + " (" + s.substring(i + 2) + ")";
        }
        return s;
    }

    public String getToolTipText(MouseEvent ev) {
        String s = this.getCurrentTip();
        if (s == null || s.length() == 0) {
            return null;
        }
        return s;
    }

    JWMenuItem itemAt(int i) {
        return (JWMenuItem)this.items.at(i);
    }

    public void init() {
        this.addMouseListener(new MyML());
        this.addMouseMotionListener(new MyMML());
    }

    public void setSepIndex(int sepIndex) {
        this.sepIndex = sepIndex;
        this.repaint();
    }

    public int getSepIndex() {
        return this.sepIndex;
    }

    public void select(int mouseX, int mouseY, boolean force) {
        if (!force && this.imw > 0 && this.imh > 0 && (this.mx - gap / 2) / this.imw == (mouseX - gap / 2) / this.imw && (this.my - gap / 2) / this.imh == (mouseY - gap / 2) / this.imh) {
            return;
        }
        if (this.mx >= 0 && this.my >= 0) {
            Rectangle newRect = new Rectangle((this.mx - gap / 2) / this.imw * this.imw, (this.my - gap / 2) / this.imh * this.imh, this.imw, this.imh);
            this.mx = mouseX;
            this.my = mouseY;
            if (mouseX >= 0 && mouseY >= 0) {
                newRect.add(new Rectangle((this.mx - gap / 2) / this.imw * this.imw, (this.my - gap / 2) / this.imh * this.imh, this.imw, this.imh));
            }
        } else if (this.imw > 0 && this.imh > 0) {
            this.mx = mouseX;
            this.my = mouseY;
            Rectangle newRect = new Rectangle((this.mx - gap / 2) / this.imw * this.imw, (this.my - gap / 2) / this.imh * this.imh, this.imw, this.imh);
        }
        this.repaint();
    }

    public void reset() {
        this.items = new JArray(10);
    }

    public void addButton(JWMenuItem item) {
        this.privateAddButton(item);
    }

    void privateAddButton(JWMenuItem item) {
        this.items.add(item);
    }

    public void paint(Graphics g) {
        try {
            Image im;
            Dimension d = this.getSize();
            if (this.items.size() > 0 && (im = this.itemAt(0).getImage()) != null) {
                this.imw = im.getWidth(this) + gap;
                this.imh = im.getHeight(this) + gap;
            }
            if (this.minimized) {
                return;
            }
            int x = 0;
            int y = 0;
            this.selIdx = -1;
            int n = 0;
            while (n < this.items.size() && y * this.imh + gap < d.height) {
                Image im2;
                if ((1 + x) * this.imw + gap > d.width || n == this.sepIndex) {
                    if (this.getHeight() < y * this.imh + gap + this.imh + this.imh / 2) {
                        g.setColor(new Color(255, 255, 255, 128));
                        g.fillRect(this.getWidth() - g.getFontMetrics().stringWidth("more..") - 6, y * this.imh + gap, g.getFontMetrics().stringWidth("more..") + 4, g.getFontMetrics().getHeight());
                        g.setColor(Color.black);
                        g.drawRect(this.getWidth() - g.getFontMetrics().stringWidth("more..") - 6, y * this.imh + gap, g.getFontMetrics().stringWidth("more..") + 4, g.getFontMetrics().getHeight());
                        g.drawString("more..", this.getWidth() - g.getFontMetrics().stringWidth("more..") - 4, y * this.imh + gap + g.getFontMetrics().getMaxAscent());
                    }
                    ++y;
                    x = 0;
                }
                int xpos = x * this.imw + gap;
                int ypos = y * this.imh + gap;
                if (this.mx >= xpos - gap / 2 && this.mx < xpos - gap / 2 + this.imw && this.my >= ypos - gap / 2 && this.my < ypos - gap / 2 + this.imh) {
                    int gh = gap / 2;
                    if (this.itemAt(n).isEnabled()) {
                        im2 = this.itemAt(n).getImage();
                        this.selIdx = n;
                        g.setColor(JWColor.BBARBG);
                        g.fillRect(xpos - gh, ypos - gh, this.imw, this.imh);
                        if (this.mbutton) {
                            ++xpos;
                            ++ypos;
                        }
                        if (im2 != null) {
                            g.drawImage(im2, xpos, ypos, this);
                        }
                        if (this.mbutton) {
                            --xpos;
                            --ypos;
                        }
                        g.setColor(new Color(0, 0, 0, 96));
                        g.drawRect(xpos - gh, ypos - gh, this.imw, this.imh);
                    } else {
                        im2 = this.itemAt(n).getImage();
                        if (im2 != null) {
                            g.drawImage(im2, xpos, ypos, this);
                        }
                        g.drawImage(this.disMask, xpos, ypos, this);
                        this.selIdx = n;
                    }
                } else {
                    im2 = this.itemAt(n).getImage();
                    if (im2 != null) {
                        g.drawImage(im2, xpos, ypos, this);
                    }
                }
                ++x;
                ++n;
            }
            x = 0;
            y = 0;
            int n2 = 0;
            while (n2 < this.items.size() && y * this.imh + gap < d.height) {
                if ((1 + x) * this.imw + gap > d.width || n2 == this.sepIndex) {
                    ++y;
                    x = 0;
                }
                int xpos = x * this.imw + gap;
                int ypos = y * this.imh + gap;
                if (this.mx < xpos - gap / 2 || this.mx >= xpos - gap / 2 + this.imw || this.my < ypos - gap / 2 || this.my < ypos - gap / 2 + this.imh) {
                    // empty if block
                }
                ++x;
                ++n2;
            }
            Graphics2D g2D = (Graphics2D)g;
            g2D = (Graphics2D)g;
            g2D.setColor(this.col3);
            String vS = "AnyJ " + NCApplication.Version;
            if (EditApp.IsPE) {
                g2D.setFont(new Font("SansSerif", 1, 14));
                vS = "*Platinum Edition* " + NCApplication.Version;
            } else {
                g2D.setFont(new Font("SansSerif", 1, 14));
            }
            g2D.drawString(vS, this.getWidth() - g2D.getFontMetrics().stringWidth(vS) - 4, this.getHeight() - g2D.getFontMetrics().getHeight() + g2D.getFontMetrics().getMaxAscent() - 4);
            if (this.drawBorder) {
                JWidgetsUtil.PaintBorder(g, d.width, d.height, false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public void minimize(boolean b) {
        if (this.minimized != b) {
            this.minimized = b;
            this.invalidate();
            this.getParent().invalidate();
            this.getParent().validate();
        }
    }

    /*
     * Unable to fully structure code
     */
    public Dimension preferredSize() {
        if (this.getParent() != null && this.items.size() != 0) ** GOTO lbl11
        return new Dimension(0, 0);
lbl-1000:
        // 1 sources

        {
            this.imw = this.itemAt(0).getImage().getWidth(this);
            this.imh = this.itemAt(0).getImage().getHeight(this);
            if (this.imw != 0 && this.imh != 0) continue;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(Tracer.This);
            }
lbl11:
            // 4 sources

            ** while (this.imw == 0 || this.imh == 0)
        }
lbl12:
        // 1 sources

        result = this.getParent().getSize();
        if (this.minimized) {
            result.height = 8;
            return result;
        }
        if ((result.width + NCMenuImageBar.gap) / this.imw == 0) {
            return result;
        }
        result.height = (this.items.size() - 1) / ((result.width - 2 * NCMenuImageBar.gap) / this.imw) * this.imh + NCMenuImageBar.gap + this.imh;
        result.width = (result.width - 3 * NCMenuImageBar.gap) / this.imw * this.imw;
        return result;
    }

    static {
        NCApplication.PutImage("bbar-background", "defback.gif");
        NCApplication.PutImage("disablemask16", "disable16.gif");
        VERSION_TRANS = 32;
        VERSION_TRANS_LOW = 24;
        gap = 8;
    }

    class MyMML
    extends MouseMotionAdapter {
        MyMML() {
        }

        public void mouseMoved(MouseEvent e) {
            NCMenuImageBar.this.mbutton = false;
            if (e.getX() > NCMenuImageBar.this.getSize().width || e.getY() > NCMenuImageBar.this.getSize().height) {
                NCMenuImageBar.this.select(-1, -1, false);
            } else {
                NCMenuImageBar.this.select(e.getX(), e.getY(), true);
            }
        }
    }

    class MyML
    extends MouseAdapter {
        MyML() {
        }

        public void mousePressed(MouseEvent e) {
            JWMenuBar.ResetMenu();
            NCMenuImageBar.this.mbutton = true;
            if ((e.getID() & 0x10) != 0) {
                NCMenuImageBar.this.select(e.getX(), e.getY(), true);
            }
        }

        public void mouseReleased(MouseEvent e) {
            NCMenuImageBar.this.mbutton = false;
            if (NCMenuImageBar.this.selIdx >= 0 && NCMenuImageBar.this.selIdx < NCMenuImageBar.this.items.size()) {
                if (NCMenuImageBar.this.itemAt(NCMenuImageBar.this.selIdx).isEnabled()) {
                    NCApplication.PerformAction(NCMenuImageBar.this.itemAt(NCMenuImageBar.this.selIdx).getActionTarget(), NCMenuImageBar.this.itemAt(NCMenuImageBar.this.selIdx).getAction(), null, null);
                    NCMenuImageBar.this.binderActionDone().notifyTargets(NCMenuImageBar.this.selIdx);
                } else if (NCMenuImageBar.this.itemAt(NCMenuImageBar.this.selIdx).getDisplayString().equals("-")) {
                    if (e.getClickCount() > 1) {
                        NCMenuImageBar.this.sepIndex = NCMenuImageBar.this.selIdx;
                    }
                } else if (e.getClickCount() > 1) {
                    NCMenuImageBar.this.sepIndex = -1;
                }
            }
            if ((e.getID() & 0x10) != 0) {
                NCMenuImageBar.this.select(e.getX(), e.getY(), true);
            }
        }

        public void mouseEntered(MouseEvent e) {
            NCMenuImageBar.this.col3 = new Color(0, 0, 0, VERSION_TRANS_LOW);
            NCMenuImageBar.this.binderMouseEnter().notifyTargets(null);
            NCMenuImageBar.this.repaint();
        }

        public void mouseExited(MouseEvent e) {
            NCMenuImageBar.this.col3 = new Color(0, 0, 0, VERSION_TRANS);
            NCMenuImageBar.this.mbutton = false;
            NCMenuImageBar.this.select(-1, -1, true);
            NCMenuImageBar.this.repaint();
        }
    }
}

