/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.components;

import Jxe.AttributedTextLine;
import Jxe.IHighlighter;
import Jxe.TextDocument;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCEditor;
import de.netcomputing.cvswrap.components.DiffViewGUI;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.NCFileUtilities;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JTabbedPane;

public class DiffView
extends NCPanel {
    JButton revertBtn;
    JButton prevBtn;
    JButton nextBtn;
    JButton unRevertBtn;
    JButton reDiffBtn;
    JTabbedPane tabbedPane;
    NCEditor editPanel;
    NCEditor editB;
    NCEditor editA;
    TextDocument initA;
    TextDocument initB;

    public DiffView() {
        this.initGui();
    }

    public void initGui() {
        new DiffViewGUI().createGui(this);
        this.nextBtn.setMnemonic('n');
        this.prevBtn.setMnemonic('p');
        this.revertBtn.setEnabled(false);
        this.editA.scrollbarVert().binder().addTarget(this, "actionScrollA");
        this.editB.scrollbarVert().binder().addTarget(this, "actionScrollB");
        this.editPanel.scrollbarVert().binder().addTarget(this, "actionScrollMain");
    }

    public Object actionScrollA(Object arg, Object sen) {
        this.editB.scrollbarVert().setSelection(this.editA.scrollbarVert().getSelection());
        this.editPanel.scrollbarVert().setSelection(this.editA.scrollbarVert().getSelection());
        return null;
    }

    public Object actionScrollB(Object arg, Object sen) {
        this.editA.scrollbarVert().setSelection(this.editB.scrollbarVert().getSelection());
        this.editPanel.scrollbarVert().setSelection(this.editB.scrollbarVert().getSelection());
        return null;
    }

    public Object actionScrollMain(Object arg, Object sen) {
        this.editA.scrollbarVert().setSelection(this.editPanel.scrollbarVert().getSelection());
        this.editB.scrollbarVert().setSelection(this.editPanel.scrollbarVert().getSelection());
        return null;
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    void initSplit() {
        this.editA.getDocument().moveCursorAbs(0, 0);
        this.editA.getDocument().reset();
        this.editB.getDocument().moveCursorAbs(0, 0);
        this.editB.getDocument().reset();
        TextDocument diffDoc = this.editPanel.getDocument();
        TextDocument splitA = diffDoc.createCopy();
        TextDocument splitB = diffDoc.createCopy();
        int i = 0;
        while (i < splitA.size()) {
            if (diffDoc.lineAt(i).getMark() == '\u0002') {
                splitA.setLine(i, new AttributedTextLine(""));
                splitA.lineAt(i).mark('\u0002');
            }
            if (diffDoc.lineAt(i).getMark() == '\u0001') {
                splitA.lineAt(i).mark('\u0001');
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < splitB.size()) {
            if (diffDoc.lineAt(i2).getMark() == '\u0001') {
                splitB.setLine(i2, new AttributedTextLine(""));
                splitB.lineAt(i2).mark('\u0001');
            }
            if (diffDoc.lineAt(i2).getMark() == '\u0002') {
                splitB.lineAt(i2).mark('\u0002');
            }
            ++i2;
        }
        this.editA.setDocument(splitB);
        this.editB.setDocument(splitA);
        IHighlighter hi = this.editPanel.getDocument().getHighlighter();
        this.editA.getDocument().setHighlighter(hi);
        this.editB.getDocument().setHighlighter(hi);
        this.editA.getDocument().highlightAll();
        this.editB.getDocument().highlightAll();
        if (this.initA != null && this.initA.getFile() != null) {
            this.editA.getDocument().setFile(this.initA.getFile());
        }
        if (this.initB != null && this.initB.getFile() != null) {
            this.editB.getDocument().setFile(this.initB.getFile());
        }
        this.editB.getDocument().setReadOnly(true);
        this.editA.getDocument().setReadOnly(true);
    }

    public void revert() {
        TextDocument doc = this.editPanel.getDocument();
        int n = 0;
        while (n < doc.size()) {
            if (doc.lineAt(n).getMark() == '\u0002') {
                doc.remLineWithoutUndoAt(n, true);
                --n;
            }
            ++n;
        }
        this.editPanel.repaint();
    }

    public void unRevert() {
        TextDocument doc = this.editPanel.getDocument();
        int n = 0;
        while (n < doc.size()) {
            if (doc.lineAt(n).getMark() == '\u0001') {
                doc.remLineWithoutUndoAt(n, true);
                --n;
            }
            ++n;
        }
        this.editPanel.repaint();
    }

    public TextDocument getDocument() {
        return this.editPanel.getDocument();
    }

    public void reset() {
        this.enablePrevNext(false);
        this.revertBtn.setEnabled(false);
        this.unRevertBtn.setEnabled(false);
        this.editPanel.getDocument().reset();
        this.editPanel.repaint();
    }

    public void enablePrevNext(boolean b) {
        this.prevBtn.setEnabled(b);
        this.nextBtn.setEnabled(b);
    }

    public void setDocsVisible(boolean b) {
        this.editA.setVisible(b);
        this.editB.setVisible(b);
        this.editPanel.setVisible(b);
        this.tabbedPane.setEnabled(b);
    }

    public void anyjDiff(TextDocument a, TextDocument b) {
        try {
            this.tabbedPane.setSelectedIndex(0);
            this.setDocsVisible(false);
            this.setEnabled(false);
            this.initA = a;
            this.initB = b;
            File fa = NCFileUtilities.GetTmpFile();
            File fb = NCFileUtilities.GetTmpFile();
            a.save(fa);
            b.save(fb);
            Vector diffEntries = TextDocument.DiffExternal(fa, fb);
            this.applyDiffEntries(null, fa, diffEntries, a.getFile());
        }
        catch (Exception ex) {
            Confirm.MsgException(ex);
        }
        this.setEnabled(true);
        this.setDocsVisible(true);
        this.repaint();
    }

    public void applyDiffEntries(Vector oldRev, File rev, Vector v, File hilightGuess) {
        this.reDiffBtn.setVisible(false);
        this.editPanel.getDocument().setReadOnly(false);
        if (rev != null) {
            this.editPanel.getDocument().load(rev);
        } else {
            this.editPanel.getDocument().reset();
            int n = 0;
            while (n < oldRev.size()) {
                this.editPanel.getDocument().addLine((String)oldRev.elementAt(n));
                ++n;
            }
        }
        this.editPanel.getDocument().applyDiffEntries(v);
        if (hilightGuess != null) {
            this.editPanel.getDocument().guessHilighterFrom(hilightGuess.getAbsolutePath());
        } else if (rev != null && rev.getAbsolutePath() != null) {
            this.editPanel.getDocument().guessHilighterFrom(rev.getAbsolutePath());
        }
        this.editPanel.getDocument().highlightAll();
        this.editPanel.getDocument().setReadOnly(true);
        this.editPanel.getDocument().optimizeDiff();
        this.initSplit();
        this.editPanel.repaint();
        this.revertBtn.setEnabled(true);
        this.unRevertBtn.setEnabled(true);
        this.enablePrevNext(true);
    }

    /*
     * Unable to fully structure code
     */
    private void searchDiffEndUp(boolean startOrEnd) {
        block3: {
            doc = this.editPanel.getDocument();
            actline = doc.cY();
            if (doc.size() <= 0) break block3;
            if (actline == 0) {
                actline = Math.max(0, doc.size() - 1);
            }
            li = doc.lineAt(actline);
            if (!startOrEnd) ** GOTO lbl13
            while ((li.getMark() == '\u0001' || li.getMark() == '\u0002') && actline > 0) {
                li = doc.lineAt(--actline);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                li = doc.lineAt(--actline);
lbl13:
                // 2 sources

                ** while (li.getMark() != '\u0001' && li.getMark() != '\u0002' && actline > 0)
            }
        }
        doc.moveCursorAbs(0, actline);
    }

    /*
     * Unable to fully structure code
     */
    private void searchDiffEndDown(boolean startOrEnd) {
        block3: {
            doc = this.editPanel.getDocument();
            actline = doc.cY();
            if (doc.size() <= 0) break block3;
            if (actline >= doc.size() - 1) {
                actline = 0;
            }
            li = doc.lineAt(actline);
            if (!startOrEnd) ** GOTO lbl13
            while ((li.getMark() == '\u0001' || li.getMark() == '\u0002') && actline < doc.size() - 1) {
                li = doc.lineAt(++actline);
            }
            break block3;
lbl-1000:
            // 1 sources

            {
                li = doc.lineAt(++actline);
lbl13:
                // 2 sources

                ** while (li.getMark() != '\u0001' && li.getMark() != '\u0002' && actline < doc.size() - 1)
            }
        }
        doc.moveCursorAbs(0, actline);
    }

    public void reDiffBtn_actionPerformed(ActionEvent var0) {
        this.anyjDiff(this.initA, this.initB);
    }

    public void unRevertBtn_actionPerformed(ActionEvent var0) {
        this.unRevertBtn.setEnabled(false);
        this.revertBtn.setEnabled(false);
        this.unRevert();
    }

    public void revertBtn_actionPerformed(ActionEvent var0) {
        this.unRevertBtn.setEnabled(false);
        this.revertBtn.setEnabled(false);
        this.revert();
    }

    public void prevBtn_actionPerformed(ActionEvent var0) {
        this.searchDiffEndUp(true);
        this.searchDiffEndUp(false);
        this.searchDiffEndUp(true);
    }

    public void nextBtn_actionPerformed(ActionEvent var0) {
        this.searchDiffEndDown(true);
        this.searchDiffEndDown(false);
        this.searchDiffEndDown(true);
    }

    public static void main(String[] args) {
    }
}

