/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.cvswrap.gui;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCButton;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.jwidgets.beans.NCTextField;
import de.netcomputing.cvswrap.commands.CheckoutWrapper;
import de.netcomputing.cvswrap.commands.TagWrapper;
import de.netcomputing.cvswrap.gui.CVSTagGUI;
import de.netcomputing.runtime.ApplicationHelper;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CVSTag
extends NCPanel {
    JLabel reposLabel;
    JComboBox projectsCombo;
    NCButton createBtn;
    JCheckBox branchChk;
    NCTextField nameTxt;
    String repos;

    public CVSTag() {
        this.initGui();
    }

    public void initGui() {
        new CVSTagGUI().createGui(this);
        this.nameTxt.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                CVSTag.this.validateBtns();
            }

            public void removeUpdate(DocumentEvent e) {
                CVSTag.this.validateBtns();
            }

            public void changedUpdate(DocumentEvent e) {
                CVSTag.this.validateBtns();
            }
        });
    }

    void validateBtns() {
        String tname = this.nameTxt.getText().trim();
        if (tname.length() == 0 || tname.indexOf(" ") >= 0 || tname.indexOf("$") >= 0 || tname.indexOf(",") >= 0 || tname.indexOf(".") >= 0 || tname.indexOf(":") >= 0 || tname.indexOf(";") >= 0 || tname.indexOf("@") >= 0) {
            this.createBtn.setEnabled(false);
        } else {
            this.createBtn.setEnabled(true);
        }
    }

    public void reInit() {
        this.branchChk.setSelected(false);
        this.nameTxt.setText("");
        this.setEnabled(true);
        this.createBtn.setEnabled(false);
        System.out.println("reinit done");
    }

    public Image getImageForBuilder(String imageName, String packageAsPath) {
        return ApplicationHelper.Singleton().getImage(this.getClass(), "images/" + imageName);
    }

    public void retrieveProjects(final String repository) {
        this.repos = repository;
        new Thread("RETRIEVE PROJECTS"){

            public void run() {
                CVSTag.this.reposLabel.setText("[Repository " + repository + "]");
                CVSTag.this.projectsCombo.removeAllItems();
                CVSTag.this.projectsCombo.setEnabled(false);
                CVSTag.this.createBtn.setEnabled(false);
                CheckoutWrapper cw = new CheckoutWrapper(repository);
                Vector v = cw.getProjects();
                if (v != null) {
                    int n = 0;
                    while (n < v.size()) {
                        CVSTag.this.projectsCombo.addItem(v.elementAt(n));
                        ++n;
                    }
                }
                CVSTag.this.setEnabled(true);
                CVSTag.this.projectsCombo.setEnabled(true);
                CVSTag.this.validateBtns();
            }
        }.start();
    }

    public void createBtn_actionPerformed(ActionEvent var0) {
        final String tname = this.nameTxt.getText().trim();
        if (tname.length() == 0 || tname.indexOf(" ") >= 0) {
            Confirm.ModalMsg("CVS Tag Error", new String[]{"Invalid tag name."});
            return;
        }
        new Thread("RETRIEVE PROJECTS"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                CVSTag.this.setEnabled(false);
                try {
                    TagWrapper tw = new TagWrapper(CVSTag.this.repos);
                    String res = tw.runTag(CVSTag.this.projectsCombo.getSelectedItem().toString(), tname, true, CVSTag.this.branchChk.isSelected());
                    if (res == null) {
                        Confirm.ModalMsg("CVS Tag Set", new String[]{"Tag set successfully."});
                    } else {
                        Confirm.ModalMsg("CVS Tag Error", new String[]{res});
                    }
                    Object var4_3 = null;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    CVSTag.this.setEnabled(true);
                    ((Window)CVSTag.this.getTopLevelAncestor()).hide();
                    throw throwable;
                }
                CVSTag.this.setEnabled(true);
                ((Window)CVSTag.this.getTopLevelAncestor()).hide();
            }
        }.start();
    }
}

