/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.modeller;

import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.modeller.EntityLayout;
import de.netcomputing.modeller.ModelAssoc;
import de.netcomputing.util.xml.Node;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import layedit.LayoutableComponent;
import layedit.access.NonGuiComponent;
import layedit.swing.BopComponent;

public class ModellerEntity
extends NonGuiComponent {
    protected JList methods;
    protected JList attribs;
    protected DefaultListModel attribsModel;
    protected DefaultListModel methodListModel;
    protected JLabel label;
    static HashMap shapeNameToEntityClass = new HashMap();
    static HashMap shapeToIcon = new HashMap();
    static Insets ins;
    int[] methSel = new int[0];
    int[] attSel = new int[0];
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$CommentEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$ProcessEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$ModellerEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$ImageEntity;
    static /* synthetic */ Class class$de$netcomputing$modeller$entities$DataBaseEntity;

    public static void RegisterEntityClass(String shape, Class clazz) {
        shapeNameToEntityClass.put(shape, clazz);
    }

    public static void RegisterEntityIcon(String shape, String iconClassPath) {
        shapeToIcon.put(shape, iconClassPath);
    }

    public static ModellerEntity createFromSpec(Node n, String initialTitle) {
        try {
            String shape = n.getField("shape", "");
            Class clz = (Class)shapeNameToEntityClass.get(shape);
            if (clz != null) {
                return (ModellerEntity)clz.newInstance();
            }
            return new ModellerEntity();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Confirm.MsgException(ex);
            return null;
        }
    }

    public ModellerEntity() {
        this("");
    }

    public Insets getInsets() {
        return ins;
    }

    public ModellerEntity(String title) {
        this.setLayout(new EntityLayout(0, 0));
        this.setOpaque(true);
        this.methods = new JList();
        this.attribs = new JList();
        this.methods.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ModellerEntity.this.attribs.getSelectionModel().clearSelection();
                ((BopComponent)ModellerEntity.this.getParent()).getParentBop().getControllerBop().binder().notifyTargets(ModellerEntity.this.getParent());
            }
        });
        this.attribs.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                ModellerEntity.this.methods.getSelectionModel().clearSelection();
                ((BopComponent)ModellerEntity.this.getParent()).getParentBop().getControllerBop().binder().notifyTargets(ModellerEntity.this.getParent());
            }
        });
        this.label = new JLabel();
        this.add("North", this.label);
        this.add("Center", this.attribs);
        this.add("South", this.methods);
        this.setBorder(BorderFactory.createLineBorder(Color.black, 1));
        this.label.setText(title);
        this.methodListModel = new DefaultListModel();
        this.attribsModel = new DefaultListModel();
        this.label.setForeground(Color.black);
        this.label.setBackground(new Color(230, 230, 230));
        this.label.setOpaque(true);
        this.label.setHorizontalAlignment(0);
        this.attribs.setModel(this.attribsModel);
        this.methods.setModel(this.methodListModel);
        this.methodListModel.clear();
        this.attribsModel.clear();
    }

    public void adjustImage() {
        Image im;
        String img = this.getAssoc().getMetaSpec().getField("shape");
        if (img != null) {
            img = (String)shapeToIcon.get(img);
        }
        if (img != null && (im = NCApplication.GetImage(img)) != null) {
            ImageIcon imgIcon = new ImageIcon(im);
            this.label.setIcon(imgIcon);
        }
    }

    public ModelAssoc getAssoc() {
        return (ModelAssoc)((BopComponent)this.getParent()).getAssocObject();
    }

    public void readAssoc() {
        ModelAssoc assoc = this.getAssoc();
        int i = 0;
        while (i < assoc.getAttProps().size()) {
            if (this.attribsModel.size() <= i) {
                this.attribsModel.addElement(assoc.getAttributeItem(i));
            } else {
                this.attribsModel.setElementAt(assoc.getAttributeItem(i), i);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < assoc.getMethProps().size()) {
            if (this.methodListModel.size() <= i2) {
                this.methodListModel.addElement(assoc.getMethodItem(i2));
            } else {
                this.methodListModel.setElementAt(assoc.getMethodItem(i2), i2);
            }
            ++i2;
        }
        this.label.setText(assoc.getEntityTitle());
        this.adjustImage();
    }

    public boolean consumeEvent(AWTEvent e, LayoutableComponent comp) {
        if (e instanceof MouseEvent) {
            MouseEvent tmpMouseEvent = (MouseEvent)e;
            if (tmpMouseEvent.getClickCount() > 1) {
                if (((MouseEvent)e).getY() < this.label.getSize().height) {
                    this.setSize(this.getPreferredSize());
                    this.getParent().setSize(this.getPreferredSize());
                    this.doLayout();
                    this.getTopLevelAncestor().repaint();
                    return true;
                }
                this.methods.getSelectionModel().clearSelection();
                this.attribs.getSelectionModel().clearSelection();
                return true;
            }
            if (((MouseEvent)e).getY() - this.label.getY() > this.label.getSize().height && comp.isSelectedBop()) {
                if (tmpMouseEvent.getY() > this.methods.getY() && this.methods.isShowing()) {
                    tmpMouseEvent.translatePoint(-this.methods.getX(), -this.methods.getY());
                    this.methods.dispatchEvent(e);
                    tmpMouseEvent.translatePoint(this.methods.getX(), this.methods.getY());
                } else {
                    tmpMouseEvent.translatePoint(-this.attribs.getX(), -this.attribs.getY());
                    this.attribs.dispatchEvent(e);
                    tmpMouseEvent.translatePoint(this.attribs.getX(), this.attribs.getY());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public void setAttribs(JList attribs) {
        this.attribs = attribs;
    }

    public JList getAttribs() {
        return this.attribs;
    }

    public void setMethods(JList methods) {
        this.methods = methods;
    }

    public JList getMethods() {
        return this.methods;
    }

    public void removeSelected() {
        int i = 0;
        while ((i = this.methods.getSelectedIndex()) >= 0) {
            this.getAssoc().getMethProps().remove(i);
            this.methodListModel.remove(i);
        }
        while ((i = this.attribs.getSelectedIndex()) >= 0) {
            this.getAssoc().getAttProps().remove(i);
            this.attribsModel.remove(i);
        }
        this.readAssoc();
    }

    public void notifySelect(boolean b) {
        if (!b) {
            this.methSel = this.methods.getSelectedIndices();
            this.attSel = this.attribs.getSelectedIndices();
            this.methods.getSelectionModel().clearSelection();
            this.attribs.getSelectionModel().clearSelection();
        } else {
            this.methods.getSelectionModel().clearSelection();
            this.attribs.getSelectionModel().clearSelection();
            this.methods.setSelectedIndices(this.methSel);
            this.attribs.setSelectedIndices(this.attSel);
        }
    }

    public void clearAttribsAndMethods() {
        this.methodListModel.clear();
        this.attribsModel.clear();
        this.getAssoc().getAttProps().clear();
        this.getAssoc().getMethProps().clear();
    }

    public void getConnectionTarget(Object otherComp, int[] result, boolean in) {
        Rectangle myRect = this.getParent().getBounds();
        if (in) {
            result[0] = myRect.width / 2;
            result[1] = myRect.height / 2;
        } else {
            Component comp = (Component)otherComp;
            Rectangle rect = comp.getBounds();
            if (rect.x + rect.width / 2 > myRect.x + myRect.width / 2) {
                Rectangle item = this.attribs.getCellBounds(2, 2);
                if (item != null) {
                    result[0] = myRect.width - 4;
                    result[1] = item.y + item.height / 2;
                }
            } else {
                Rectangle item = this.attribs.getCellBounds(1, 1);
                if (item != null) {
                    result[0] = 4;
                    result[1] = item.y + item.height / 2;
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        shapeToIcon.put("DB", "/de/netcomputing/database/images/connection.gif");
        shapeToIcon.put("Table", "/de/netcomputing/database/images/table.gif");
        ModellerEntity.RegisterEntityClass("Comment", class$de$netcomputing$modeller$entities$CommentEntity == null ? (class$de$netcomputing$modeller$entities$CommentEntity = ModellerEntity.class$("de.netcomputing.modeller.entities.CommentEntity")) : class$de$netcomputing$modeller$entities$CommentEntity);
        ModellerEntity.RegisterEntityClass("Process", class$de$netcomputing$modeller$entities$ProcessEntity == null ? (class$de$netcomputing$modeller$entities$ProcessEntity = ModellerEntity.class$("de.netcomputing.modeller.entities.ProcessEntity")) : class$de$netcomputing$modeller$entities$ProcessEntity);
        ModellerEntity.RegisterEntityClass("Table", class$de$netcomputing$modeller$ModellerEntity == null ? (class$de$netcomputing$modeller$ModellerEntity = ModellerEntity.class$("de.netcomputing.modeller.ModellerEntity")) : class$de$netcomputing$modeller$ModellerEntity);
        ModellerEntity.RegisterEntityClass("Class", class$de$netcomputing$modeller$ModellerEntity == null ? (class$de$netcomputing$modeller$ModellerEntity = ModellerEntity.class$("de.netcomputing.modeller.ModellerEntity")) : class$de$netcomputing$modeller$ModellerEntity);
        ModellerEntity.RegisterEntityClass("Image", class$de$netcomputing$modeller$entities$ImageEntity == null ? (class$de$netcomputing$modeller$entities$ImageEntity = ModellerEntity.class$("de.netcomputing.modeller.entities.ImageEntity")) : class$de$netcomputing$modeller$entities$ImageEntity);
        ModellerEntity.RegisterEntityClass("DB", class$de$netcomputing$modeller$entities$DataBaseEntity == null ? (class$de$netcomputing$modeller$entities$DataBaseEntity = ModellerEntity.class$("de.netcomputing.modeller.entities.DataBaseEntity")) : class$de$netcomputing$modeller$entities$DataBaseEntity);
        ins = new Insets(2, 2, 2, 2);
    }
}

