/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.swingx;

import de.netcomputing.swingx.PanelEntry;
import de.netcomputing.swingx.StackPanel;
import de.netcomputing.swingx.StackPanelInfo;
import de.netcomputing.swingx.ToolBumps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class SubPanelStack
extends JPanel {
    ArrayList components = new ArrayList();
    boolean allowCollapse = true;

    public SubPanelStack() {
        this.setLayout(new FlowLayout(0, 0, 0));
    }

    public StackPanel addStackedComponent(JComponent comp, StackPanelInfo info) {
        return this.addStackedComponent(comp, info, false);
    }

    StackPanel addStackedComponent(JComponent comp, StackPanelInfo info, boolean horizontal) {
        JButton closeBtn = this.createCloseButton(comp.getMinimumSize().width, horizontal);
        StackPanel intermediate = new StackPanel(closeBtn, comp, info, horizontal);
        PanelEntry pe = new PanelEntry(comp, closeBtn, intermediate);
        MyMouseListener myml = new MyMouseListener(comp);
        closeBtn.addMouseListener(myml);
        closeBtn.addMouseMotionListener(myml);
        closeBtn.setToolTipText(info.getTitle());
        this.components.add(pe);
        return intermediate;
    }

    public void setAllowCollapse(boolean allowCollapse) {
        this.allowCollapse = allowCollapse;
    }

    public boolean getAllowCollapse() {
        return this.allowCollapse;
    }

    public void closeComponent(final JComponent comp) {
        JButton opnBtn;
        PanelEntry en = this.panelFor(comp);
        comp.setVisible(false);
        en.closeButton.setVisible(false);
        en.openButton = opnBtn = this.createOpenButton(en.closeButton.getHeight());
        this.add(opnBtn);
        opnBtn.setToolTipText(en.outerPanel.getInfo().getTitle());
        opnBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                SubPanelStack.this.openComponent(comp);
            }
        });
        en.outerPanel.getParent().invalidate();
        this.invalidate();
        this.repaint();
        en.outerPanel.getParent().repaint();
    }

    public void openComponent(JComponent comp) {
        PanelEntry en = this.panelFor(comp);
        comp.setVisible(true);
        en.closeButton.setVisible(true);
        this.remove(en.openButton);
        en.openButton = null;
        en.outerPanel.getParent().invalidate();
        en.outerPanel.getParent().repaint();
        this.invalidate();
        this.repaint();
    }

    public void remove(Component comp) {
        int i = 0;
        while (i < this.components.size()) {
            if (((PanelEntry)this.components.get((int)i)).outerPanel == comp) {
                this.components.remove(i);
                break;
            }
            ++i;
        }
        super.remove(comp);
    }

    PanelEntry panelFor(JComponent comp) {
        int i = this.indexOf(comp);
        if (i >= 0) {
            return (PanelEntry)this.components.get(i);
        }
        return null;
    }

    int indexOf(JComponent comp) {
        int i = 0;
        while (i < this.components.size()) {
            PanelEntry en = (PanelEntry)this.components.get(i);
            if (en.comp == comp) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public JButton createCloseButton(int width, boolean horizontal) {
        if (horizontal) {
            ToolBumps btn = new ToolBumps(false, true, 0);
            btn.setBorderPainted(false);
            btn.setFocusPainted(false);
            btn.setMargin(new Insets(0, 0, 0, 0));
            return btn;
        }
        ToolBumps btn = new ToolBumps(false, horizontal, 0);
        btn.setBorderPainted(false);
        btn.setBorder(BorderFactory.createLoweredBevelBorder());
        btn.setMargin(new Insets(1, 1, 1, 1));
        btn.setFocusPainted(false);
        btn.setOpaque(false);
        return btn;
    }

    protected JButton createOpenButton(int width) {
        ToolBumps btn = new ToolBumps(true, true, Math.min(width, this.getWidth() / this.components.size()));
        btn.setBorderPainted(false);
        btn.setFocusPainted(false);
        btn.setMargin(new Insets(0, 0, 0, 0));
        return btn;
    }

    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.getContentPane().setLayout(new BorderLayout(0, 0));
        SubPanelStack sbs = new SubPanelStack();
        jf.getContentPane().add("North", sbs);
        JButton south = new JButton("South");
        JButton center = new JButton("Center");
        jf.getContentPane().add("South", sbs.addStackedComponent(south, new StackPanelInfo("FELIX")));
        jf.getContentPane().add("Center", sbs.addStackedComponent(center, new StackPanelInfo("MOELLER")));
        jf.pack();
        jf.show();
    }

    class MyMouseListener
    implements MouseListener,
    MouseMotionListener {
        JComponent comp;
        boolean dragging = false;

        public MyMouseListener(JComponent c) {
            this.comp = c;
        }

        public void mouseDragged(MouseEvent e) {
            this.dragging = true;
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseReleased(MouseEvent ev) {
            if (SubPanelStack.this.allowCollapse && !this.dragging) {
                SubPanelStack.this.closeComponent(this.comp);
            }
            this.dragging = false;
        }
    }
}

