/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.templates.ejb;

import de.netcomputing.templates.ejb.EJBContext;
import de.netcomputing.util.NCStringUtilities;
import editapp.IndexEntry;

public class EJBMethodDescriptor {
    boolean isLocal;
    boolean isRemote;
    boolean isHome;
    IndexEntry indexEntry;
    boolean isEntity;
    String clazzName;
    EJBContext ctx;

    public EJBMethodDescriptor(IndexEntry indexEntry, EJBContext ctx) {
        this.indexEntry = indexEntry;
        this.ctx = ctx;
    }

    public EJBMethodDescriptor(boolean isLocal, boolean isRemote, boolean isHome, IndexEntry indexEntry, EJBContext ctx) {
        this.isLocal = isLocal;
        this.isRemote = isRemote;
        this.isHome = isHome;
        this.indexEntry = indexEntry;
        this.ctx = ctx;
    }

    public String getDeclString() {
        return this.getDeclString(false);
    }

    public String getDeclString(boolean local) {
        String res = this.indexEntry.decl().toExactString();
        if (this.getIsHome()) {
            String methodName;
            String newMethodName = methodName = this.indexEntry.getName();
            if (methodName.startsWith("ejbHome")) {
                newMethodName = methodName.substring("ejbHome".length());
                newMethodName = Character.toLowerCase(newMethodName.charAt(0)) + newMethodName.substring(1);
            } else if (methodName.startsWith("ejbFind")) {
                newMethodName = methodName.substring("ejb".length());
                newMethodName = Character.toLowerCase(newMethodName.charAt(0)) + newMethodName.substring(1);
                int idx = res.indexOf(" ");
                int endIdx = res.indexOf(" ", idx + 1);
                if (idx >= 0) {
                    res = res.substring(0, idx) + " " + this.clazzName.substring(0, this.clazzName.length() - "Bean".length()) + (local ? "Local" : "Remote") + res.substring(endIdx);
                }
            } else if (methodName.startsWith("ejbCreate")) {
                newMethodName = methodName.substring("ejb".length());
                newMethodName = Character.toLowerCase(newMethodName.charAt(0)) + newMethodName.substring(1);
                int idx = res.indexOf(" ");
                int endIdx = res.indexOf(" ", idx + 1);
                if (idx >= 0) {
                    res = res.substring(0, idx) + " " + this.clazzName.substring(0, this.clazzName.length() - "Bean".length()) + (local ? "Local" : "Remote") + res.substring(endIdx);
                }
            }
            res = NCStringUtilities.Replace(res, methodName, newMethodName);
        }
        return res;
    }

    public void setClazzName(String clazzName) {
        this.clazzName = clazzName;
    }

    public String getClazzName() {
        return this.clazzName;
    }

    public void setIsEntity(boolean isEntity) {
        this.isEntity = isEntity;
    }

    public boolean getIsEntity() {
        return this.isEntity;
    }

    public boolean getIsHome() {
        return this.isHome;
    }

    public boolean getIsLocal() {
        return this.isLocal;
    }

    public boolean getIsRemote() {
        return this.isRemote;
    }

    public void setIsHome(boolean isHome) {
        this.isHome = isHome;
    }

    public void setIsLocal(boolean isLocal) {
        this.isLocal = isLocal;
    }

    public void setIsRemote(boolean isRemote) {
        this.isRemote = isRemote;
    }

    public boolean isFinderMethod() {
        return this.indexEntry.getName().startsWith("ejbFind");
    }

    public boolean isCreationMethod() {
        return this.indexEntry.getName().startsWith("ejbCreate");
    }

    public void dump() {
        System.out.println("-----------------------------------------------------------------");
        System.out.println(">" + this.getDeclString() + "<");
        System.out.println("  isLocal:" + this.getIsLocal());
        System.out.println("  isHome:" + this.getIsHome());
        System.out.println("  isRemote:" + this.getIsRemote());
    }
}

