/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.connections;

import de.netcomputing.modeller.ModellerAssociation;
import de.netcomputing.util.connections.INConnection;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import jazzware.freestyle.JW2DMatrix;

public class ArrowConnection
implements INConnection {
    public static final int NONE = 0;
    public static final int ARROW = 1;
    public static final int RAUTE = 2;
    public static final int BIGARROW = 3;
    boolean fill = false;
    int leftShape = 1;
    int rightShape = 1;
    JW2DMatrix m = new JW2DMatrix();
    Polygon arrLeft = this.createArrowLeft();
    Polygon arrRight = this.createArrowLeft();
    Polygon rect = ArrowConnection.createRectangle(15);

    public ArrowConnection(int leftArrow, int rightArrow, boolean fill) {
        this();
        this.setLeftShape(leftArrow);
        this.setRightShape(rightArrow);
        this.fill = fill;
    }

    public ArrowConnection() {
    }

    public void setLeftShape(int leftShape) {
        this.leftShape = leftShape;
        switch (leftShape) {
            case 1: {
                this.arrLeft = this.createArrowLeft();
                break;
            }
            case 3: {
                this.arrLeft = this.createArrowLeft(150);
                break;
            }
            case 2: {
                this.arrLeft = this.createRauteLeft();
            }
        }
        this.m.transform(this.arrLeft);
        this.m.reset();
    }

    public int getLeftShape() {
        return this.leftShape;
    }

    public void setRightShape(int rightShape) {
        this.rightShape = rightShape;
        switch (rightShape) {
            case 1: {
                this.arrRight = this.createArrowLeft();
                break;
            }
            case 3: {
                this.arrRight = this.createArrowLeft(150);
                break;
            }
            case 2: {
                this.arrRight = this.createRauteLeft();
            }
        }
        this.m.rotate(Math.PI);
        this.m.transform(this.arrRight);
        this.m.reset();
    }

    public int getRightShape() {
        return this.rightShape;
    }

    protected Polygon createArrowLeft() {
        return this.createArrowLeft(100);
    }

    protected Polygon createArrowLeft(int size) {
        int[] x = new int[]{0, size, size, 0};
        int[] y = new int[]{0, size / 2, -size / 2, 0};
        return new Polygon(x, y, 4);
    }

    protected Polygon createRauteLeft() {
        return this.createRauteLeft(85, 60);
    }

    protected Polygon createRauteLeft(int sizX, int sizY) {
        int[] x = new int[]{0, sizX, sizX * 2, sizX, 0};
        int[] y = new int[]{0, sizY, 0, -sizY, 0};
        return new Polygon(x, y, 5);
    }

    public static Polygon createRectangle(int h) {
        int[] x = new int[]{0, 100, 100, 0};
        int[] y = new int[]{-h, -h, h, h};
        return new Polygon(x, y, 4);
    }

    public void draw(ModellerAssociation assoc, Graphics g, int x, int y, int x1, int y1) {
        double dx = x1 - x;
        double dy = y1 - y;
        double dist = Math.sqrt(dx * dx + dy * dy);
        int sign = y > y1 ? -1 : 1;
        this.m.reset();
        this.m.rotate((double)sign * Math.acos(dx / dist));
        Color primary = g.getColor();
        g.drawLine(x, y, x1, y1);
        if (this.leftShape > 0) {
            this.m.reset();
            this.m.rotate((double)sign * Math.acos(dx / dist));
            this.m.scale(0.13);
            Polygon al = new Polygon(this.arrLeft.xpoints, this.arrLeft.ypoints, this.arrLeft.npoints);
            this.m.transform(al);
            g.translate(x, y);
            if (this.fill) {
                g.fillPolygon(al);
            } else {
                g.setColor(Color.white);
                g.fillPolygon(al);
                g.setColor(primary);
                g.drawPolygon(al);
            }
            g.translate(-x, -y);
        }
        if (this.rightShape > 0) {
            this.m.reset();
            this.m.rotate((double)sign * Math.acos(dx / dist));
            this.m.scale(0.13);
            Polygon ar = new Polygon(this.arrRight.xpoints, this.arrRight.ypoints, this.arrRight.npoints);
            this.m.transform(ar);
            g.translate(x1, y1);
            if (this.fill) {
                g.fillPolygon(ar);
            } else {
                g.setColor(Color.white);
                g.fillPolygon(ar);
                g.setColor(primary);
                g.drawPolygon(ar);
            }
            g.translate(-x1, -y1);
        }
    }
}

